/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.parser;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import kalang.AmbiguousMethodException;
import kalang.AstNotFoundException;
import kalang.FieldNotFoundException;
import kalang.MethodNotFoundException;
import kalang.ast.AssignExpr;
import kalang.ast.AssignableExpr;
import kalang.ast.BlockStmt;
import kalang.ast.CastExpr;
import kalang.ast.ClassNode;
import kalang.ast.ConstExpr;
import kalang.ast.ElementExpr;
import kalang.ast.ExprNode;
import kalang.ast.ExprStmt;
import kalang.ast.IfStmt;
import kalang.ast.LocalVarNode;
import kalang.ast.LoopStmt;
import kalang.ast.MethodNode;
import kalang.ast.MultiStmtExpr;
import kalang.ast.NewArrayExpr;
import kalang.ast.NewObjectExpr;
import kalang.ast.ObjectFieldExpr;
import kalang.ast.ObjectInvokeExpr;
import kalang.ast.ParameterExpr;
import kalang.ast.ParameterNode;
import kalang.ast.Statement;
import kalang.ast.ThisExpr;
import kalang.ast.UnaryExpr;
import kalang.ast.VarDeclStmt;
import kalang.ast.VarExpr;
import kalang.compiler.AstLoader;
import kalang.compiler.TypeNameResolver;
import kalang.core.ArrayType;
import kalang.core.ClassType;
import kalang.core.MethodDescriptor;
import kalang.core.ObjectType;
import kalang.core.ParameterDescriptor;
import kalang.core.PrimitiveType;
import kalang.core.Type;
import kalang.core.Types;
import kalang.core.VarTable;
import kalang.tool.ClassWriter;
import kalang.tool.MemoryOutputManager;
import kalang.tool.OutputManager;
import kalang.util.AstUtil;
import kalang.util.BoxUtil;
import kalang.util.NameUtil;
import kalang.util.StringLiteralUtil;
import site.kason.tempera.engine.TemplateAstLoader;
import site.kason.tempera.engine.TemplateNotFoundException;
import site.kason.tempera.lex.LexException;
import site.kason.tempera.lexer.BufferedTokenStream;
import site.kason.tempera.lexer.TexLexer;
import site.kason.tempera.lexer.TexToken;
import site.kason.tempera.lexer.TexTokenStream;
import site.kason.tempera.lexer.TexTokenType;
import site.kason.tempera.lexer.TokenStream;
import site.kason.tempera.model.IterateContext;
import site.kason.tempera.parser.Exceptions;
import site.kason.tempera.parser.LexerException;
import site.kason.tempera.parser.ParseException;
import site.kason.tempera.parser.Renderer;
import site.kason.tempera.parser.SemanticException;
import site.kason.tempera.parser.TemplateClassLoader;
import site.kason.tempera.type.TypeParser;
import site.kason.tempera.util.OffsetUtil;

public class TemplateParser {
    private static int layoutNameCounter = 0;
    private TemplateAstLoader astLoader;
    private BufferedTokenStream tokenStream;
    private TexToken token;
    private ClassNode classNode;
    private Stack<MethodNode> methodStack = new Stack();
    private Stack<VarTable<String, LocalVarNode>> varTableStack = new Stack();
    private final List<ClassNode> classes = new LinkedList<ClassNode>();
    private Map<String, Type> nameToTypes = new HashMap<String, Type>();
    private final TemplateClassLoader classParser;
    private final TypeParser typePaser = new TypeParser();
    private final TypeNameResolver typeNameResolver;

    public TemplateParser(String templateName, String template, String leftDelimiter, String rightDelimiter, TemplateAstLoader astLoader, TemplateClassLoader classLoader) {
        this(templateName, new TexTokenStream(new TexLexer(template, leftDelimiter, rightDelimiter), 0), astLoader, classLoader);
    }

    public TemplateParser(String templateName, TokenStream ts, TemplateAstLoader templateAstLoader, TemplateClassLoader classParser) {
        this.classParser = classParser;
        this.astLoader = templateAstLoader;
        this.tokenStream = new BufferedTokenStream(ts);
        ClassNode cn = new ClassNode();
        cn.name = templateName;
        cn.modifier = 1;
        try {
            cn.superType = Types.getClassType((String)Renderer.class.getName());
        }
        catch (AstNotFoundException ex) {
            throw Exceptions.unknownException(ex);
        }
        AstUtil.createEmptyConstructor((ClassNode)cn);
        this.classNode = cn;
        this.classes.add(cn);
        this.typeNameResolver = new TypeNameResolver();
        this.typeNameResolver.setAstLoader(AstLoader.BASE_AST_LOADER);
        this.typeNameResolver.importPackage("java.lang");
        this.typeNameResolver.importPackage("java.util");
    }

    private String getDataFieldName(String fieldName) {
        return "this_" + fieldName;
    }

    private void createDataField(ClassNode clazz) {
        for (Map.Entry<String, Type> e : this.nameToTypes.entrySet()) {
            clazz.createField(e.getValue(), this.getDataFieldName(e.getKey()), 1);
        }
    }

    private Type scanType() throws SemanticException, LexException {
        ClassType type;
        TexToken typeToken = this.expect(TexTokenType.IDENTITY);
        String cn = typeToken.getText();
        while (this.isToken(TexTokenType.DOT)) {
            this.consume();
            typeToken = this.expect(TexTokenType.IDENTITY);
            cn = cn + "." + typeToken.getText();
        }
        String fullName = this.typeNameResolver.resolve(cn, this.classNode, this.classNode);
        if (fullName == null) {
            fullName = cn;
        }
        if (this.isToken(TexTokenType.LT)) {
            LinkedList<Type> pms = new LinkedList<Type>();
            do {
                this.consume();
                pms.add(this.scanType());
            } while (this.isToken(TexTokenType.COMMA));
            this.expect(TexTokenType.GT);
            try {
                type = Types.getClassType((ClassNode)this.astLoader.loadAst(fullName), (Type[])pms.toArray(new Type[pms.size()]));
            }
            catch (AstNotFoundException ex) {
                throw Exceptions.classNotFound(typeToken, fullName);
            }
        }
        try {
            type = Types.getClassType((ClassNode)this.astLoader.loadAst(fullName));
        }
        catch (AstNotFoundException ex) {
            throw Exceptions.classNotFound(typeToken, fullName);
        }
        while (this.isToken(TexTokenType.LBRACK)) {
            this.consume();
            this.expect(TexTokenType.RBRACK);
            type = Types.getArrayType((Type)type);
        }
        return type;
    }

    public Class<Renderer> parse() throws ParseException, IOException, TemplateNotFoundException {
        try {
            this.consume();
            while (this.isToken(TexTokenType.START_TAG) && this.isTokenLA(1, TexTokenType.VAR)) {
                this.consume(2);
                String name = this.expect(TexTokenType.IDENTITY).getText();
                this.expect(TexTokenType.COLON);
                this.setVarType(name, this.scanType());
                this.expect(TexTokenType.END_TAG);
            }
            this.createDataField(this.classNode);
            MethodNode md = this.classNode.createMethodNode((Type)Types.VOID_TYPE, "execute", 1);
            this.enterNewMethod(md);
            this.createBlockStmt(md.getBody());
            this.exitMethod();
        }
        catch (LexException ex) {
            throw new LexerException(ex.getOffset(), ex.getMessage());
        }
        MemoryOutputManager om = new MemoryOutputManager();
        ClassWriter writer = new ClassWriter((OutputManager)om);
        for (ClassNode c : this.classes) {
            writer.generate(c);
        }
        Class clazz = null;
        String mainTplName = this.classes.get((int)0).name;
        for (String c : om.getClassNames()) {
            Class clz = this.classParser.generateTemplateClass(c, om.getBytes(c));
            if (!mainTplName.equals(c)) continue;
            clazz = clz;
        }
        if (clazz == null) {
            throw Exceptions.unknownException("could not find the class object of template");
        }
        return clazz;
    }

    private void consume(int count) throws LexException {
        for (int i = 0; i < count; ++i) {
            this.consume();
        }
    }

    private void consume() throws LexException {
        this.token = this.tokenStream.nextToken();
    }

    private boolean isTokenLA(int count, TexTokenType ... type) throws LexException {
        return TemplateParser.isToken(this.tokenStream.LA(count), type);
    }

    private boolean isToken(TexTokenType ... type) {
        return TemplateParser.isToken(this.token, type);
    }

    private static boolean isToken(TexToken tk, TexTokenType ... type) {
        for (TexTokenType t : type) {
            if (!tk.getTokenType().equals((Object)t)) continue;
            return true;
        }
        return false;
    }

    public Statement[] body() throws LexException, IOException, TemplateNotFoundException {
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        while (!this.isToken(TexTokenType.EOF)) {
            Statement stmt = this.texStatement();
            if (stmt == null) {
                return stmts.toArray(new Statement[stmts.size()]);
            }
            stmts.add(stmt);
        }
        return stmts.toArray(new Statement[stmts.size()]);
    }

    private ExprNode getCallExpr(String methodNmae, ExprNode ... args) {
        return this.getCallExpr((ExprNode)new ThisExpr((ObjectType)Types.getClassType((ClassNode)this.classNode)), methodNmae, args);
    }

    private ExprNode getNamedExpr(TexToken token) {
        LocalVarNode var;
        String name = token.getText();
        VarTable<String, LocalVarNode> varTable = this.varTableStack.peek();
        if (varTable != null && (var = (LocalVarNode)varTable.get((Object)name)) != null) {
            return new VarExpr(var);
        }
        for (ParameterNode p : this.methodStack.peek().getParameters()) {
            if (!name.equals(p.getName())) continue;
            return new ParameterExpr(p);
        }
        if (this.classNode != null) {
            try {
                return ObjectFieldExpr.create((ExprNode)new ThisExpr(this.classNode), (String)this.getDataFieldName(name), (ClassNode)this.classNode);
            }
            catch (FieldNotFoundException fieldNotFoundException) {
                // empty catch block
            }
        }
        throw Exceptions.varUndefinedException(token);
    }

    private ExprNode getCallExpr(ExprNode target, String methodName, ExprNode ... args) {
        try {
            ObjectInvokeExpr expr = ObjectInvokeExpr.create((ExprNode)target, (String)methodName, (ExprNode[])args);
            return expr;
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unknownException(ex);
        }
    }

    private ExprStmt getCallStmt(String methodName, ExprNode ... exprs) {
        return new ExprStmt(this.getCallExpr(methodName, exprs));
    }

    private void expectEnclosdTag(TexTokenType type) throws LexException {
        this.expect(TexTokenType.START_TAG);
        this.expect(type);
        this.expect(TexTokenType.END_TAG);
    }

    private TexToken expect(TexTokenType type) throws LexException {
        if (!type.equals((Object)this.token.getTokenType())) {
            throw Exceptions.unexpectedToken(this.token, type);
        }
        TexToken tk = this.token;
        this.consume();
        return tk;
    }

    private Statement text() throws LexException {
        ExprStmt res = this.getCallStmt("append", new ExprNode[]{new ConstExpr((Object)this.token.getText())});
        this.consume();
        return res;
    }

    private Statement ifStmt() throws LexException, IOException, TemplateNotFoundException {
        this.expect(TexTokenType.START_TAG);
        this.expect(TexTokenType.IF);
        ExprNode condition = this.expr();
        if (condition == null) {
            throw Exceptions.unexpectedToken(this.token);
        }
        if (!Types.BOOLEAN_TYPE.equals(condition.getType())) {
            condition = this.getCallExpr("toBoolean", condition);
        }
        this.expect(TexTokenType.END_TAG);
        IfStmt ifStmt = new IfStmt(condition);
        this.createBlockStmt(ifStmt.getTrueBody());
        if (this.isToken(TexTokenType.START_TAG) && this.isTokenLA(1, TexTokenType.ELSE)) {
            this.consume(2);
            this.expect(TexTokenType.END_TAG);
            this.createBlockStmt(ifStmt.getFalseBody());
        }
        this.expectEnclosdTag(TexTokenType.END_IF);
        return ifStmt;
    }

    @Nullable
    private Type detectElementTypeForObjectType(@Nullable ObjectType type) {
        ClassNode typeClazz;
        if (type == null) {
            return null;
        }
        ClassNode iterableClazz = Types.getIterableClassType().getClassNode();
        if (iterableClazz.equals(typeClazz = type.getClassNode())) {
            Type[] argTypes = ((ClassType)type).getTypeArguments();
            if (argTypes == null || argTypes.length == 0) {
                return Types.getRootType();
            }
            return argTypes[0];
        }
        LinkedList<ObjectType> superTypes = new LinkedList<ObjectType>(Arrays.asList(type.getInterfaces()));
        superTypes.add(type.getSuperType());
        for (ObjectType t : superTypes) {
            Type v = this.detectElementTypeForObjectType(t);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Nullable
    private Type detectElementType(Type collectionType) {
        Type elecType;
        if (collectionType instanceof ArrayType) {
            return ((ArrayType)collectionType).getComponentType();
        }
        if (collectionType instanceof ObjectType && (elecType = this.detectElementTypeForObjectType((ObjectType)collectionType)) != null) {
            return elecType;
        }
        return null;
    }

    private Statement forStmt() throws LexException, IOException, TemplateNotFoundException {
        this.expect(TexTokenType.START_TAG);
        this.expect(TexTokenType.FOR);
        TexToken varToken = this.expect(TexTokenType.IDENTITY);
        TexToken contextToken = null;
        if (this.isToken(TexTokenType.COMMA)) {
            this.consume();
            contextToken = this.expect(TexTokenType.IDENTITY);
        }
        this.expect(TexTokenType.IN);
        ExprNode collectionExpr = this.expr();
        this.expect(TexTokenType.END_TAG);
        BlockStmt forStmt = new BlockStmt();
        LocalVarNode iteratorVar = this.declareLocalVar((Type)Types.requireClassType((String)IterateContext.class.getName()), contextToken == null ? null : contextToken.getText());
        forStmt.statements.add(new VarDeclStmt(iteratorVar));
        Type elementType = this.detectElementType(collectionExpr.getType());
        if (elementType == null) {
            throw Exceptions.notIterableType(collectionExpr.getType(), OffsetUtil.getOffsetOfExprNode(collectionExpr));
        }
        LocalVarNode iterTmpVar = this.declareLocalVar(elementType, varToken.getText());
        forStmt.statements.add(new VarDeclStmt(iterTmpVar));
        forStmt.statements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new VarExpr(iteratorVar), this.getCallExpr("createIterateContext", collectionExpr))));
        ExprNode loopCondition = this.getCallExpr((ExprNode)new VarExpr(iteratorVar), "hasNext", new ExprNode[0]);
        LoopStmt loopStmt = new LoopStmt(loopCondition, null);
        loopStmt.getLoopBody().statements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new VarExpr(iterTmpVar), (ExprNode)new CastExpr(elementType, this.getCallExpr((ExprNode)new VarExpr(iteratorVar), "next", new ExprNode[0])))));
        this.createBlockStmt(loopStmt.getLoopBody());
        forStmt.statements.add(loopStmt);
        this.expectEnclosdTag(TexTokenType.END_FOR);
        return forStmt;
    }

    private Statement placeholder() throws LexException, IOException, TemplateNotFoundException {
        this.expect(TexTokenType.START_TAG);
        this.expect(TexTokenType.PLACEHOLDER);
        TexToken id = this.expect(TexTokenType.IDENTITY);
        this.expect(TexTokenType.END_TAG);
        String methodName = this.createPlaceholderMethodName(id.getText());
        MethodNode m = this.classNode.createMethodNode((Type)Types.VOID_TYPE, methodName, 4);
        LocalVarNode[] accessibleVars = this.getAllAccessibleVars();
        VarExpr[] arguments = new VarExpr[accessibleVars.length];
        for (int i = 0; i < accessibleVars.length; ++i) {
            m.createParameter(accessibleVars[i].getType(), accessibleVars[i].getName());
            arguments[i] = new VarExpr(accessibleVars[i]);
        }
        this.enterNewMethod(m);
        this.createBlockStmt(m.getBody());
        this.exitMethod();
        this.expectEnclosdTag(TexTokenType.END_PLACEHOLDER);
        try {
            return new ExprStmt((ExprNode)ObjectInvokeExpr.create((ExprNode)new ThisExpr(this.classNode), (String)methodName, (ExprNode[])arguments));
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unknownException(ex);
        }
    }

    private Statement layout() throws LexException, TemplateNotFoundException, IOException {
        this.expect(TexTokenType.START_TAG);
        this.expect(TexTokenType.LAYOUT);
        TexToken parentId = this.expect(TexTokenType.IDENTITY);
        this.expect(TexTokenType.END_TAG);
        ClassNode parentAst = this.astLoader.loadTemplateAst(parentId.getText());
        ClassNode oldClass = this.classNode;
        String clazzName = this.createClassNameForLayout(parentId.getText());
        ClassNode layoutClass = this.classNode = new ClassNode(clazzName, 1);
        this.createDataField(layoutClass);
        this.classes.add(layoutClass);
        this.classNode.superType = Types.getClassType((ClassNode)parentAst);
        this.body();
        AstUtil.createEmptyConstructor((ClassNode)this.classNode);
        this.classNode = oldClass;
        this.expectEnclosdTag(TexTokenType.END_LAYOUT);
        try {
            return new ExprStmt((ExprNode)ObjectInvokeExpr.create((ExprNode)new NewObjectExpr((ObjectType)Types.getClassType((ClassNode)layoutClass), new ExprNode[0]), (String)"render", (ExprNode[])new ExprNode[]{ObjectFieldExpr.create((ExprNode)new ThisExpr(this.classNode), (String)"data", (ClassNode)this.classNode), ObjectFieldExpr.create((ExprNode)new ThisExpr(this.classNode), (String)"writer", (ClassNode)this.classNode), ObjectFieldExpr.create((ExprNode)new ThisExpr(this.classNode), (String)"renderContext", (ClassNode)this.classNode)}));
        }
        catch (AmbiguousMethodException | FieldNotFoundException | MethodNotFoundException ex) {
            throw Exceptions.unknownException(ex);
        }
    }

    private Statement replace() throws LexException, IOException, TemplateNotFoundException {
        this.expect(TexTokenType.START_TAG);
        this.expect(TexTokenType.REPLACE);
        TexToken replaceToken = this.expect(TexTokenType.IDENTITY);
        this.expect(TexTokenType.END_TAG);
        String replaceId = replaceToken.getText();
        String replateMethodName = this.createPlaceholderMethodName(replaceId);
        ObjectType superType = this.classNode.superType;
        if (superType == null) {
            throw Exceptions.unknownException("super type is null");
        }
        MethodNode overrideMethod = null;
        for (MethodDescriptor sm : superType.getMethodDescriptors(this.classNode, true, true)) {
            if (!replateMethodName.equals(sm.getName())) continue;
            overrideMethod = this.classNode.createMethodNode(sm.getReturnType(), sm.getName(), sm.getModifier());
            this.enterNewMethod(overrideMethod);
            for (ParameterDescriptor p : sm.getParameterDescriptors()) {
                overrideMethod.createParameter(p.getType(), p.getName());
            }
            break;
        }
        if (overrideMethod == null) {
            throw new SemanticException(replaceToken.getOffset(), "placeholder not found:" + replaceId);
        }
        this.createBlockStmt(overrideMethod.getBody());
        this.expectEnclosdTag(TexTokenType.END_REPLACE);
        this.exitMethod();
        return new BlockStmt();
    }

    @Nullable
    public Statement texStatement() throws LexException, IOException, TemplateNotFoundException {
        switch (this.token.getTokenType()) {
            case TEXT: {
                return this.text();
            }
            case START_TAG: {
                return this.nonTextStatement();
            }
        }
        return null;
    }

    @Nullable
    private Statement nonTextStatement() throws LexException, IOException {
        if (!this.isToken(TexTokenType.START_TAG)) {
            throw Exceptions.unexpectedToken(this.token);
        }
        TexToken la1 = this.tokenStream.LA(1);
        switch (la1.getTokenType()) {
            case IF: {
                return this.ifStmt();
            }
            case FOR: {
                return this.forStmt();
            }
            case PLACEHOLDER: {
                return this.placeholder();
            }
            case LAYOUT: {
                return this.layout();
            }
            case REPLACE: {
                return this.replace();
            }
        }
        if (this.isExprPrefix(la1.getTokenType())) {
            ExprStmt res;
            this.expect(TexTokenType.START_TAG);
            ExprNode expr = this.expr();
            if (this.isToken(TexTokenType.PIPE)) {
                while (this.isToken(TexTokenType.PIPE)) {
                    this.consume();
                    String filterName = this.expect(TexTokenType.IDENTITY).getText();
                    expr = this.getCallExpr("callFilter", new ExprNode[]{new ConstExpr((Object)filterName), expr});
                }
                res = this.getCallStmt("rawAppend", expr);
            } else {
                res = this.getCallStmt("append", expr);
            }
            this.expect(TexTokenType.END_TAG);
            return res;
        }
        return null;
    }

    private boolean isExprPrefix(TexTokenType type) {
        TexTokenType[] prefixArray;
        for (TexTokenType t : prefixArray = new TexTokenType[]{TexTokenType.LPAREN, TexTokenType.IDENTITY, TexTokenType.NUMBER, TexTokenType.STRING, TexTokenType.LOGIC_NOT, TexTokenType.LBRACK, TexTokenType.LBRACE, TexTokenType.SUB}) {
            if (!t.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    private ExprNode expr() throws LexException {
        ExprNode expr = this.expr_logic_and_or();
        if (this.isToken(TexTokenType.CONDITIONAL)) {
            this.consume();
            LinkedList<Object> statements = new LinkedList<Object>();
            LocalVarNode conditionalVar = new LocalVarNode((Type)Types.getRootType(), null);
            LocalVarNode valueVar = new LocalVarNode((Type)Types.getRootType(), null);
            statements.add(new VarDeclStmt(Arrays.asList(conditionalVar, valueVar)));
            statements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new VarExpr(conditionalVar), expr)));
            BlockStmt trueStmt = new BlockStmt();
            BlockStmt falseStmt = new BlockStmt();
            Object trueExpr = this.isExprPrefix(this.token.getTokenType()) ? this.expr() : new VarExpr(conditionalVar);
            this.expect(TexTokenType.COLON);
            ExprNode falseExpr = this.expr();
            trueStmt.statements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new VarExpr(valueVar), trueExpr)));
            falseStmt.statements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new VarExpr(valueVar), falseExpr)));
            IfStmt ifStmt = new IfStmt(this.getCallExpr("toBoolean", new ExprNode[]{new VarExpr(conditionalVar)}), trueStmt, falseStmt);
            statements.add(ifStmt);
            return new MultiStmtExpr(statements, (ExprNode)new VarExpr(valueVar));
        }
        return expr;
    }

    public void setVarType(String key, Type type) {
        this.nameToTypes.put(key, type);
    }

    public void setVarType(String key, String type) throws ParseException, LexException {
        try {
            this.nameToTypes.put(key, this.typePaser.parse(type));
        }
        catch (AstNotFoundException ex) {
            throw Exceptions.classNotFound(type);
        }
    }

    private ExprNode expr_logic_and_or() throws LexException {
        ExprNode expr1 = this.expr_equals();
        if (this.isToken(TexTokenType.LOGIC_AND)) {
            this.consume();
            ExprNode expr2 = this.expr_equals();
            return this.getCallExpr("and", expr1, expr2);
        }
        if (this.isToken(TexTokenType.LOGIC_OR)) {
            this.consume();
            ExprNode expr2 = this.expr_equals();
            return this.getCallExpr("or", expr1, expr2);
        }
        return expr1;
    }

    private ExprNode expr_equals() throws LexException {
        ExprNode expr = this.expr_add_sub();
        if (this.isToken(TexTokenType.EQ)) {
            this.consume();
            return this.getCallExpr("eq", expr, this.expr_mul_div_mod());
        }
        if (this.isToken(TexTokenType.LT)) {
            this.consume();
            return this.getCallExpr("lt", expr, this.expr_mul_div_mod());
        }
        if (this.isToken(TexTokenType.LE)) {
            this.consume();
            return this.getCallExpr("le", expr, this.expr_mul_div_mod());
        }
        if (this.isToken(TexTokenType.GT)) {
            this.consume();
            return this.getCallExpr("gt", expr, this.expr_mul_div_mod());
        }
        if (this.isToken(TexTokenType.GE)) {
            this.consume();
            return this.getCallExpr("ge", expr, this.expr_mul_div_mod());
        }
        if (this.isToken(TexTokenType.NE)) {
            this.consume();
            return this.getCallExpr("ne", expr, this.expr_mul_div_mod());
        }
        return expr;
    }

    private ExprNode expr_add_sub() throws LexException {
        ExprNode factor = this.expr_mul_div_mod();
        if (this.isToken(TexTokenType.ADD)) {
            this.consume();
            ExprNode factor2 = this.expr_mul_div_mod();
            return this.getCallExpr("add", factor, factor2);
        }
        if (this.isToken(TexTokenType.SUB)) {
            this.consume();
            ExprNode factor2 = this.expr_mul_div_mod();
            return this.getCallExpr("sub", factor, factor2);
        }
        return factor;
    }

    private ExprNode expr_mul_div_mod() throws LexException {
        ExprNode atom = this.atom();
        if (this.isToken(TexTokenType.MUL)) {
            this.consume();
            ExprNode atom2 = this.atom();
            return this.getCallExpr("mul", atom, atom2);
        }
        if (this.isToken(TexTokenType.DIV)) {
            this.consume();
            ExprNode atom2 = this.atom();
            return this.getCallExpr("div", atom, atom2);
        }
        if (this.isToken(TexTokenType.MOD)) {
            this.consume();
            ExprNode atom2 = this.atom();
            return this.getCallExpr("mod", atom, atom2);
        }
        return atom;
    }

    @Nullable
    private ExprNode detectPropertyExpr(ExprNode expr, String property) {
        try {
            return ObjectFieldExpr.create((ExprNode)expr, (String)property, (ClassNode)this.classNode);
        }
        catch (FieldNotFoundException ex) {
            try {
                return ObjectInvokeExpr.create((ExprNode)expr, (String)property, (ExprNode[])new ExprNode[0]);
            }
            catch (AmbiguousMethodException | MethodNotFoundException ex1) {
                try {
                    return ObjectInvokeExpr.create((ExprNode)expr, (String)("get" + NameUtil.firstCharToUpperCase((String)property)), (ExprNode[])new ExprNode[0]);
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex2) {
                    try {
                        return ObjectInvokeExpr.create((ExprNode)expr, (String)("is" + NameUtil.firstCharToUpperCase((String)property)), (ExprNode[])new ExprNode[0]);
                    }
                    catch (AmbiguousMethodException | MethodNotFoundException ex3) {
                        return null;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExprNode atom() throws LexException {
        ExprNode expr;
        if (this.isToken(TexTokenType.LPAREN)) {
            this.consume();
            expr = this.expr();
            this.expect(TexTokenType.RPAREN);
        } else if (this.isToken(TexTokenType.IDENTITY)) {
            if (this.isTokenLA(1, TexTokenType.LPAREN)) {
                String funcName = this.token.getText();
                this.consume(2);
                LinkedList<ExprNode> argsList = new LinkedList<ExprNode>();
                if (this.isExprPrefix(this.token.getTokenType())) {
                    argsList.add(this.expr());
                }
                while (this.isToken(TexTokenType.COMMA)) {
                    this.consume();
                    argsList.add(this.expr());
                }
                this.expect(TexTokenType.RPAREN);
                LinkedList<Object> initStatements = new LinkedList<Object>();
                LocalVarNode argVar = new LocalVarNode((Type)Types.getArrayType((Type)Types.getRootType()), null);
                initStatements.add(new VarDeclStmt(argVar));
                initStatements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new VarExpr(argVar), (ExprNode)new NewArrayExpr((Type)Types.getRootType(), (ExprNode)new ConstExpr((Object)argsList.size())))));
                for (int i = 0; i < argsList.size(); ++i) {
                    initStatements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new ElementExpr((ExprNode)new VarExpr(argVar), (ExprNode)new ConstExpr((Object)i)), (ExprNode)argsList.get(i))));
                }
                return this.getCallExpr("callFunction", new ExprNode[]{new ConstExpr((Object)funcName), new MultiStmtExpr(initStatements, (ExprNode)new VarExpr(argVar))});
            }
            expr = this.getNamedExpr(this.token);
            this.consume();
        } else if (this.isToken(TexTokenType.NUMBER)) {
            String text = this.token.getText();
            expr = text.contains(".") ? new ConstExpr((Object)Double.parseDouble(text)) : new ConstExpr((Object)StringLiteralUtil.parseLong((String)text));
            this.consume();
        } else if (this.isToken(TexTokenType.STRING)) {
            String tokenText = this.token.getText();
            expr = new ConstExpr((Object)TexLexer.LITERAL_PARSER.parse(tokenText.substring(1, tokenText.length() - 1)));
            this.consume();
        } else if (this.isToken(TexTokenType.LOGIC_NOT)) {
            this.consume();
            ExprNode val = this.getCallExpr("toBoolean", this.atom());
            expr = new UnaryExpr(val, "!");
        } else if (this.isToken(TexTokenType.SUB)) {
            this.consume();
            ExprNode val = this.expr();
            Type valType = val.getType();
            if (Types.isNumberPrimitive((Type)valType)) {
                expr = new UnaryExpr(val, "-");
            } else {
                if (!Types.isNumberClass((Type)valType)) throw new SemanticException(OffsetUtil.getOffsetOfExprNode(val), "number type required.");
                PrimitiveType primitiveType = Types.getPrimitiveType((ObjectType)((ClassType)valType));
                if (primitiveType == null) {
                    throw Exceptions.unknownException("primitive type not found");
                }
                expr = new UnaryExpr(BoxUtil.assign((ExprNode)val, (Type)valType, (Type)primitiveType), "-");
            }
        } else if (this.isToken(TexTokenType.LBRACK)) {
            this.consume();
            LinkedList<Object> statements = new LinkedList<Object>();
            LinkedList<ExprNode> elements = new LinkedList<ExprNode>();
            elements.add(this.expr());
            while (this.isToken(TexTokenType.COMMA)) {
                this.consume();
                elements.add(this.expr());
            }
            this.expect(TexTokenType.RBRACK);
            LocalVarNode arrVar = new LocalVarNode((Type)Types.getArrayType((Type)Types.getRootType()), null);
            statements.add(new VarDeclStmt(arrVar));
            NewArrayExpr newArrExpr = new NewArrayExpr((Type)Types.getRootType(), (ExprNode)new ConstExpr((Object)elements.size()));
            statements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new VarExpr(arrVar), (ExprNode)newArrExpr)));
            for (int i = 0; i < elements.size(); ++i) {
                statements.add(new ExprStmt((ExprNode)new AssignExpr((AssignableExpr)new ElementExpr((ExprNode)new VarExpr(arrVar), (ExprNode)new ConstExpr((Object)i)), (ExprNode)elements.get(i))));
            }
            expr = new MultiStmtExpr(statements, (ExprNode)new VarExpr(arrVar));
        } else {
            if (!this.isToken(TexTokenType.LBRACE)) throw Exceptions.unexpectedToken(this.token);
            throw Exceptions.unexpectedToken(this.token);
        }
        while (this.isToken(TexTokenType.DOT) || this.isToken(TexTokenType.ARROW)) {
            boolean isDot = this.isToken(TexTokenType.DOT);
            this.consume();
            TexToken propertyToken = this.expect(TexTokenType.IDENTITY);
            String property = propertyToken.getText();
            expr = isDot ? this.detectPropertyExpr(expr, property) : this.getCallExpr("readProperty", new ExprNode[]{expr, new ConstExpr((Object)property)});
            if (expr != null) continue;
            throw Exceptions.propertyNotFound(propertyToken);
        }
        Type exprType = expr.getType();
        if (!(exprType instanceof PrimitiveType)) return expr;
        ObjectType exprClassType = Types.getClassType((PrimitiveType)((PrimitiveType)exprType));
        if (exprClassType != null) return BoxUtil.assign((ExprNode)expr, (Type)exprType, (Type)exprClassType);
        throw new RuntimeException("could not find class type for primitive type:" + exprType);
    }

    private void enterNewFrame() {
        VarTable<String, LocalVarNode> varTable = this.varTableStack.peek();
        this.varTableStack.add((VarTable<String, LocalVarNode>)varTable.newStack());
    }

    private void exitFrame() {
        this.varTableStack.pop();
    }

    private void createBlockStmt(BlockStmt blockStmt) throws LexException, IOException, TemplateNotFoundException {
        this.enterNewFrame();
        Statement[] stmts = this.body();
        this.exitFrame();
        blockStmt.statements.addAll(Arrays.asList(stmts));
    }

    private LocalVarNode declareLocalVar(Type type, @Nullable String name) {
        LocalVarNode var = new LocalVarNode(type, name);
        if (name != null) {
            this.varTableStack.peek().put((Object)name, (Object)var);
        }
        return var;
    }

    private LocalVarNode[] getAllAccessibleVars() {
        LinkedList<LocalVarNode> vars = new LinkedList<LocalVarNode>();
        for (VarTable vtb = this.varTableStack.peek(); vtb != null; vtb = vtb.getParent()) {
            for (LocalVarNode v : vtb.values()) {
                vars.add(v);
            }
        }
        return vars.toArray(new LocalVarNode[vars.size()]);
    }

    private String createClassNameForLayout(String layoutName) {
        return this.classNode.name + "_" + layoutName + layoutNameCounter++;
    }

    private String createPlaceholderMethodName(String placeholderName) {
        return "placeholder_" + placeholderName;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    private void enterNewMethod(MethodNode method) {
        this.methodStack.add(method);
        this.varTableStack.add((VarTable<String, LocalVarNode>)new VarTable());
    }

    private void exitMethod() {
        this.methodStack.pop();
        this.varTableStack.pop();
    }
}

