/*
 * Decompiled with CFR 0.152.
 */
package kamons.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class StatusBar {
    private int statusCharCount = 0;
    private String statusText;

    public void output(String content) {
        this.clearStatus();
        this.print(content);
        this.status(this.statusText);
    }

    public void clearStatus() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.statusCharCount; ++i) {
            sb.append("\b");
        }
        this.print(sb.toString());
    }

    private void print(String content) {
        System.out.print(content);
    }

    public void status(String content) {
        this.clearStatus();
        try {
            StringReader sr = new StringReader(content);
            BufferedReader br = new BufferedReader(sr);
            this.statusText = br.readLine();
            this.print(this.statusText);
            this.statusCharCount = this.statusText.length();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

