/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter;

import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.formatter.FormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.I18nFormatterAnalysis;
import org.checkerframework.checker.i18nformatter.I18nFormatterAnnotatedTypeFactory;
import org.checkerframework.checker.i18nformatter.I18nFormatterChecker;
import org.checkerframework.checker.i18nformatter.I18nFormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.qual.I18nConversionCategory;
import org.checkerframework.checker.i18nformatter.qual.I18nInvalidFormat;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.FlowExpressionParseUtil;

public class I18nFormatterTransfer
extends CFAbstractTransfer<CFValue, CFStore, I18nFormatterTransfer> {
    protected I18nFormatterAnalysis analysis;
    protected I18nFormatterChecker checker;

    public I18nFormatterTransfer(I18nFormatterAnalysis analysis, I18nFormatterChecker checker) {
        super(analysis);
        this.analysis = analysis;
        this.checker = checker;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode node, TransferInput<CFValue, CFStore> in) {
        I18nFormatterAnnotatedTypeFactory atypeFactory = (I18nFormatterAnnotatedTypeFactory)this.analysis.getTypeFactory();
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(node, in);
        I18nFormatterTreeUtil tu = atypeFactory.treeUtil;
        if (tu.isHasFormatCall(node, atypeFactory)) {
            CFStore thenStore = result.getRegularStore();
            CFStore elseStore = (CFStore)thenStore.copy();
            ConditionalTransferResult<CFValue, CFStore> newResult = new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), thenStore, elseStore);
            FlowExpressionParseUtil.FlowExpressionContext context = FlowExpressionParseUtil.buildFlowExprContextForUse(node, atypeFactory.getContext());
            try {
                FlowExpressions.Receiver firstParam = FlowExpressionParseUtil.parse("#1", context, atypeFactory.getPath(node.getTree()));
                FormatterTreeUtil.Result<I18nConversionCategory[]> cats = tu.getHasFormatCallCategories(node);
                if (cats.value() == null) {
                    tu.failure(cats, "i18nformat.indirect.arguments", new Object[0]);
                } else {
                    AnnotationMirror anno = atypeFactory.treeUtil.categoriesToFormatAnnotation(cats.value());
                    thenStore.insertValue(firstParam, anno);
                }
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException firstParam) {
                // empty catch block
            }
            return newResult;
        }
        if (tu.isIsFormatCall(node, atypeFactory)) {
            CFStore thenStore = result.getRegularStore();
            CFStore elseStore = (CFStore)thenStore.copy();
            ConditionalTransferResult<CFValue, CFStore> newResult = new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), thenStore, elseStore);
            FlowExpressionParseUtil.FlowExpressionContext context = FlowExpressionParseUtil.buildFlowExprContextForUse(node, atypeFactory.getContext());
            try {
                FlowExpressions.Receiver firstParam = FlowExpressionParseUtil.parse("#1", context, atypeFactory.getPath(node.getTree()));
                AnnotationBuilder builder = new AnnotationBuilder(tu.processingEnv, I18nInvalidFormat.class.getCanonicalName());
                builder.setValue((CharSequence)"value", "");
                elseStore.insertValue(firstParam, builder.build());
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
                // empty catch block
            }
            return newResult;
        }
        if (tu.isMakeFormatCall(node, atypeFactory)) {
            FormatterTreeUtil.Result<I18nConversionCategory[]> cats = tu.makeFormatCallCategories(node, atypeFactory);
            if (cats.value() == null) {
                tu.failure(cats, "i18nformat.key.not.found", new Object[0]);
            } else {
                AnnotationMirror anno = atypeFactory.treeUtil.categoriesToFormatAnnotation(cats.value());
                CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(anno, result.getResultValue().getType().getUnderlyingType());
                return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
            }
        }
        return result;
    }
}

