/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value.util;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.javacutil.TypesUtils;

public class NumberUtils {
    public static List<? extends Number> castNumbers(TypeMirror type, List<? extends Number> numbers) {
        TypeKind typeKind = NumberUtils.unBoxPrimative(type);
        switch (typeKind) {
            case BYTE: {
                ArrayList<Byte> bytes = new ArrayList<Byte>();
                for (Number number : numbers) {
                    bytes.add(number.byteValue());
                }
                return bytes;
            }
            case DOUBLE: {
                ArrayList<Double> doubles = new ArrayList<Double>();
                for (Number number : numbers) {
                    doubles.add(number.doubleValue());
                }
                return doubles;
            }
            case FLOAT: {
                ArrayList<Float> arrayList = new ArrayList<Float>();
                for (Number number : numbers) {
                    arrayList.add(Float.valueOf(number.floatValue()));
                }
                return arrayList;
            }
            case INT: {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (Number number : numbers) {
                    arrayList.add(number.intValue());
                }
                return arrayList;
            }
            case LONG: {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (Number number : numbers) {
                    arrayList.add(number.longValue());
                }
                return arrayList;
            }
            case SHORT: {
                ArrayList<Short> arrayList = new ArrayList<Short>();
                for (Number number : numbers) {
                    arrayList.add(number.shortValue());
                }
                return arrayList;
            }
        }
        throw new UnsupportedOperationException(typeKind.toString());
    }

    private static TypeKind unBoxPrimative(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            String stringType;
            switch (stringType = TypesUtils.getQualifiedName((DeclaredType)type).toString()) {
                case "java.lang.Byte": {
                    return TypeKind.BYTE;
                }
                case "java.lang.Boolean": {
                    return TypeKind.BOOLEAN;
                }
                case "java.lang.Charater": {
                    return TypeKind.CHAR;
                }
                case "java.lang.Double": {
                    return TypeKind.DOUBLE;
                }
                case "java.lang.Float": {
                    return TypeKind.FLOAT;
                }
                case "java.lang.Integer": {
                    return TypeKind.INT;
                }
                case "java.lang.Long": {
                    return TypeKind.LONG;
                }
                case "java.lang.Short": {
                    return TypeKind.SHORT;
                }
            }
        }
        return type.getKind();
    }
}

