/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.AbstractProcessor;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestConfigurationBuilder;
import org.checkerframework.framework.test.TestSuite;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.framework.test.TypecheckExecutor;
import org.checkerframework.framework.test.TypecheckResult;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=TestSuite.class)
public abstract class CheckerFrameworkTest {
    protected final File testFile;
    protected final String checkerName;
    protected final String checkerDir;
    protected final List<String> checkerOptions;

    public CheckerFrameworkTest(File testFile, Class<? extends AbstractProcessor> checker, String checkerDir, String ... checkerOptions) {
        this.testFile = testFile;
        this.checkerName = checker.getName();
        this.checkerDir = "tests" + File.separator + checkerDir;
        this.checkerOptions = Arrays.asList(checkerOptions);
    }

    @Test
    public void run() {
        boolean shouldEmitDebugInfo = TestUtilities.getShouldEmitDebugInfo();
        List<String> customizedOptions = this.customizeOptions(Collections.unmodifiableList(this.checkerOptions));
        TestConfiguration config = TestConfigurationBuilder.buildDefaultConfiguration(this.checkerDir, this.testFile, this.checkerName, customizedOptions, shouldEmitDebugInfo);
        TypecheckResult testResult = new TypecheckExecutor().runTest(config);
        TestUtilities.assertResultsAreValid(testResult);
    }

    public List<String> customizeOptions(List<String> previousOptions) {
        return previousOptions;
    }
}

