/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.tools.JavaFileObject;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticLine;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticUtils;

public class JavaDiagnosticReader
implements Iterator<TestDiagnosticLine> {
    public static DiagnosticCodec JAVA_COMMENT_CODEC = new DiagnosticCodec(){

        @Override
        public TestDiagnosticLine convertLine(long lineNumber, String line) {
            return TestDiagnosticUtils.fromJavaSourceLine(line, lineNumber);
        }
    };
    public static DiagnosticCodec DIAGNOSTIC_FILE_CODEC = new DiagnosticCodec(){

        @Override
        public TestDiagnosticLine convertLine(long lineNumber, String line) {
            return TestDiagnosticUtils.fromDiagnosticFileLine(line);
        }
    };
    public final File toRead;
    public final JavaFileObject toReadFileObject;
    public final DiagnosticCodec codec;
    private boolean initialized = false;
    private boolean closed = false;
    private LineNumberReader reader = null;
    public String nextLine = null;
    public int nextLineNumber = -1;

    public static List<TestDiagnosticLine> readDiagnostics(File toRead, DiagnosticCodec codec, boolean omitEmptyDiagnostics) {
        ArrayList<TestDiagnosticLine> lines = new ArrayList<TestDiagnosticLine>();
        JavaDiagnosticReader reader = new JavaDiagnosticReader(toRead, codec);
        while (reader.hasNext()) {
            TestDiagnosticLine line = reader.next();
            if (omitEmptyDiagnostics && !line.hasDiagnostics()) continue;
            lines.add(line);
        }
        reader.close();
        return lines;
    }

    public static List<TestDiagnosticLine> readDiagnostics(File toRead, boolean omitEmptyDiagnostics) {
        return JavaDiagnosticReader.readDiagnostics(toRead, JAVA_COMMENT_CODEC, omitEmptyDiagnostics);
    }

    public static List<TestDiagnosticLine> readDiagnosticLines(Iterable<File> toRead, boolean omitEmptyDiagnostics) {
        ArrayList<TestDiagnosticLine> lines = new ArrayList<TestDiagnosticLine>();
        for (File file : toRead) {
            lines.addAll(JavaDiagnosticReader.readDiagnostics(file, omitEmptyDiagnostics));
        }
        return lines;
    }

    public static List<TestDiagnostic> readDiagnostics(Iterable<File> toRead, boolean omitEmptyDiagnostics) {
        List<TestDiagnosticLine> lines = JavaDiagnosticReader.readDiagnosticLines(toRead, omitEmptyDiagnostics);
        ArrayList<TestDiagnostic> diagnostics = new ArrayList<TestDiagnostic>((int)((double)lines.size() + (double)lines.size() * 0.1));
        for (TestDiagnosticLine line : lines) {
            diagnostics.addAll(line.getDiagnostics());
        }
        return diagnostics;
    }

    public static List<TestDiagnosticLine> readDiagnosticsJfo(JavaFileObject toRead, boolean omitEmptyDiagnostics) {
        ArrayList<TestDiagnosticLine> lines = new ArrayList<TestDiagnosticLine>();
        JavaDiagnosticReader reader = new JavaDiagnosticReader(toRead, JAVA_COMMENT_CODEC);
        while (reader.hasNext()) {
            TestDiagnosticLine line = reader.next();
            if (omitEmptyDiagnostics && !line.hasDiagnostics()) continue;
            lines.add(line);
        }
        reader.close();
        return lines;
    }

    public static List<TestDiagnosticLine> readExpectedDiagnosticLinesJfo(Iterable<? extends JavaFileObject> toRead, boolean omitEmptyDiagnostics) {
        ArrayList<TestDiagnosticLine> lines = new ArrayList<TestDiagnosticLine>();
        for (JavaFileObject javaFileObject : toRead) {
            lines.addAll(JavaDiagnosticReader.readDiagnosticsJfo(javaFileObject, omitEmptyDiagnostics));
        }
        return lines;
    }

    public static List<TestDiagnostic> readExpectedDiagnosticsJfo(Iterable<? extends JavaFileObject> toRead, boolean omitEmptyDiagnostics) {
        List<TestDiagnosticLine> lines = JavaDiagnosticReader.readExpectedDiagnosticLinesJfo(toRead, omitEmptyDiagnostics);
        ArrayList<TestDiagnostic> diagnostics = new ArrayList<TestDiagnostic>((int)((double)lines.size() + (double)lines.size() * 0.1));
        for (TestDiagnosticLine line : lines) {
            diagnostics.addAll(line.getDiagnostics());
        }
        return diagnostics;
    }

    public static List<TestDiagnosticLine> readDiagnosticFile(File toRead, boolean omitEmptyDiagnostics) {
        return JavaDiagnosticReader.readDiagnostics(toRead, DIAGNOSTIC_FILE_CODEC, omitEmptyDiagnostics);
    }

    public static List<TestDiagnosticLine> readDiagnosticFileLines(Iterable<? extends File> toRead, boolean omitEmptyDiagnostics) {
        ArrayList<TestDiagnosticLine> lines = new ArrayList<TestDiagnosticLine>();
        for (File file : toRead) {
            lines.addAll(JavaDiagnosticReader.readDiagnosticFile(file, omitEmptyDiagnostics));
        }
        return lines;
    }

    public static List<TestDiagnostic> readDiagnosticFiles(Iterable<? extends File> toRead, boolean omitEmptyDiagnostics) {
        List<TestDiagnosticLine> lines = JavaDiagnosticReader.readDiagnosticFileLines(toRead, omitEmptyDiagnostics);
        ArrayList<TestDiagnostic> diagnostics = new ArrayList<TestDiagnostic>((int)((double)lines.size() + (double)lines.size() * 0.1));
        for (TestDiagnosticLine line : lines) {
            diagnostics.addAll(line.getDiagnostics());
        }
        return diagnostics;
    }

    public JavaDiagnosticReader(File toRead, DiagnosticCodec codec) {
        this.toRead = toRead;
        this.toReadFileObject = null;
        this.codec = codec;
    }

    public JavaDiagnosticReader(JavaFileObject toRead, DiagnosticCodec codec) {
        this.toRead = null;
        this.toReadFileObject = toRead;
        this.codec = codec;
    }

    private void init() throws IOException {
        if (!this.initialized && !this.closed) {
            this.initialized = true;
            Reader fileReader = this.toRead != null ? new FileReader(this.toRead) : this.toReadFileObject.openReader(true);
            this.reader = new LineNumberReader(fileReader);
            this.advance();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.nextLine != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements using JavaDiagnosticFileReader.");
    }

    @Override
    public TestDiagnosticLine next() {
        try {
            this.init();
            if (this.nextLine == null) {
                throw new NoSuchElementException();
            }
            if (this.closed) {
                throw new RuntimeException("Reader has been closed: " + this.toRead.getAbsolutePath());
            }
            String current = this.nextLine;
            int currentLineNumber = this.nextLineNumber;
            this.advance();
            if (this.nextLine == null) {
                this.close();
            }
            return this.codec.convertLine(currentLineNumber, current);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void advance() throws IOException {
        this.nextLine = this.reader.readLine();
        this.nextLineNumber = this.reader.getLineNumber();
    }

    public void close() {
        try {
            if (this.initialized) {
                this.reader.close();
            }
            this.closed = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface DiagnosticCodec {
        public TestDiagnosticLine convertLine(long var1, String var3);
    }
}

