/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import org.checkerframework.qualframework.base.QualifierHierarchy;

public interface CombiningOperation<Q> {
    public Q combine(Q var1, Q var2);

    public Q identity();

    public static class Glb<Q>
    implements CombiningOperation<Q> {
        QualifierHierarchy<Q> hierarchy;

        public Glb(QualifierHierarchy<Q> hierarchy) {
            this.hierarchy = hierarchy;
        }

        @Override
        public Q combine(Q a, Q b) {
            return this.hierarchy.greatestLowerBound(a, b);
        }

        @Override
        public Q identity() {
            return this.hierarchy.getTop();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Glb other = (Glb)o;
            return this.hierarchy.equals(other.hierarchy);
        }

        public int hashCode() {
            return this.hierarchy.hashCode();
        }

        public String toString() {
            return "Glb";
        }
    }

    public static class Lub<Q>
    implements CombiningOperation<Q> {
        QualifierHierarchy<Q> hierarchy;

        public Lub(QualifierHierarchy<Q> hierarchy) {
            this.hierarchy = hierarchy;
        }

        @Override
        public Q combine(Q a, Q b) {
            return this.hierarchy.leastUpperBound(a, b);
        }

        @Override
        public Q identity() {
            return this.hierarchy.getBottom();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Lub other = (Lub)o;
            return this.hierarchy.equals(other.hierarchy);
        }

        public int hashCode() {
            return this.hierarchy.hashCode();
        }

        public String toString() {
            return "Lub";
        }
    }
}

