/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.ast.AstNode;
import kalang.ast.BlockStmt;
import kalang.ast.ExprNode;
import kalang.ast.Statement;

public class IfStmt
extends Statement {
    protected ExprNode conditionExpr;
    protected final BlockStmt trueBody;
    protected final BlockStmt falseBody;

    public IfStmt(ExprNode conditionExpr, @Nullable BlockStmt trueBody, @Nullable BlockStmt falseBody) {
        if (trueBody == null) {
            trueBody = new BlockStmt();
        }
        if (falseBody == null) {
            falseBody = new BlockStmt();
        }
        this.conditionExpr = conditionExpr;
        this.trueBody = trueBody;
        this.falseBody = falseBody;
    }

    public IfStmt(ExprNode conditionExpr) {
        this(conditionExpr, null, null);
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> ls = new LinkedList<AstNode>();
        this.addChild(ls, this.conditionExpr);
        this.addChild(ls, this.trueBody);
        this.addChild(ls, this.falseBody);
        return ls;
    }

    public ExprNode getConditionExpr() {
        return this.conditionExpr;
    }

    public void setConditionExpr(ExprNode conditionExpr) {
        Objects.requireNonNull(conditionExpr);
        this.conditionExpr = conditionExpr;
    }

    @Nonnull
    public BlockStmt getTrueBody() {
        return this.trueBody;
    }

    @Nonnull
    public BlockStmt getFalseBody() {
        return this.falseBody;
    }
}

