/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import kalang.AmbiguousMethodException;
import kalang.MethodNotFoundException;
import kalang.ast.ExprNode;
import kalang.compiler.KalangMethodSelector;
import kalang.core.ExecutableDescriptor;
import kalang.core.ObjectType;
import kalang.core.Type;
import kalang.util.AstUtil;

public abstract class InvocationExpr
extends ExprNode {
    private final ObjectType clazz;
    private static final KalangMethodSelector methodSelector = new KalangMethodSelector();
    protected ExprNode[] arguments;
    private ExecutableDescriptor method;

    public static MethodSelection applyMethod(ObjectType clazz, String methodName, @Nullable ExprNode[] args, ExecutableDescriptor[] candidates) throws MethodNotFoundException, AmbiguousMethodException {
        List selectedList;
        Object[] types;
        if (args == null) {
            args = new ExprNode[]{};
        }
        if ((types = AstUtil.getExprTypes(args)) == null) {
            types = new Type[]{};
        }
        if ((selectedList = methodSelector.select(candidates, methodName, types)).isEmpty()) {
            throw new MethodNotFoundException(clazz, methodName);
        }
        if (selectedList.size() > 1) {
            throw new AmbiguousMethodException(selectedList);
        }
        ExecutableDescriptor md = (ExecutableDescriptor)selectedList.get(0);
        ExprNode[] matchedParam = AstUtil.matchTypes(args, (Type[])types, md.getParameterTypes());
        Objects.requireNonNull(matchedParam);
        return new MethodSelection(md, matchedParam);
    }

    public InvocationExpr(ObjectType clazz, ExecutableDescriptor method, ExprNode[] args) {
        this.method = method;
        this.arguments = args;
        this.clazz = clazz;
    }

    @Nullable
    public Type[] getArgumentTypes() {
        if (this.getArguments() == null) {
            return null;
        }
        return AstUtil.getExprTypes(this.getArguments());
    }

    @Override
    public Type getType() {
        return this.method.getReturnType();
    }

    public ExprNode[] getArguments() {
        return this.arguments;
    }

    public ExecutableDescriptor getMethod() {
        return this.method;
    }

    public static class MethodSelection {
        public ExecutableDescriptor selectedMethod;
        public ExprNode[] appliedArguments;

        public MethodSelection(ExecutableDescriptor selectedMethod, ExprNode[] appliedArguments) {
            this.selectedMethod = selectedMethod;
            this.appliedArguments = appliedArguments;
        }
    }
}

