/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import kalang.ast.AnnotationNode;
import kalang.ast.Annotationable;
import kalang.ast.AstNode;
import kalang.ast.BlockStmt;
import kalang.ast.ClassNode;
import kalang.ast.ParameterNode;
import kalang.core.Type;

public class MethodNode
extends AstNode
implements Annotationable {
    private final int modifier;
    private Type type;
    private String name;
    private final List<ParameterNode> parameters = new LinkedList<ParameterNode>();
    private final List<AnnotationNode> annotations = new LinkedList<AnnotationNode>();
    @Nullable
    private final BlockStmt body;
    private final List<Type> exceptionTypes = new LinkedList<Type>();
    private final ClassNode classNode;

    protected MethodNode(ClassNode classNode, Type type, String name, int modifier) {
        this.classNode = classNode;
        this.modifier = modifier;
        this.type = type;
        this.name = name;
        this.body = Modifier.isAbstract(modifier) ? null : new BlockStmt();
    }

    public ParameterNode createParameter(Type type, String name) {
        return this._createParameter(null, type, name);
    }

    public ParameterNode createParameter(int index, Type type, String name) {
        return this._createParameter(index, type, name);
    }

    private ParameterNode _createParameter(Integer index, Type type, String name) {
        ParameterNode param = new ParameterNode(this, type, name);
        if (index == null) {
            this.parameters.add(param);
        } else {
            this.parameters.add(index, param);
        }
        return param;
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> ls = new LinkedList<AstNode>();
        this.addChild(ls, this.parameters);
        this.addChild(ls, this.body);
        return ls;
    }

    @Override
    public AnnotationNode[] getAnnotations() {
        return this.annotations.toArray(new AnnotationNode[this.annotations.size()]);
    }

    public String toString() {
        ArrayList<String> params = new ArrayList<String>();
        for (ParameterNode p : this.parameters) {
            params.add(String.format("%s %s", p.getType(), p.getName()));
        }
        return String.format("%s %s %s(%s)", Modifier.toString(this.modifier), this.type.toString(), this.name, String.join((CharSequence)",", params));
    }

    public ParameterNode[] getParameters() {
        return this.parameters.toArray(new ParameterNode[this.parameters.size()]);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public int getModifier() {
        return this.modifier;
    }

    public BlockStmt getBody() {
        return this.body;
    }

    public void addAnnotation(AnnotationNode annotation) {
        this.annotations.add(annotation);
    }

    public void addExceptionType(Type type) {
        this.exceptionTypes.add(type);
    }

    public Type[] getExceptionTypes() {
        return this.exceptionTypes.toArray(new Type[this.exceptionTypes.size()]);
    }
}

