/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kalang.AmbiguousMethodException;
import kalang.MethodNotFoundException;
import kalang.ast.AstNode;
import kalang.ast.ExprNode;
import kalang.ast.InvocationExpr;
import kalang.ast.ObjectInvokeExpr;
import kalang.core.ObjectType;
import kalang.core.Type;

public class NewObjectExpr
extends ExprNode {
    protected ObjectType objectType;
    protected InvocationExpr constructor;

    public NewObjectExpr(ObjectType objectType, InvocationExpr constructor) {
        this.objectType = objectType;
        this.constructor = constructor;
    }

    public NewObjectExpr(ObjectType objectType, ExprNode[] args) throws MethodNotFoundException, AmbiguousMethodException {
        this.objectType = objectType;
        this.initDefaultConstructor(args);
    }

    public NewObjectExpr(ObjectType objectType) throws MethodNotFoundException, AmbiguousMethodException {
        this.objectType = objectType;
        this.initDefaultConstructor(null);
    }

    private void initDefaultConstructor(ExprNode[] args) throws MethodNotFoundException, AmbiguousMethodException {
        this.constructor = ObjectInvokeExpr.create(this, "<init>", args);
    }

    @Override
    public List<AstNode> getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Type getType() {
        return this.getObjectType();
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        Objects.requireNonNull(objectType);
        this.objectType = objectType;
    }

    public InvocationExpr getConstructor() {
        return this.constructor;
    }

    public void setConstructor(InvocationExpr constructor) {
        Objects.requireNonNull(constructor);
        this.constructor = constructor;
    }
}

