/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.FieldNotFoundException;
import kalang.ast.AstNode;
import kalang.ast.ClassNode;
import kalang.ast.ExprNode;
import kalang.ast.FieldExpr;
import kalang.core.FieldDescriptor;
import kalang.core.ObjectType;
import kalang.core.Type;
import kalang.util.AstUtil;
import kalang.util.Parameters;

public class ObjectFieldExpr
extends FieldExpr {
    protected ExprNode target;

    public ObjectFieldExpr(ExprNode target, FieldDescriptor field) {
        super(field);
        Parameters.requireFalse(Modifier.isStatic(field.getModifier()));
        this.target = target;
    }

    @Nullable
    public ExprNode getTarget() {
        return this.target;
    }

    @Nonnull
    public static FieldExpr create(@Nonnull ExprNode target, String fieldName, @Nullable ClassNode caller) throws FieldNotFoundException {
        Type type = target.getType();
        if (!(type instanceof ObjectType)) {
            throw new UnsupportedOperationException("unsupported type:" + type);
        }
        ObjectType classType = (ObjectType)type;
        FieldDescriptor field = ObjectFieldExpr.getField(classType, fieldName, caller);
        if (AstUtil.isStatic(field.getModifier())) {
            throw new FieldNotFoundException(fieldName + " is static");
        }
        return new ObjectFieldExpr(target, field);
    }

    @Override
    public List<AstNode> getChildren() {
        return Collections.singletonList(this.target);
    }
}

