/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import javax.annotation.Nullable;
import kalang.FieldNotFoundException;
import kalang.ast.ClassNode;
import kalang.ast.ClassReference;
import kalang.ast.FieldExpr;
import kalang.core.FieldDescriptor;
import kalang.core.Types;
import kalang.util.AstUtil;

public class StaticFieldExpr
extends FieldExpr {
    private ClassReference clazz;

    public static StaticFieldExpr create(ClassReference clazz, String fieldName, @Nullable ClassNode caller) throws FieldNotFoundException {
        FieldDescriptor field = StaticFieldExpr.getField(Types.getClassType(clazz.getReferencedClassNode()), fieldName, caller);
        if (!AstUtil.isStatic(field.getModifier())) {
            throw new FieldNotFoundException(fieldName + " is not static");
        }
        return new StaticFieldExpr(clazz, field);
    }

    public StaticFieldExpr(ClassReference clazz, FieldDescriptor field) {
        super(field);
        if (!AstUtil.isStatic(field.getModifier())) {
            throw new IllegalArgumentException("static field required");
        }
        this.clazz = clazz;
    }

    public ClassReference getClassReference() {
        return this.clazz;
    }
}

