/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import kalang.AmbiguousMethodException;
import kalang.MethodNotFoundException;
import kalang.ast.AstNode;
import kalang.ast.ClassNode;
import kalang.ast.ClassReference;
import kalang.ast.ExprNode;
import kalang.ast.InvocationExpr;
import kalang.core.ClassType;
import kalang.core.ExecutableDescriptor;
import kalang.core.Types;
import kalang.util.AstUtil;

public class StaticInvokeExpr
extends InvocationExpr {
    private ClassReference invokeClass;

    public static StaticInvokeExpr create(ClassReference clazz, String methodName, ExprNode[] args) throws MethodNotFoundException, AmbiguousMethodException {
        return StaticInvokeExpr.create(clazz, methodName, args, null);
    }

    public static StaticInvokeExpr create(ClassReference clazz, String methodName, ExprNode[] args, @Nullable ClassNode caller) throws MethodNotFoundException, AmbiguousMethodException {
        ClassType clazzType = Types.getClassType(clazz.getReferencedClassNode());
        ExecutableDescriptor[] candidates = clazzType.getMethodDescriptors(caller, true, true);
        InvocationExpr.MethodSelection ms = StaticInvokeExpr.applyMethod(Types.getClassType(clazz.getReferencedClassNode()), methodName, args, candidates);
        ExecutableDescriptor md = ms.selectedMethod;
        if (!AstUtil.isStatic(md.getModifier())) {
            throw new MethodNotFoundException(methodName + " is not static");
        }
        return new StaticInvokeExpr(clazz, md, ms.appliedArguments);
    }

    public StaticInvokeExpr(ClassReference invokeClass, ExecutableDescriptor method, ExprNode[] args) {
        super(Types.getClassType(invokeClass.getReferencedClassNode()), method, args);
        if (!AstUtil.isStatic(method.getModifier())) {
            throw new IllegalArgumentException("static method is required");
        }
        this.invokeClass = invokeClass;
    }

    public ClassReference getInvokeClass() {
        return this.invokeClass;
    }

    @Override
    public List<AstNode> getChildren() {
        ArrayList<AstNode> list = new ArrayList<AstNode>();
        this.addChild(list, this.invokeClass);
        this.addChild(list, this.arguments);
        return list;
    }
}

