/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.AmbiguousMethodException;
import kalang.FieldNotFoundException;
import kalang.MethodNotFoundException;
import kalang.antlr.KalangParser;
import kalang.antlr.KalangParserVisitor;
import kalang.ast.AnnotationNode;
import kalang.ast.ArrayLengthExpr;
import kalang.ast.AssignExpr;
import kalang.ast.AssignableExpr;
import kalang.ast.AstNode;
import kalang.ast.BinaryExpr;
import kalang.ast.BlockStmt;
import kalang.ast.BreakStmt;
import kalang.ast.CastExpr;
import kalang.ast.CatchBlock;
import kalang.ast.ClassNode;
import kalang.ast.ClassReference;
import kalang.ast.CompareExpr;
import kalang.ast.ConstExpr;
import kalang.ast.ContinueStmt;
import kalang.ast.ElementExpr;
import kalang.ast.ErrorousExpr;
import kalang.ast.ExprNode;
import kalang.ast.ExprStmt;
import kalang.ast.FieldExpr;
import kalang.ast.FieldNode;
import kalang.ast.IfStmt;
import kalang.ast.IncrementExpr;
import kalang.ast.InstanceOfExpr;
import kalang.ast.InvocationExpr;
import kalang.ast.LocalVarNode;
import kalang.ast.LogicExpr;
import kalang.ast.LoopStmt;
import kalang.ast.MathExpr;
import kalang.ast.MethodNode;
import kalang.ast.MultiStmt;
import kalang.ast.MultiStmtExpr;
import kalang.ast.NewArrayExpr;
import kalang.ast.NewObjectExpr;
import kalang.ast.ObjectFieldExpr;
import kalang.ast.ObjectInvokeExpr;
import kalang.ast.ParameterExpr;
import kalang.ast.ParameterNode;
import kalang.ast.PrimitiveCastExpr;
import kalang.ast.ReturnStmt;
import kalang.ast.Statement;
import kalang.ast.StaticFieldExpr;
import kalang.ast.StaticInvokeExpr;
import kalang.ast.SuperExpr;
import kalang.ast.ThisExpr;
import kalang.ast.ThrowStmt;
import kalang.ast.TryStmt;
import kalang.ast.UnaryExpr;
import kalang.ast.UnknownFieldExpr;
import kalang.ast.UnknownInvocationExpr;
import kalang.ast.VarDeclStmt;
import kalang.ast.VarExpr;
import kalang.ast.VarObject;
import kalang.compiler.AstLoader;
import kalang.compiler.ClassNodeBuilder;
import kalang.compiler.ClassNodeMetaBuilder;
import kalang.compiler.CompilationUnit;
import kalang.compiler.Diagnosis;
import kalang.compiler.DiagnosisHandler;
import kalang.compiler.DiagnosisReporter;
import kalang.compiler.ExceptionCatchAnalyzer;
import kalang.compiler.InitializationAnalyzer;
import kalang.compiler.OffsetRange;
import kalang.compiler.SemanticAnalyzer;
import kalang.compiler.TypeNameResolver;
import kalang.core.ArrayType;
import kalang.core.ClassType;
import kalang.core.GenericType;
import kalang.core.NullableKind;
import kalang.core.ObjectType;
import kalang.core.PrimitiveType;
import kalang.core.Type;
import kalang.core.Types;
import kalang.core.VarTable;
import kalang.core.WildcardType;
import kalang.exception.Exceptions;
import kalang.util.AstUtil;
import kalang.util.BoxUtil;
import kalang.util.InvalidModifierException;
import kalang.util.MethodUtil;
import kalang.util.ModifierUtil;
import kalang.util.NameUtil;
import kalang.util.OffsetRangeHelper;
import kalang.util.StringLiteralUtil;
import kalang.util.TypeUtil;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AstBuilder
extends AbstractParseTreeVisitor
implements KalangParserVisitor {
    private ClassNodeBuilder classNodeBuilder;
    private ClassNodeMetaBuilder classNodeMetaBuilder;
    private DiagnosisReporter diagnosisReporter;
    private SemanticAnalyzer semanticAnalyzer;
    public static final int PARSING_PHASE_INIT = 1;
    public static final int PARSING_PHASE_META = 2;
    public static final int PARSING_PHASE_ALL = 3;
    private int parsingPhase = 0;
    protected ClassNode thisClazz;
    private ClassNode topClass;
    private boolean returned = false;
    private MethodNode method;
    private VarTable<VarObject, Type> overrideTypes = new VarTable();
    private static final int NULLSTATE_MUST_NULL = 0;
    private static final int NULLSTATE_MUST_NONNULL = 1;
    private static final int NULLSTATE_UNKNOWN = 2;
    private static final int NULLSTATE_NULLABLE = 3;
    private VarTable<VarObject, Integer> nullState = new VarTable();
    private VarTable<String, LocalVarNode> varTables = new VarTable();
    @Nonnull
    private AstLoader astLoader;
    private final TypeNameResolver typeNameResolver = new TypeNameResolver();
    private ParserRuleContext compilationContext;
    @Nonnull
    private TokenStream tokenStream;
    @Nonnull
    private final String className;
    @Nonnull
    private KalangParser parser;
    private final CompilationUnit compilationUnit;

    public Object visitEmptyStat(KalangParser.EmptyStatContext ctx) {
        BlockStmt b = this.newBlock();
        this.popBlock();
        return b;
    }

    private void newOverrideTypeStack() {
        this.overrideTypes = new VarTable<VarObject, Type>(this.overrideTypes);
    }

    private void popOverrideTypeStack() {
        this.overrideTypes = this.overrideTypes.getParent();
    }

    private void removeOverrideType(ExprNode expr) {
        VarObject key = this.getOverrideTypeKey(expr);
        if (key != null) {
            this.overrideTypes.remove(key, true);
        }
    }

    @Nullable
    private VarObject getOverrideTypeKey(ExprNode expr) {
        VarObject key = expr instanceof VarExpr ? ((VarExpr)expr).getVar() : (expr instanceof ParameterExpr ? ((ParameterExpr)expr).getParameter() : null);
        return key;
    }

    private void changeTypeTemporarilyIfCould(ExprNode expr, Type type) {
        VarObject key = this.getOverrideTypeKey(expr);
        if (key != null) {
            this.overrideTypes.put(key, type);
        }
    }

    private void onNull(ExprNode expr, boolean onTrue, boolean isEQ) {
        boolean mustNull = onTrue && isEQ || !onTrue && !isEQ;
        VarObject key = this.getOverrideTypeKey(expr);
        if (key != null) {
            this.nullState.put(key, mustNull ? 0 : 1);
        }
    }

    protected void onIf(ExprNode expr, boolean onTrue) {
        if (expr instanceof InstanceOfExpr && onTrue) {
            InstanceOfExpr ie = (InstanceOfExpr)expr;
            this.changeTypeTemporarilyIfCould(ie.getExpr(), Types.getClassType(ie.getTarget().getReferencedClassNode()));
        }
        if (expr instanceof CompareExpr) {
            CompareExpr ce = (CompareExpr)expr;
            ExprNode e1 = ce.getExpr1();
            ExprNode e2 = ce.getExpr2();
            boolean isEQ = ce.getOperation().equals("==");
            if (e1.getType().equals(Types.NULL_TYPE)) {
                this.onNull(e2, onTrue, isEQ);
            } else if (e2.getType().equals(Types.NULL_TYPE)) {
                this.onNull(e1, onTrue, isEQ);
            }
        }
        if (expr instanceof UnaryExpr) {
            this.onIf(((UnaryExpr)expr).getExpr(), !onTrue);
        }
        if (expr instanceof LogicExpr) {
            LogicExpr le = (LogicExpr)expr;
            if (le.getOperation().equals("&&")) {
                if (onTrue) {
                    this.onIf(le.getExpr1(), true);
                    this.onIf(le.getExpr2(), true);
                }
            } else if (le.getOperation().equals("||") && !onTrue) {
                this.onIf(le.getExpr1(), false);
                this.onIf(le.getExpr2(), false);
            }
        }
    }

    public ParserRuleContext getParseTree() {
        return this.compilationContext;
    }

    @Nonnull
    public String getClassName() {
        return this.className;
    }

    @Nullable
    private ClassReference requireClassReference(@Nonnull Token token) {
        ClassNode ast = this.requireAst(token);
        if (ast == null) {
            return null;
        }
        return new ClassReference(ast);
    }

    @Nullable
    protected ObjectType requireClassType(@Nonnull Token token) {
        return this.requireClassType(token.getText(), token);
    }

    @Nullable
    private ObjectType requireClassType(@Nonnull String id, @Nonnull Token token) {
        ClassNode ast = this.requireAst(id, token);
        if (ast == null) {
            return null;
        }
        return Types.getClassType(ast, new Type[0]);
    }

    public void compile() {
        this.compile(3, null);
    }

    public void compile(int targetPhase) {
        this.compile(targetPhase, null);
    }

    public void compile(int targetPhase, @Nullable AstLoader astLoader) {
        this.astLoader = astLoader == null ? new AstLoader() : astLoader;
        this.typeNameResolver.setAstLoader(astLoader);
        this.semanticAnalyzer = new SemanticAnalyzer(this.compilationUnit, astLoader);
        if (targetPhase >= 1 && this.parsingPhase < 1) {
            this.parsingPhase = 1;
            KalangParser.CompilationUnitContext cunit = this.parser.compilationUnit();
            this.compilationContext = cunit;
            for (KalangParser.ImportDeclContext ic : cunit.importDecl()) {
                this.visitImportDecl(ic);
            }
            this.classNodeBuilder = new ClassNodeBuilder(this.compilationUnit, this);
            this.topClass = this.classNodeBuilder.build(cunit);
        }
        if (targetPhase >= 2 && this.parsingPhase < 2) {
            this.parsingPhase = 2;
            this.classNodeMetaBuilder = new ClassNodeMetaBuilder(this.compilationUnit, this, this.classNodeBuilder);
            this.classNodeMetaBuilder.build(this.topClass, this.classNodeBuilder.isScript());
        }
        if (targetPhase >= 3 && this.parsingPhase < 3) {
            this.parsingPhase = 3;
            this.visitMethods(this.topClass);
        }
    }

    private void visitMethods(ClassNode clazz) {
        this.thisClazz = clazz;
        for (MethodNode m : this.thisClazz.getDeclaredMethodNodes()) {
            BlockStmt mbody = m.getBody();
            KalangParser.StatContext[] stats = this.classNodeMetaBuilder.getStatContexts(m);
            if (stats != null) {
                boolean needReturn;
                this.method = m;
                this.returned = false;
                this.visitBlockStmt(stats, mbody);
                boolean bl = needReturn = m.getType() != null && !m.getType().equals(Types.VOID_TYPE);
                if (m.getBody() != null && needReturn && !this.returned) {
                    this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "Missing return statement in method:" + MethodUtil.toString(this.method), this.classNodeMetaBuilder.getMethodDeclContext(m));
                }
                DiagnosisHandler diagnosisHandler = this.diagnosisReporter.getDisgnosisHandler();
                new InitializationAnalyzer(this.compilationUnit, this.astLoader).check(clazz, m, diagnosisHandler);
                new ExceptionCatchAnalyzer(this.compilationUnit, this.astLoader).check(clazz, m, diagnosisHandler);
            }
            if (!AstUtil.isConstructor(m)) continue;
            List<Statement> bodyStmts = mbody.statements;
            if (!AstUtil.hasConstructorCallStatement(bodyStmts)) {
                try {
                    bodyStmts.add(0, AstUtil.createDefaultSuperConstructorCall(this.thisClazz));
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex) {
                    this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "default constructor not found", this.classNodeMetaBuilder.getMethodDeclContext(m));
                }
            }
            int stmtsSize = mbody.statements.size();
            assert (stmtsSize > 0);
            Statement firstStmt = mbody.statements.get(0);
            if (!AstUtil.isConstructorCallStatement(firstStmt)) {
                throw new RuntimeException("missing constructor call");
            }
            mbody.statements.addAll(1, this.thisClazz.initStmts);
        }
        for (ClassNode c : clazz.classes) {
            this.visitMethods(c);
        }
    }

    public AstBuilder(@Nonnull CompilationUnit compilationUnit, @Nonnull KalangParser parser) {
        this.compilationUnit = compilationUnit;
        this.className = compilationUnit.getSource().getClassName();
        this.parser = parser;
        this.tokenStream = parser.getTokenStream();
    }

    @Nonnull
    private String getPackageName() {
        if (this.className.contains(".")) {
            return this.className.substring(0, this.className.lastIndexOf(46));
        }
        return "";
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.className;
    }

    @Nonnull
    public AstLoader getAstLoader() {
        return this.astLoader;
    }

    @Nonnull
    public TokenStream getTokenStream() {
        return this.tokenStream;
    }

    @Nonnull
    public KalangParser getParser() {
        return this.parser;
    }

    @Nullable
    private ClassNode requireAst(Token token) {
        return this.requireAst(token.getText(), token);
    }

    @Nullable
    private ClassNode requireAst(String id, Token token) {
        ClassNode ast;
        String resolvedName = this.typeNameResolver.resolve(id, this.topClass, this.thisClazz);
        ClassNode classNode = ast = resolvedName == null ? null : this.astLoader.getAst(resolvedName);
        if (ast == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "ast not found:" + id, token);
        }
        return ast;
    }

    @Nullable
    private ClassNode getAst(String id) {
        String resolvedName = this.typeNameResolver.resolve(id, this.topClass, this.thisClazz);
        ClassNode ast = resolvedName == null ? null : this.astLoader.getAst(resolvedName);
        return ast;
    }

    @Nullable
    protected ObjectType parseClassType(KalangParser.ClassTypeContext ctx) {
        NullableKind nullable = ctx.nullable == null ? NullableKind.NONNULL : NullableKind.NULLABLE;
        Token rawTypeToken = ctx.rawClass;
        LinkedList<String> classNameParts = new LinkedList<String>();
        for (Token token : ctx.paths) {
            classNameParts.add(token.getText());
        }
        if (ctx.innerClass != null) {
            classNameParts.add(rawTypeToken.getText() + "$" + ctx.innerClass.getText());
        } else {
            classNameParts.add(rawTypeToken.getText());
        }
        String rawType = String.join((CharSequence)".", classNameParts);
        for (GenericType gt : this.thisClazz.getGenericTypes()) {
            if (!rawType.equals(gt.getName())) continue;
            return gt;
        }
        ObjectType objectType = this.requireClassType(rawType, rawTypeToken);
        if (objectType == null) {
            return null;
        }
        ClassNode clazzNode = objectType.getClassNode();
        GenericType[] clzDeclaredGenericTypes = clazzNode.getGenericTypes();
        if (clzDeclaredGenericTypes != null && clzDeclaredGenericTypes.length > 0) {
            Type[] typeArguments = new Type[clzDeclaredGenericTypes.length];
            List<KalangParser.ParameterizedElementTypeContext> parameterTypes = ctx.parameterTypes;
            if (parameterTypes != null && parameterTypes.size() > 0) {
                if (clzDeclaredGenericTypes.length != parameterTypes.size()) {
                    this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "wrong number of type arguments", ctx);
                    return null;
                }
                for (int i = 0; i < typeArguments.length; ++i) {
                    typeArguments[i] = this.parseParameterizedElementType(parameterTypes.get(i));
                    if (typeArguments[i] != null) continue;
                    return null;
                }
            } else {
                typeArguments = new Type[]{};
            }
            return Types.getClassType(objectType.getClassNode(), typeArguments, nullable);
        }
        return Types.getClassType(objectType.getClassNode(), nullable);
    }

    @Nullable
    protected Type parseType(KalangParser.TypeContext ctx) {
        KalangParser.ClassTypeContext ct = ctx.classType();
        KalangParser.PrimitiveTypeContext pt = ctx.primitiveType();
        if (ct != null) {
            return this.parseClassType(ct);
        }
        if (pt != null) {
            return Types.getPrimitiveType(pt.getText());
        }
        NullableKind nullable = ctx.nullable != null ? NullableKind.NULLABLE : NullableKind.NONNULL;
        KalangParser.TypeContext t = ctx.type();
        Type cpt = this.parseType(t);
        if (cpt == null) {
            return null;
        }
        return Types.getArrayType(cpt, nullable);
    }

    public Object visit(ParseTree tree) {
        if (tree == null) {
            System.err.print("visit null");
            Exception ex = new Exception();
            ex.printStackTrace(System.err);
            return null;
        }
        if (tree instanceof KalangParser.StatContext && this.returned) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "unreachable statement", (KalangParser.StatContext)tree);
        }
        return super.visit(tree);
    }

    public void importPackage(@Nonnull String packageName) {
        this.typeNameResolver.importPackage(packageName);
    }

    BlockStmt wrapBlock(Statement ... statms) {
        BlockStmt bs = this.newBlock();
        bs.statements.addAll(Arrays.asList(statms));
        this.popBlock();
        return bs;
    }

    private void newFrame() {
        this.varTables = this.varTables.newStack();
    }

    private void popFrame() {
        this.varTables = this.varTables.popStack();
    }

    BlockStmt newBlock() {
        BlockStmt bs = new BlockStmt();
        this.newFrame();
        return bs;
    }

    void popBlock() {
        this.popFrame();
    }

    @Nonnull
    public ClassNode getAst() {
        return this.topClass;
    }

    protected void mapAst(@Nonnull AstNode node, @Nonnull ParserRuleContext tree) {
        node.offset = OffsetRangeHelper.getOffsetRange(tree);
    }

    protected void mapAst(@Nonnull AstNode node, @Nonnull Token token) {
        node.offset = OffsetRangeHelper.getOffsetRange(token);
    }

    public ThrowStmt visitThrowStat(KalangParser.ThrowStatContext ctx) {
        ThrowStmt ts = new ThrowStmt(this.visitExpression(ctx.expression()));
        this.mapAst((AstNode)ts, ctx);
        this.returned = true;
        return ts;
    }

    public MultiStmtExpr visitMapExpr(KalangParser.MapExprContext ctx) {
        NewObjectExpr newExpr;
        ObjectType valueType;
        ObjectType keyType = ctx.keyType != null ? this.requireClassType(ctx.keyType) : Types.getRootType();
        ObjectType objectType = valueType = ctx.valueType != null ? this.requireClassType(ctx.valueType) : Types.getRootType();
        if (keyType == null || valueType == null) {
            return null;
        }
        LocalVarNode vo = this.declareTempLocalVar(Types.getClassType(Types.getMapImplClassType().getClassNode(), new Type[]{keyType, valueType}));
        VarDeclStmt vds = new VarDeclStmt(vo);
        try {
            newExpr = new NewObjectExpr(Types.getMapImplClassType());
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        stmts.add(vds);
        stmts.add(new ExprStmt(new AssignExpr(new VarExpr(vo), newExpr)));
        VarExpr ve = new VarExpr(vo);
        List<TerminalNode> ids = ctx.Identifier();
        for (int i = 0; i < ids.size(); ++i) {
            ObjectInvokeExpr iv;
            KalangParser.ExpressionContext e = ctx.expression(i);
            ExprNode v = (ExprNode)this.visit((ParseTree)e);
            ConstExpr k = new ConstExpr(ctx.Identifier(i).getText());
            ExprNode[] args = new ExprNode[]{k, v};
            try {
                iv = ObjectInvokeExpr.create(ve, "put", args);
            }
            catch (AmbiguousMethodException | MethodNotFoundException ex) {
                throw Exceptions.unexceptedException(ex);
            }
            ExprStmt es = new ExprStmt(iv);
            stmts.add(es);
        }
        MultiStmtExpr mse = new MultiStmtExpr(stmts, ve);
        this.mapAst((AstNode)mse, ctx);
        return mse;
    }

    public ExprNode visitNewArrayExpr(KalangParser.NewArrayExprContext ctx) {
        ExprNode ret;
        Type type = this.parseType(ctx.type());
        if (ctx.size != null) {
            ExprNode size = this.visitExpression(ctx.size);
            ret = new NewArrayExpr(type, size);
        } else {
            ExprNode[] initExprs = new ExprNode[ctx.initExpr.size()];
            for (int i = 0; i < initExprs.length; ++i) {
                initExprs[i] = this.visitExpression(ctx.initExpr.get(i));
            }
            ret = this.createInitializedArray(type, initExprs);
        }
        this.mapAst((AstNode)ret, ctx);
        return ret;
    }

    public AstNode visitQuestionExpr(KalangParser.QuestionExprContext ctx) {
        Type falseType;
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        ExprNode conditionExpr = (ExprNode)this.visit((ParseTree)ctx.expression(0));
        ExprNode trueExpr = (ExprNode)this.visit((ParseTree)ctx.expression(1));
        ExprNode falseExpr = (ExprNode)this.visit((ParseTree)ctx.expression(2));
        Type trueType = trueExpr.getType();
        Type type = trueType.equals(falseType = falseExpr.getType()) ? trueType : TypeUtil.getCommonType(trueType, falseType);
        LocalVarNode vo = this.declareTempLocalVar(type);
        VarDeclStmt vds = new VarDeclStmt(vo);
        stmts.add(vds);
        VarExpr ve = new VarExpr(vo);
        IfStmt is = new IfStmt(conditionExpr);
        is.getTrueBody().statements.add(new ExprStmt(new AssignExpr(ve, trueExpr)));
        is.getFalseBody().statements.add(new ExprStmt(new AssignExpr(ve, falseExpr)));
        stmts.add(is);
        MultiStmtExpr mse = new MultiStmtExpr(stmts, ve);
        this.mapAst((AstNode)ve, ctx);
        return mse;
    }

    public AstNode visitPostIfStmt(KalangParser.PostIfStmtContext ctx) {
        ExprNode leftExpr = this.visitExpression(ctx.expression(0));
        if (!(leftExpr instanceof AssignExpr)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "AssignExpr required", ctx);
        }
        AssignExpr assignExpr = (AssignExpr)leftExpr;
        AssignableExpr to = assignExpr.getTo();
        ExprNode from = assignExpr.getFrom();
        ExprNode cond = this.visitExpression(ctx.expression(1));
        Token op = ctx.op;
        if (op != null) {
            String opStr = op.getText();
            BinaryExpr be = this.createBinaryExpr(to, cond, opStr);
            cond = be;
        }
        AssignExpr as = new AssignExpr(to, from);
        IfStmt is = new IfStmt(cond);
        is.getTrueBody().statements.add(new ExprStmt(as));
        this.mapAst((AstNode)is, ctx);
        return is;
    }

    public AstNode visitCompilationUnit(KalangParser.CompilationUnitContext ctx) {
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    public AstNode visitClassBody(KalangParser.ClassBodyContext ctx) {
        this.visitChildren((RuleNode)ctx);
        this.mapAst((AstNode)this.thisClazz, ctx);
        return null;
    }

    public Void visitFieldDecl(KalangParser.FieldDeclContext ctx) {
        int mdf = this.parseModifier(ctx.varModifier());
        for (KalangParser.VarDeclContext vd : ctx.varDecl()) {
            ExprNode initExpr = vd.expression() != null ? this.visitExpression(vd.expression()) : null;
            VarInfo varInfo = this.varDecl(vd, initExpr == null ? Types.getRootType() : initExpr.getType());
            FieldNode fieldNode = this.thisClazz.createField(varInfo.type, varInfo.name, mdf);
            if (initExpr == null) continue;
            if (AstUtil.isStatic(fieldNode.modifier)) {
                this.thisClazz.staticInitStmts.add(new ExprStmt(new AssignExpr(new StaticFieldExpr(new ClassReference(this.thisClazz), fieldNode), initExpr)));
                continue;
            }
            this.thisClazz.initStmts.add(new ExprStmt(new AssignExpr(new ObjectFieldExpr(new ThisExpr(this.getThisType()), fieldNode), initExpr)));
        }
        return null;
    }

    private boolean isNonStaticInnerClass(ClassNode clazz) {
        return clazz.enclosingClass != null && !Modifier.isStatic(clazz.modifier);
    }

    private boolean isDeclaringNonStaticInnerClass() {
        return this.isNonStaticInnerClass(this.thisClazz);
    }

    public AstNode visitMethodDecl(KalangParser.MethodDeclContext ctx) {
        throw Exceptions.unexceptedException("");
    }

    public AstNode visitType(KalangParser.TypeContext ctx) {
        return null;
    }

    public List<Object> visitAll(List<? extends ParserRuleContext> list) {
        ArrayList<Object> ret = new ArrayList<Object>(list.size());
        for (ParserRuleContext parserRuleContext : list) {
            ret.add(this.visit((ParseTree)parserRuleContext));
        }
        return ret;
    }

    public AstNode visitIfStat(KalangParser.IfStatContext ctx) {
        ExprNode expr = this.visitExpression(ctx.expression());
        BlockStmt trueBody = null;
        BlockStmt falseBody = null;
        VarTable<VarObject, Integer> trueAssigned = this.nullState.newStack();
        this.nullState = trueAssigned;
        this.newOverrideTypeStack();
        this.onIf(expr, true);
        if (ctx.trueStmt != null) {
            trueBody = this.requireBlock(ctx.trueStmt);
        }
        this.popOverrideTypeStack();
        this.nullState = this.nullState.popStack();
        boolean trueReturned = this.returned;
        this.returned = false;
        VarTable<VarObject, Integer> falseAssigned = this.nullState.newStack();
        this.nullState = falseAssigned;
        this.newOverrideTypeStack();
        this.onIf(expr, false);
        if (ctx.falseStmt != null) {
            falseBody = this.requireBlock(ctx.falseStmt);
        }
        this.popOverrideTypeStack();
        this.nullState = this.nullState.popStack();
        this.handleMultiBranchedAssign(trueAssigned.vars(), falseAssigned.vars());
        boolean falseReturned = this.returned;
        if (trueReturned) {
            this.onIf(expr, false);
        }
        if (falseReturned) {
            this.onIf(expr, true);
        }
        this.returned = falseReturned && trueReturned;
        IfStmt ifStmt = new IfStmt(expr, trueBody, falseBody);
        this.mapAst((AstNode)ifStmt, ctx);
        return ifStmt;
    }

    private void handleMultiBranchedAssign(Map<VarObject, Integer> ... assignedTable) {
        if (assignedTable.length < 2) {
            throw Exceptions.illegalArgument(assignedTable);
        }
        HashMap<VarObject, Integer> ret = new HashMap<VarObject, Integer>();
        ret.putAll(assignedTable[0]);
        for (int i = 1; i < assignedTable.length; ++i) {
            Map<VarObject, Integer> other = assignedTable[i];
            for (Map.Entry e : ret.entrySet()) {
                Integer otherNullable;
                Integer oneNullable = (Integer)e.getValue();
                if (oneNullable.equals(otherNullable = other.get(e.getKey()))) continue;
                if (otherNullable == null) {
                    ret.remove(e.getKey());
                    continue;
                }
                int ns = oneNullable.equals(1) && otherNullable.equals(2) || otherNullable.equals(1) && oneNullable.equals(2) ? 2 : 3;
                ret.put((VarObject)e.getKey(), ns);
            }
        }
        for (Map.Entry e : ret.entrySet()) {
            this.nullState.put((VarObject)e.getKey(), (Integer)e.getValue());
        }
    }

    protected ExprNode visitExpression(KalangParser.ExpressionContext expression) {
        Object node = this.visit((ParseTree)expression);
        if (node instanceof ExprNode) {
            return (ExprNode)node;
        }
        ErrorousExpr expr = node instanceof AstNode ? new ErrorousExpr((AstNode)node) : new ErrorousExpr(new AstNode[0]);
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "not an expression", expression);
        return expr;
    }

    public Statement visitStat(KalangParser.StatContext ctx) {
        ParseTree child = ctx.getChild(0);
        return child == null ? null : (Statement)this.visit(child);
    }

    public AstNode visitReturnStat(KalangParser.ReturnStatContext ctx) {
        ReturnStmt rs = new ReturnStmt();
        if (ctx.expression() != null) {
            rs.expr = this.visitExpression(ctx.expression());
        }
        if (!this.semanticAnalyzer.validateReturnStmt(this.method, rs)) {
            return null;
        }
        this.mapAst((AstNode)rs, ctx);
        this.returned = true;
        return rs;
    }

    public Statement visitVarDeclStat(KalangParser.VarDeclStatContext ctx) {
        Statement vars = this.visitLocalVarDecl(ctx.localVarDecl());
        this.mapAst((AstNode)vars, ctx);
        return vars;
    }

    public VarObject visitVarDecl(KalangParser.VarDeclContext ctx) {
        throw Exceptions.unexceptedException("It should never be executed");
    }

    protected VarInfo varDecl(KalangParser.VarDeclContext ctx, Type inferedType) {
        Type declType;
        VarInfo vds = new VarInfo();
        String name = ctx.name.getText();
        KalangParser.TypeContext type = null;
        if (ctx.varType != null) {
            type = ctx.varType;
        } else if (ctx.type() != null) {
            type = ctx.type();
        }
        Type type2 = declType = type != null ? this.parseType(type) : inferedType;
        if (this.isDefindedId(name)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "the name is definded:" + name, ctx);
        }
        vds.name = name;
        vds.type = declType;
        if (vds.type == null) {
            vds.type = Types.getRootType();
        }
        return vds;
    }

    public void methodIsAmbiguous(Token token, AmbiguousMethodException ex) {
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, ex.getMessage(), token);
    }

    public void methodNotFound(Token token, String className, String methodName, ExprNode[] params) {
        Type[] types = AstUtil.getExprTypes(params);
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method not found:" + MethodUtil.toString(className, methodName, types), token);
    }

    private void handleSyntaxError(String msg, Token token) {
        this.handleSyntaxError(msg, ParserRuleContext.EMPTY, token, token);
    }

    private void handleSyntaxError(String msg, ParserRuleContext tree) {
        this.handleSyntaxError(msg, tree, tree.start, tree.stop);
    }

    private void handleSyntaxError(String desc, ParserRuleContext rule, Token start, Token stop) {
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, desc, start, stop);
    }

    public AstNode visitBreakStat(KalangParser.BreakStatContext ctx) {
        BreakStmt bs = new BreakStmt();
        this.mapAst((AstNode)bs, ctx);
        return bs;
    }

    public AstNode visitContinueStat(KalangParser.ContinueStatContext ctx) {
        ContinueStmt cs = new ContinueStmt();
        this.mapAst((AstNode)cs, ctx);
        return cs;
    }

    public AstNode visitWhileStat(KalangParser.WhileStatContext ctx) {
        ExprNode preConditionExpr = this.visitExpression(ctx.expression());
        BlockStmt loopBody = null;
        if (ctx.stat() != null) {
            loopBody = this.requireBlock(ctx.stat());
        }
        LoopStmt ws = new LoopStmt(preConditionExpr, null, loopBody);
        this.mapAst((AstNode)ws, ctx);
        return ws;
    }

    public AstNode visitDoWhileStat(KalangParser.DoWhileStatContext ctx) {
        BlockStmt loopBody = null;
        if (ctx.blockStmt() != null) {
            loopBody = this.requireBlock(ctx.blockStmt());
        }
        ExprNode postConditionExpr = this.visitExpression(ctx.expression());
        LoopStmt ls = new LoopStmt(null, postConditionExpr, loopBody);
        this.mapAst((AstNode)ls, ctx);
        return ls;
    }

    public AstNode visitForStat(KalangParser.ForStatContext ctx) {
        Statement st;
        BlockStmt forStmt = this.newBlock();
        if (ctx.localVarDecl() != null) {
            Statement vars = this.visitLocalVarDecl(ctx.localVarDecl());
            forStmt.statements.add(vars);
        }
        if (ctx.initExpressions != null) {
            forStmt.statements.addAll((Collection<Statement>)this.visitExpressions(ctx.initExpressions));
        }
        ExprNode preConditionExpr = ctx.condition != null ? this.visitExpression(ctx.condition) : null;
        BlockStmt bs = this.newBlock();
        if (ctx.stat() != null && (st = this.visitStat(ctx.stat())) instanceof BlockStmt) {
            bs.statements.addAll(((BlockStmt)st).statements);
        }
        if (ctx.updateExpressions != null) {
            bs.statements.addAll((Collection<Statement>)this.visitExpressions(ctx.updateExpressions));
        }
        this.popBlock();
        LoopStmt ls = new LoopStmt(preConditionExpr, null, bs);
        this.mapAst((AstNode)ls, ctx);
        forStmt.statements.add(ls);
        this.popBlock();
        return forStmt;
    }

    public List<Statement> visitExpressions(KalangParser.ExpressionsContext ctx) {
        LinkedList<Statement> list = new LinkedList<Statement>();
        for (KalangParser.ExpressionContext e : ctx.expression()) {
            ExprNode expr = this.visitExpression(e);
            list.add(new ExprStmt(expr));
        }
        return list;
    }

    public AstNode visitExprStat(KalangParser.ExprStatContext ctx) {
        ExprNode expr = this.visitExpression(ctx.expression());
        ExprStmt es = new ExprStmt(expr);
        this.mapAst((AstNode)es, ctx);
        return es;
    }

    public ExprNode visitMemberInvocationExpr(KalangParser.MemberInvocationExprContext ctx) {
        ExprNode ie;
        ObjectType clazz;
        ExprNode target;
        String methodName = ctx.key != null ? ctx.key.getText() : ctx.Identifier().getText();
        if (methodName.equals("this")) {
            methodName = "<init>";
            target = new ThisExpr(this.getThisType());
            clazz = this.getThisType();
        } else if (methodName.equals("super")) {
            methodName = "<init>";
            target = new SuperExpr(this.thisClazz);
            clazz = this.thisClazz.superType;
        } else {
            target = new ThisExpr(this.getThisType());
            clazz = this.getThisType();
        }
        List<Object> argsList = this.visitAll(ctx.params);
        if (argsList.contains(null)) {
            return null;
        }
        ExprNode[] args = argsList.toArray(new ExprNode[argsList.size()]);
        if (methodName.equals("<init>")) {
            if (clazz == null) {
                throw Exceptions.unexceptedValue(clazz);
            }
            try {
                InvocationExpr.MethodSelection apply = InvocationExpr.applyMethod(clazz, methodName, args, clazz.getConstructorDescriptors(this.thisClazz));
                ie = new ObjectInvokeExpr(target, apply.selectedMethod, apply.appliedArguments);
            }
            catch (AmbiguousMethodException | MethodNotFoundException ex) {
                this.methodNotFound(ctx.start, clazz.getName(), methodName, args);
                return null;
            }
        } else {
            ie = this.getImplicitInvokeExpr(methodName, args, ctx);
        }
        return ie;
    }

    private BinaryExpr createBinaryExpr(ExprNode expr1, ExprNode expr2, String op) {
        BinaryExpr binExpr;
        switch (op) {
            case "==": 
            case "!=": 
            case ">": 
            case ">=": 
            case "<": 
            case "<=": {
                binExpr = new CompareExpr(expr1, expr2, op);
                break;
            }
            case "&&": 
            case "||": {
                binExpr = new LogicExpr(expr1, expr2, op);
                break;
            }
            default: {
                binExpr = new MathExpr(expr1, expr2, op);
            }
        }
        this.semanticAnalyzer.validateBinaryExpr(binExpr);
        return binExpr;
    }

    protected ExprNode createFieldExpr(KalangParser.GetFieldExprContext to, @Nullable KalangParser.ExpressionContext fromCtx, OffsetRange offsetRange) {
        String refKey = to.refKey.getText();
        KalangParser.ExpressionContext exp = to.expression();
        String fname = to.Identifier().getText();
        Object expr = this.visit((ParseTree)exp);
        if (refKey.equals(".")) {
            ExprNode fieldExpr;
            if (expr instanceof ExprNode) {
                ExprNode exprNode = (ExprNode)expr;
                fieldExpr = this.getObjectFieldLikeExpr(exprNode, fname, to);
            } else if (expr instanceof ClassReference) {
                fieldExpr = this.getStaticFieldExpr((ClassReference)expr, fname, to);
            } else {
                throw new UnknownError("unknown node:" + expr);
            }
            if (fromCtx == null) {
                return fieldExpr;
            }
            if (!(fieldExpr instanceof AssignableExpr)) {
                this.handleSyntaxError("unsupported", to);
                return null;
            }
            AssignableExpr toExpr = (AssignableExpr)fieldExpr;
            ExprNode fromExpr = this.visitExpression(fromCtx);
            if (!this.semanticAnalyzer.validateAssign(toExpr, fromExpr, offsetRange)) {
                return null;
            }
            return new AssignExpr(toExpr, fromExpr);
        }
        if (refKey.equals("->")) {
            String methodName;
            ExprNode[] params;
            if (fromCtx == null) {
                params = new ExprNode[]{};
                methodName = "get" + NameUtil.firstCharToUpperCase(fname);
            } else {
                params = new ExprNode[1];
                methodName = "set" + NameUtil.firstCharToUpperCase(fname);
            }
            if (expr instanceof ExprNode) {
                if (fromCtx != null) {
                    params[0] = this.visitExpression(fromCtx);
                }
                return this.getObjectInvokeExpr((ExprNode)expr, methodName, params, (ParserRuleContext)to);
            }
            this.handleSyntaxError("object expression required.", to);
            return null;
        }
        throw Exceptions.unknownValue(refKey);
    }

    public ExprNode visitAssignExpr(KalangParser.AssignExprContext ctx) {
        ExprNode expr;
        String assignOp = ctx.getChild(1).getText();
        KalangParser.ExpressionContext toCtx = ctx.expression(0);
        KalangParser.ExpressionContext fromCtx = ctx.expression(1);
        if (toCtx instanceof KalangParser.GetFieldExprContext) {
            expr = this.createFieldExpr((KalangParser.GetFieldExprContext)toCtx, fromCtx, OffsetRangeHelper.getOffsetRange(ctx));
        } else {
            ExprNode to = this.visitExpression(toCtx);
            ExprNode from = this.visitExpression(fromCtx);
            if (assignOp.length() > 1) {
                String op = assignOp.substring(0, assignOp.length() - 1);
                from = this.createBinaryExpr(to, from, op);
            }
            if (to instanceof AssignableExpr) {
                AssignableExpr toExpr = (AssignableExpr)to;
                if (!this.semanticAnalyzer.validateAssign(toExpr, from, OffsetRangeHelper.getOffsetRange(ctx))) {
                    return null;
                }
                AssignExpr aexpr = new AssignExpr(toExpr, from);
                this.mapAst((AstNode)aexpr, ctx);
                this.onAssign(toExpr, from);
                expr = aexpr;
            } else {
                this.handleSyntaxError("unsupported assign statement", ctx);
                return null;
            }
        }
        return expr;
    }

    private int getNullState(NullableKind nullable) {
        int ns;
        if (nullable == NullableKind.NONNULL) {
            ns = 1;
        } else if (nullable == NullableKind.NULLABLE) {
            ns = 3;
        } else if (nullable == NullableKind.UNKNOWN) {
            ns = 2;
        } else {
            throw Exceptions.unexceptedValue((Object)nullable);
        }
        return ns;
    }

    private void onAssign(ExprNode to, ExprNode expr) {
        Type toType;
        this.removeOverrideType(to);
        if (to instanceof VarExpr) {
            ((VarExpr)to).removeOverrideType();
        } else if (to instanceof ParameterExpr) {
            ((ParameterExpr)to).removeOverrideType();
        }
        VarObject key = this.getOverrideTypeKey(to);
        if (key != null && (toType = to.getType()) instanceof ObjectType) {
            int ns;
            Type type = expr.getType();
            if (Types.NULL_TYPE.equals(type)) {
                ns = 0;
            } else if (type instanceof ObjectType) {
                ns = this.getNullState(((ObjectType)type).getNullable());
            } else {
                throw Exceptions.unexceptedValue(type);
            }
            this.nullState.put(key, ns);
        }
    }

    @Nullable
    private ExprNode concatExpressionsToStringExpr(ExprNode[] expr, Token[] startTokens) {
        ExprNode ret;
        try {
            ret = new NewObjectExpr(Types.requireClassType("java.lang.StringBuilder"), new ExprNode[0]);
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
        for (int i = 0; i < expr.length; ++i) {
            try {
                ret = ObjectInvokeExpr.create(ret, "append", new ExprNode[]{expr[i]});
                continue;
            }
            catch (AmbiguousMethodException | MethodNotFoundException ex) {
                throw Exceptions.unexceptedException(ex);
            }
        }
        try {
            return ObjectInvokeExpr.create(ret, "toString", new ExprNode[0]);
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
    }

    private ExprNode createBinaryExpr(String op, KalangParser.ExpressionContext exprCtx1, KalangParser.ExpressionContext exprCtx2, Token opStart, Token opEnd, ParserRuleContext ctx) {
        ExprNode expr;
        ExprNode expr1 = this.visitExpression(exprCtx1);
        ExprNode expr2 = this.visitExpression(exprCtx2);
        Type type1 = expr1.getType();
        Type type2 = expr2.getType();
        boolean isPrimitive1 = type1 instanceof PrimitiveType;
        boolean isPrimitive2 = type2 instanceof PrimitiveType;
        if (isPrimitive1 && isPrimitive2) {
            expr = this.createBinaryExpr(expr1, expr2, op);
        } else if (Types.isNumber(type1) && Types.isNumber(type2)) {
            PrimitiveType t = SemanticAnalyzer.getMathType(type1, type2, op);
            expr1 = BoxUtil.assign(expr1, type1, t);
            expr2 = BoxUtil.assign(expr2, type2, t);
            if (expr1 == null) {
                throw Exceptions.unexceptedValue(expr1);
            }
            if (expr2 == null) {
                throw Exceptions.unexceptedValue(expr2);
            }
            expr = this.createBinaryExpr(expr1, expr2, op);
        } else if (op.equals("==") || op.equals("!=")) {
            expr = this.createBinaryExpr(expr1, expr2, op);
        } else if (op.equals("+")) {
            expr = this.concatExpressionsToStringExpr(new ExprNode[]{expr1, expr2}, new Token[]{exprCtx1.getStart(), exprCtx2.getStart()});
        } else {
            this.handleSyntaxError("unsupported operation", ParserRuleContext.EMPTY, opStart, opEnd);
            return null;
        }
        if (expr != null) {
            this.mapAst((AstNode)expr, ctx);
        }
        return expr;
    }

    public AstNode visitBinaryExpr(KalangParser.BinaryExprContext ctx) {
        TerminalNode opNode = (TerminalNode)ctx.getChild(1);
        String op = opNode.getText();
        return this.createBinaryExpr(op, ctx.expression(0), ctx.expression(1), opNode.getSymbol(), opNode.getSymbol(), ctx);
    }

    @Nullable
    private ExprNode getImplicitInvokeExpr(String methodName, ExprNode[] args, ParserRuleContext ctx) {
        ExprNode expr = null;
        try {
            ObjectType clazzType = this.getThisType();
            InvocationExpr.MethodSelection ms = InvocationExpr.applyMethod(clazzType, methodName, args, clazzType.getMethodDescriptors(this.thisClazz, true, true));
            expr = Modifier.isStatic(ms.selectedMethod.getModifier()) ? new StaticInvokeExpr(new ClassReference(this.thisClazz), ms.selectedMethod, ms.appliedArguments) : new ObjectInvokeExpr(new ThisExpr(this.getThisType()), ms.selectedMethod, ms.appliedArguments);
        }
        catch (MethodNotFoundException ex) {
            if (args.length == 1 && (methodName.equals("print") || methodName.equals("println"))) {
                try {
                    StaticFieldExpr fieldExpr = StaticFieldExpr.create(new ClassReference(Types.requireClassType("java.lang.System").getClassNode()), "out", null);
                    expr = this.getObjectInvokeExpr((ExprNode)fieldExpr, methodName, args, ctx);
                }
                catch (FieldNotFoundException fnfEx) {
                    throw Exceptions.unexceptedException(fnfEx);
                }
            }
            if (expr == null) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method not found:" + methodName, ctx);
                expr = new UnknownInvocationExpr(null, methodName, args);
            }
        }
        catch (AmbiguousMethodException ex) {
            this.methodIsAmbiguous(ctx.start, ex);
            return null;
        }
        this.mapAst(expr, ctx);
        return expr;
    }

    @Nullable
    private ExprNode getObjectInvokeExpr(ExprNode target, String methodName, List<KalangParser.ExpressionContext> argumentsCtx, ParserRuleContext ctx) {
        ExprNode[] args = this.visitAll(argumentsCtx).toArray(new ExprNode[0]);
        return this.getObjectInvokeExpr(target, methodName, args, ctx);
    }

    @Nullable
    private ExprNode getObjectInvokeExpr(ExprNode target, String methodName, ExprNode[] args, ParserRuleContext ctx) {
        ExprNode expr;
        if ("<init>".equals(methodName)) {
            throw Exceptions.unexceptedException("Don't get constructor by this method.");
        }
        Type targetType = target.getType();
        if (!(targetType instanceof ObjectType)) {
            this.handleSyntaxError("class type required.", ctx);
            return null;
        }
        ObjectType targetClassType = (ObjectType)targetType;
        if (targetClassType.getNullable() == NullableKind.NULLABLE) {
            this.handleSyntaxError("expression may be null", ctx);
            return null;
        }
        try {
            Type invokeType;
            ObjectInvokeExpr invoke = ObjectInvokeExpr.create(target, methodName, args, this.thisClazz);
            expr = invoke.getMethod().getMethodNode().getType() instanceof GenericType ? ((invokeType = invoke.getType()) instanceof ObjectType ? new CastExpr(invokeType, invoke) : invoke) : invoke;
        }
        catch (MethodNotFoundException ex) {
            this.methodNotFound(ctx.start, this.className, methodName, args);
            expr = new UnknownInvocationExpr(target, methodName, args);
        }
        catch (AmbiguousMethodException ex) {
            this.methodIsAmbiguous(ctx.start, ex);
            return null;
        }
        this.mapAst((AstNode)expr, ctx);
        return expr;
    }

    private ExprNode getStaticInvokeExpr(ClassReference clazz, String methodName, List<KalangParser.ExpressionContext> argumentsCtx, ParserRuleContext ctx) {
        return this.getStaticInvokeExpr(clazz, methodName, this.visitAll(argumentsCtx).toArray(new ExprNode[0]), ctx);
    }

    private ExprNode getStaticInvokeExpr(ClassReference clazz, String methodName, ExprNode[] argumentsCtx, ParserRuleContext ctx) {
        ExprNode expr;
        ExprNode[] args = argumentsCtx;
        try {
            expr = StaticInvokeExpr.create(clazz, methodName, args);
        }
        catch (MethodNotFoundException ex) {
            this.methodNotFound(ctx.start, this.className, methodName, args);
            expr = new UnknownInvocationExpr(clazz, methodName, args);
        }
        catch (AmbiguousMethodException ex) {
            this.methodIsAmbiguous(ctx.start, ex);
            return null;
        }
        this.mapAst((AstNode)expr, ctx);
        return expr;
    }

    public AstNode visitInvokeExpr(KalangParser.InvokeExprContext ctx) {
        Object target = this.visit((ParseTree)ctx.target);
        if (target == null) {
            return null;
        }
        String mdName = ctx.Identifier().getText();
        String refKey = ctx.refKey.getText();
        if (refKey.equals(".")) {
            if (target instanceof ClassReference) {
                return this.getStaticInvokeExpr((ClassReference)target, mdName, ctx.params, (ParserRuleContext)ctx);
            }
            if (target instanceof ExprNode) {
                return this.getObjectInvokeExpr((ExprNode)target, mdName, ctx.params, (ParserRuleContext)ctx);
            }
            throw Exceptions.unexceptedValue(target);
        }
        if (refKey.equals("->")) {
            ExprNode[] invokeArgs = new ExprNode[3];
            ExprNode[] params = new ExprNode[ctx.params.size()];
            if (target instanceof ClassReference) {
                invokeArgs[0] = new ConstExpr(null);
            } else if (target instanceof ExprNode) {
                invokeArgs[0] = (ExprNode)target;
            }
            invokeArgs[1] = new ConstExpr(mdName);
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.visitExpression(ctx.params.get(i));
            }
            invokeArgs[2] = this.createInitializedArray(Types.getRootType(), params);
            ClassNode dispatcherAst = this.getAst("kalang.runtime.dynamic.MethodDispatcher");
            if (dispatcherAst == null) {
                throw Exceptions.unexceptedException("Runtime library is required!");
            }
            return this.getStaticInvokeExpr(new ClassReference(dispatcherAst), "invokeMethod", invokeArgs, (ParserRuleContext)ctx);
        }
        if (refKey.equals("*.")) {
            if (!(target instanceof ExprNode)) {
                this.handleSyntaxError("expression required", ctx.expression);
                return null;
            }
            ExprNode targetExpr = (ExprNode)target;
            Type targetType = targetExpr.getType();
            if (!(targetType instanceof ArrayType)) {
                this.handleSyntaxError("array required", ctx.expression);
                return null;
            }
            LinkedList<Statement> stats = new LinkedList<Statement>();
            LocalVarNode varArrLen = this.declareTempLocalVar(Types.INT_TYPE);
            LocalVarNode varCounter = this.declareTempLocalVar(Types.INT_TYPE);
            stats.add(new VarDeclStmt(Arrays.asList(varArrLen, varCounter)));
            VarExpr varArrLenExpr = new VarExpr(varArrLen);
            VarExpr varCounterExpr = new VarExpr(varCounter);
            stats.add(new ExprStmt(new AssignExpr(varArrLenExpr, new ArrayLengthExpr(targetExpr))));
            stats.add(new ExprStmt(new AssignExpr(varCounterExpr, new ConstExpr(0))));
            CompareExpr conditionExpr = new CompareExpr(varCounterExpr, varArrLenExpr, "<");
            ElementExpr targetEleExpr = new ElementExpr(targetExpr, varCounterExpr);
            ExprNode invokeExpr = this.getObjectInvokeExpr((ExprNode)targetEleExpr, mdName, ctx.params, (ParserRuleContext)ctx);
            if (invokeExpr == null) {
                return null;
            }
            LocalVarNode varRet = this.declareTempLocalVar(Types.getArrayType(invokeExpr.getType()));
            VarExpr varRetExpr = new VarExpr(varRet);
            stats.add(new VarDeclStmt(varRet));
            stats.add(new ExprStmt(new AssignExpr(varRetExpr, new NewArrayExpr(invokeExpr.getType(), varArrLenExpr))));
            BlockStmt loopBody = this.newBlock();
            loopBody.statements.add(new ExprStmt(new AssignExpr(new ElementExpr(varRetExpr, varCounterExpr), invokeExpr)));
            loopBody.statements.add(new ExprStmt(new AssignExpr(varCounterExpr, new MathExpr(varCounterExpr, new ConstExpr(1), "+"))));
            this.popBlock();
            LoopStmt loopStmt = new LoopStmt(conditionExpr, null, loopBody);
            stats.add(loopStmt);
            return new MultiStmtExpr(stats, varRetExpr);
        }
        throw Exceptions.unexceptedException(refKey);
    }

    public ExprNode visitGetFieldExpr(KalangParser.GetFieldExprContext ctx) {
        return this.createFieldExpr(ctx, null, OffsetRangeHelper.getOffsetRange(ctx));
    }

    public UnaryExpr visitUnaryExpr(KalangParser.UnaryExprContext ctx) {
        String op = ctx.getChild(0).getText();
        UnaryExpr ue = new UnaryExpr(this.visitExpression(ctx.expression()), op);
        if (!this.semanticAnalyzer.validateUnaryExpr(ue)) {
            return null;
        }
        this.mapAst((AstNode)ue, ctx);
        return ue;
    }

    public ElementExpr visitGetArrayElementExpr(KalangParser.GetArrayElementExprContext ctx) {
        ElementExpr ee = new ElementExpr(this.visitExpression(ctx.expression(0)), this.visitExpression(ctx.expression(1)));
        if (!this.semanticAnalyzer.validateElementExpr(ee)) {
            return null;
        }
        this.mapAst((AstNode)ee, ctx);
        return ee;
    }

    private boolean isDefindedId(String id) {
        if (this.isClassId(id)) {
            return true;
        }
        return this.getNodeById(id, null) != null;
    }

    private boolean isClassId(String name) {
        return this.typeNameResolver.resolve(name, this.topClass, this.thisClazz) != null;
    }

    @Nullable
    private ParameterNode getNamedParameter(String name) {
        if (this.method != null) {
            for (ParameterNode p : this.method.getParameters()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    @Nullable
    private LocalVarNode getNamedLocalVar(String name) {
        return this.varTables.get(name);
    }

    @Nullable
    private AstNode getNodeById(@Nonnull String name, @Nullable Token token) {
        if (this.isClassId(name)) {
            ClassReference clsRef = new ClassReference(this.requireAst(name, token));
            if (token != null) {
                this.mapAst((AstNode)clsRef, token);
            }
            return clsRef;
        }
        LocalVarNode var = this.getNamedLocalVar(name);
        if (var != null) {
            VarExpr ve = new VarExpr(var, this.getVarObjectType(var));
            if (token != null) {
                this.mapAst((AstNode)ve, token);
            }
            return ve;
        }
        ParameterNode paramNode = this.getNamedParameter(name);
        if (paramNode != null) {
            ParameterExpr ve = new ParameterExpr(paramNode, this.getVarObjectType(paramNode));
            if (token != null) {
                this.mapAst((AstNode)ve, token);
            }
            return ve;
        }
        ExprNode fieldExpr = this.getObjectFieldExpr(new ThisExpr(this.getThisType()), name, ParserRuleContext.EMPTY);
        if (fieldExpr == null) {
            fieldExpr = this.getStaticFieldExpr(new ClassReference(this.thisClazz), name, ParserRuleContext.EMPTY);
        }
        if (fieldExpr != null) {
            return fieldExpr;
        }
        ExprNode outerClassInstanceExpr = this.getOuterClassInstanceExpr(new ThisExpr(this.getThisType()));
        while (outerClassInstanceExpr != null) {
            ExprNode fe = this.getObjectFieldExpr(outerClassInstanceExpr, name, ParserRuleContext.EMPTY);
            if (fe == null) {
                fe = this.getStaticFieldExpr(new ClassReference(this.thisClazz), name, ParserRuleContext.EMPTY);
            }
            if (fe != null) {
                return fe;
            }
            outerClassInstanceExpr = this.getOuterClassInstanceExpr(outerClassInstanceExpr);
        }
        return null;
    }

    public ConstExpr parseLiteral(KalangParser.LiteralContext ctx, @Nullable Type exceptedType) {
        Object v;
        String t = ctx.getText();
        if (ctx.IntegerLiteral() != null) {
            long longValue;
            if (t.toUpperCase().endsWith("L")) {
                t = t.substring(0, t.length() - 1);
                exceptedType = Types.LONG_TYPE;
            } else if (t.toLowerCase().endsWith("i")) {
                t = t.substring(0, t.length() - 1);
                exceptedType = Types.INT_TYPE;
            }
            try {
                longValue = (int)StringLiteralUtil.parseLong(t);
            }
            catch (NumberFormatException ex) {
                this.handleSyntaxError("invalid number", ctx);
                return null;
            }
            v = Types.BYTE_TYPE.equals(exceptedType) ? (Number)((byte)longValue) : (Number)(Types.LONG_TYPE.equals(exceptedType) ? (Number)longValue : (Number)((int)longValue));
        } else if (ctx.FloatingPointLiteral() != null) {
            double doubleValue;
            try {
                doubleValue = Double.parseDouble(t);
            }
            catch (NumberFormatException ex) {
                this.handleSyntaxError("invalid float value", ctx);
                return null;
            }
            v = Types.FLOAT_TYPE.equals(exceptedType) ? (Number)Float.valueOf((float)doubleValue) : (Number)doubleValue;
        } else if (ctx.BooleanLiteral() != null) {
            v = Boolean.parseBoolean(t);
        } else if (ctx.CharacterLiteral() != null) {
            char[] chars = t.toCharArray();
            v = Character.valueOf(chars[1]);
        } else if (ctx.StringLiteral() != null) {
            v = StringLiteralUtil.parse(t.substring(1, t.length() - 1));
        } else if (ctx.MultiLineStringLiteral() != null) {
            v = StringLiteralUtil.parse(t.substring(3, t.length() - 3));
        } else if (ctx.Identifier() != null) {
            ClassReference cr = this.requireClassReference(ctx.Identifier().getSymbol());
            v = cr;
        } else if (ctx.getText().equals("null")) {
            v = null;
        } else {
            throw Exceptions.unexceptedValue(ctx.getText());
        }
        ConstExpr ce = new ConstExpr(v);
        this.mapAst((AstNode)ce, ctx);
        return ce;
    }

    public ConstExpr visitLiteral(KalangParser.LiteralContext ctx) {
        return this.parseLiteral(ctx, null);
    }

    public AstNode visitImportDecl(KalangParser.ImportDeclContext ctx) {
        String name = ctx.name.getText();
        String delim = ctx.delim.getText();
        String prefix = "";
        if ("\\".equals(delim)) {
            boolean relative = ctx.root == null || ctx.root.getText().length() == 0;
            String packageName = this.getPackageName();
            if (relative && packageName.length() > 0) {
                prefix = packageName + ".";
            }
        }
        if (ctx.path != null) {
            for (Token p : ctx.path) {
                prefix = prefix + p.getText() + ".";
            }
        }
        if (name.equals("*")) {
            this.typeNameResolver.importPackage(prefix.substring(0, prefix.length() - 1));
        } else {
            String key = name;
            if (ctx.alias != null) {
                key = ctx.alias.getText();
            }
            this.typeNameResolver.importClass(prefix + name, key);
        }
        return null;
    }

    public AstNode visitQualifiedName(KalangParser.QualifiedNameContext ctx) {
        return null;
    }

    protected String parseTreeToText(ParseTree ctx) {
        if (ctx instanceof TerminalNode) {
            return ctx.getText();
        }
        StringBuilder sb = new StringBuilder();
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.parseTreeToText(ctx.getChild(i)));
        }
        return sb.toString();
    }

    protected int parseModifier(KalangParser.VarModifierContext modifier) {
        int defaultModifier = 1;
        if (modifier == null) {
            return defaultModifier;
        }
        String modifierText = this.parseTreeToText((ParseTree)modifier);
        if (modifierText.isEmpty()) {
            return defaultModifier;
        }
        try {
            return ModifierUtil.parse(modifierText);
        }
        catch (InvalidModifierException ex) {
            this.handleSyntaxError(ex.getMessage(), modifier);
            return defaultModifier;
        }
    }

    public AstNode visitNewExpr(KalangParser.NewExprContext ctx) {
        ObjectType clsType = this.parseClassType(ctx.classType());
        if (clsType == null) {
            return null;
        }
        ExprNode[] params = this.visitAll(ctx.params).toArray(new ExprNode[0]);
        LinkedList<ExprNode> paramList = new LinkedList<ExprNode>(Arrays.asList(params));
        try {
            if (this.isNonStaticInnerClass(clsType.getClassNode())) {
                paramList.add(0, new ThisExpr(this.getThisType()));
            }
            params = paramList.toArray(new ExprNode[paramList.size()]);
            NewObjectExpr newExpr = new NewObjectExpr(clsType, params);
            this.mapAst((AstNode)newExpr, ctx);
            return newExpr;
        }
        catch (MethodNotFoundException ex) {
            this.methodNotFound(ctx.classType().rawClass, clsType.getName(), "<init>", params);
            return null;
        }
        catch (AmbiguousMethodException ex) {
            this.methodIsAmbiguous(ctx.classType().rawClass, ex);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public AstNode visitCastExpr(KalangParser.CastExprContext ctx) {
        void var2_7;
        ExprNode expr = this.visitExpression(ctx.expression());
        Type toType = this.parseType(ctx.type());
        Type fromType = expr.getType();
        if (fromType instanceof PrimitiveType) {
            if (!(toType instanceof PrimitiveType)) {
                this.handleSyntaxError("unable to cast primitive type to class type", ctx);
                return null;
            }
            PrimitiveCastExpr primitiveCastExpr = new PrimitiveCastExpr((PrimitiveType)fromType, (PrimitiveType)toType, expr);
        } else {
            if (toType instanceof PrimitiveType) {
                this.handleSyntaxError("unable to cast class type to primitive type", ctx);
                return null;
            }
            CastExpr castExpr = new CastExpr(toType, expr);
        }
        this.mapAst((AstNode)var2_7, ctx);
        return var2_7;
    }

    public AstNode visitTryStat(KalangParser.TryStatContext ctx) {
        BlockStmt tryExecStmt = this.requireBlock(ctx.exec);
        boolean tryReturned = this.returned;
        LinkedList<CatchBlock> tryCatchBlocks = new LinkedList<CatchBlock>();
        if (ctx.catchTypes != null) {
            for (int i = 0; i < ctx.catchTypes.size(); ++i) {
                this.newFrame();
                this.returned = false;
                String vName = ctx.catchVarNames.get(i).getText();
                String vType = ctx.catchTypes.get(i).getText();
                LocalVarNode vo = this.declareLocalVar(vName, this.requireClassType(vType, ctx.catchTypes.get((int)i).start), ctx);
                if (vo == null) {
                    return null;
                }
                BlockStmt catchExecStmt = this.requireBlock(ctx.catchExec.get(i));
                CatchBlock catchStmt = new CatchBlock(vo, catchExecStmt);
                tryCatchBlocks.add(catchStmt);
                this.returned = this.returned && tryReturned;
                this.popFrame();
            }
        }
        BlockStmt tryFinallyStmt = null;
        if (ctx.finallyExec != null) {
            tryFinallyStmt = this.requireBlock(ctx.finallyExec);
        }
        TryStmt tryStmt = new TryStmt(tryExecStmt, tryCatchBlocks, tryFinallyStmt);
        this.mapAst((AstNode)tryStmt, ctx);
        return tryStmt;
    }

    public Statement visitLocalVarDecl(KalangParser.LocalVarDeclContext ctx) {
        MultiStmt ms = new MultiStmt();
        for (KalangParser.VarDeclContext v : ctx.varDecl()) {
            KalangParser.TypeContext varType = v.varType;
            Type exceptedType = varType == null ? null : this.parseType(varType);
            ExprNode initExpr = null;
            KalangParser.ExpressionContext initExprContext = v.expression();
            if (initExprContext != null) {
                initExpr = initExprContext instanceof KalangParser.LiteralExprContext ? this.parseLiteral(((KalangParser.LiteralExprContext)initExprContext).literal(), exceptedType) : this.visitExpression(initExprContext);
            }
            VarInfo varInfo = this.varDecl(v, initExpr == null ? Types.getRootType() : initExpr.getType());
            LocalVarNode localVar = this.declareLocalVar(varInfo.name, varInfo.type, ctx);
            if (localVar == null) {
                return null;
            }
            VarDeclStmt vds = new VarDeclStmt(localVar);
            ms.statements.add(vds);
            if (initExpr != null) {
                AssignExpr assignExpr = new AssignExpr(new VarExpr(localVar), initExpr);
                this.mapAst((AstNode)assignExpr, v);
                ms.statements.add(new ExprStmt(assignExpr));
            }
            this.mapAst((AstNode)localVar, ctx);
        }
        return ms;
    }

    public AstNode visitIdentifierExpr(KalangParser.IdentifierExprContext ctx) {
        String name = ctx.Identifier().getText();
        AstNode expr = this.getNodeById(name, ctx.Identifier().getSymbol());
        if (expr == null) {
            this.handleSyntaxError(name + " is undefined!", ctx);
            return null;
        }
        this.mapAst(expr, ctx);
        return expr;
    }

    public AstNode visitLiteralExpr(KalangParser.LiteralExprContext ctx) {
        return this.visitLiteral(ctx.literal());
    }

    public AstNode visitParenExpr(KalangParser.ParenExprContext ctx) {
        return this.visitExpression(ctx.expression());
    }

    public void visitBlockStmt(KalangParser.StatContext[] stats, BlockStmt blockStmt) {
        this.newFrame();
        if (stats == null) {
            return;
        }
        for (KalangParser.StatContext s : stats) {
            blockStmt.statements.add(this.visitStat(s));
        }
        this.popFrame();
    }

    public AstNode visitBlockStmt(KalangParser.BlockStmtContext ctx) {
        BlockStmt bs = this.newBlock();
        List<KalangParser.StatContext> stats = ctx.stat();
        if (stats != null) {
            this.visitBlockStmt(stats.toArray(new KalangParser.StatContext[stats.size()]), bs);
        }
        this.mapAst((AstNode)bs, ctx);
        this.popBlock();
        return bs;
    }

    public AstNode visitVarModifier(KalangParser.VarModifierContext ctx) {
        throw new UnsupportedOperationException();
    }

    public AstNode visitSelfRefExpr(KalangParser.SelfRefExprContext ctx) {
        ExprNode expr;
        String key = ctx.ref.getText();
        if (key.equals("this")) {
            expr = new ThisExpr(this.getThisType());
        } else if (key.equals("super")) {
            expr = new SuperExpr(this.thisClazz);
        } else {
            throw Exceptions.unknownValue(key);
        }
        this.mapAst((AstNode)expr, ctx);
        return expr;
    }

    public Object visitPrimitiveType(KalangParser.PrimitiveTypeContext ctx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IncrementExpr visitIncExpr(KalangParser.IncExprContext ctx) {
        return this.getIncrementExpr(ctx.expression(), ctx.op.getText(), false);
    }

    public IncrementExpr visitPreIncExpr(KalangParser.PreIncExprContext ctx) {
        return this.getIncrementExpr(ctx.expression(), ctx.op.getText(), true);
    }

    public IncrementExpr getIncrementExpr(KalangParser.ExpressionContext expressionContext, String op, boolean isPrefix) {
        ExprNode expr = this.visitExpression(expressionContext);
        if (!(expr instanceof AssignableExpr)) {
            this.handleSyntaxError("require assignable expression", expressionContext);
            return null;
        }
        boolean isDesc = op.equals("--");
        return new IncrementExpr((AssignableExpr)expr, isDesc, isPrefix);
    }

    private ExprNode requireCastable(ExprNode expr1, Type fromType, Type toType, Token token) {
        ExprNode expr = BoxUtil.assign(expr1, fromType, toType);
        if (expr == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "unable to cast " + fromType + " to " + toType, token);
        }
        return expr;
    }

    @Nullable
    protected ExprNode getObjectFieldExpr(ExprNode expr, String fieldName, @Nullable ParserRuleContext rule) {
        FieldExpr ret;
        Type type = expr.getType();
        if (!(type instanceof ObjectType)) {
            return null;
        }
        ObjectType exprType = (ObjectType)type;
        if (exprType instanceof ArrayType) {
            return null;
        }
        try {
            ret = ObjectFieldExpr.create(expr, fieldName, exprType.getClassNode());
        }
        catch (FieldNotFoundException ex) {
            return null;
        }
        if (rule != null) {
            this.mapAst((AstNode)ret, rule);
        }
        return ret;
    }

    protected ExprNode getObjectFieldLikeExpr(ExprNode expr, String fieldName, @Nullable ParserRuleContext rule) {
        ExprNode ret;
        Type type = expr.getType();
        if (!(type instanceof ObjectType)) {
            this.handleSyntaxError("unsupported type", rule == null ? ParserRuleContext.EMPTY : rule);
            return null;
        }
        ObjectType exprType = (ObjectType)type;
        if (exprType instanceof ArrayType && fieldName.equals("length")) {
            ret = new ArrayLengthExpr(expr);
        } else {
            try {
                ret = ObjectFieldExpr.create(expr, fieldName, this.thisClazz);
            }
            catch (FieldNotFoundException ex) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "field not found:" + fieldName, rule);
                ret = new UnknownFieldExpr(expr, exprType.getClassNode(), fieldName);
            }
        }
        if (rule != null) {
            this.mapAst((AstNode)ret, rule);
        }
        return ret;
    }

    protected AssignableExpr getStaticFieldExpr(ClassReference clazz, String fieldName, ParserRuleContext rule) {
        StaticFieldExpr ret;
        try {
            ret = StaticFieldExpr.create(clazz, fieldName, this.thisClazz);
        }
        catch (FieldNotFoundException ex) {
            return null;
        }
        this.mapAst((AstNode)ret, rule);
        return ret;
    }

    public Object visitErrorousStat(KalangParser.ErrorousStatContext ctx) {
        this.handleSyntaxError("missing ';'", ctx, ctx.start, ctx.stop);
        return null;
    }

    public Object visitErrorousMemberExpr(KalangParser.ErrorousMemberExprContext ctx) {
        this.handleSyntaxError("identifier excepted", ctx, ctx.stop, ctx.stop);
        return null;
    }

    public Object visitInstanceofExpr(KalangParser.InstanceofExprContext ctx) {
        ExprNode expr = this.visitExpression(ctx.expression());
        Token ts = ctx.Identifier().getSymbol();
        AstNode tnode = this.getNodeById(ts.getText(), ts);
        if (tnode instanceof ClassReference) {
            InstanceOfExpr ie = new InstanceOfExpr(expr, (ClassReference)tnode);
            this.mapAst((AstNode)ie, ctx);
            return ie;
        }
        this.handleSyntaxError("unsupported type", ts);
        return null;
    }

    public Object visitScriptDef(KalangParser.ScriptDefContext ctx) {
        throw Exceptions.unexceptedException("");
    }

    protected List<AnnotationNode> getAnnotations(@Nullable List<KalangParser.AnnotationContext> ctxs) {
        LinkedList<AnnotationNode> list = new LinkedList<AnnotationNode>();
        if (ctxs != null) {
            for (KalangParser.AnnotationContext an : ctxs) {
                AnnotationNode anNode = this.visitAnnotation(an);
                if (anNode == null) continue;
                list.add(anNode);
            }
        }
        return list;
    }

    @Nullable
    private ExprNode getOuterClassInstanceExpr(ExprNode expr) {
        return this.getObjectFieldExpr(expr, "this$0", null);
    }

    private ExprNode requireOuterClassInstanceExpr(ExprNode e) {
        ExprNode expr = this.getOuterClassInstanceExpr(e);
        if (expr == null) {
            throw Exceptions.unexceptedException("BUG!");
        }
        return expr;
    }

    public Object visitClassDef(KalangParser.ClassDefContext ctx) {
        throw Exceptions.unexceptedException("");
    }

    @Nullable
    public AnnotationNode visitAnnotation(KalangParser.AnnotationContext ctx) {
        ClassNode anType = this.requireAst(ctx.annotationType);
        if (anType == null) {
            return null;
        }
        List<Token> vk = ctx.annotationValueKey;
        KalangParser.LiteralContext dv = ctx.annotationDefaultValue;
        AnnotationNode anNode = new AnnotationNode(anType);
        if (vk != null && vk.size() > 0) {
            List<KalangParser.LiteralContext> anValues = ctx.annotationValue;
            int ksize = vk.size();
            for (int i = 0; i < ksize; ++i) {
                String kname = vk.get(i).getText();
                ConstExpr value = this.visitLiteral(anValues.get(i));
                anNode.values.put(kname, value);
            }
        } else if (dv != null) {
            ConstExpr defaultValue = this.visitLiteral(dv);
            anNode.values.put("value", defaultValue);
        }
        if (!this.semanticAnalyzer.validateAnnotation(anNode)) {
            return null;
        }
        return anNode;
    }

    private BlockStmt requireBlock(ParserRuleContext stmt) {
        if (stmt instanceof KalangParser.BlockStmtContext) {
            return (BlockStmt)this.visit((ParseTree)stmt);
        }
        BlockStmt bs = this.newBlock();
        bs.statements.add((Statement)this.visit((ParseTree)stmt));
        this.popBlock();
        return bs;
    }

    public Object visitClassType(KalangParser.ClassTypeContext ctx) {
        return null;
    }

    public Object visitParameterizedElementType(KalangParser.ParameterizedElementTypeContext ctx) {
        return null;
    }

    private Type parseParameterizedElementType(KalangParser.ParameterizedElementTypeContext ctx) {
        KalangParser.TypeContext type = ctx.type();
        if (type != null) {
            return this.parseType(type);
        }
        return this.parseWildcardType(ctx.wildcardType());
    }

    public Object visitWildcardType(KalangParser.WildcardTypeContext ctx) {
        return null;
    }

    private Type parseWildcardType(KalangParser.WildcardTypeContext ctx) {
        ObjectType classType = this.parseClassType(ctx.classType());
        if (classType == null) {
            return null;
        }
        Type[] bounds = new Type[]{classType};
        String boundKind = ctx.boundKind.getText();
        if (boundKind.equals("super")) {
            return new WildcardType(new Type[]{Types.getRootType()}, bounds);
        }
        return new WildcardType(bounds, null);
    }

    public ObjectType getThisType() {
        return Types.getClassType(this.thisClazz);
    }

    @Nonnull
    private LocalVarNode declareTempLocalVar(Type type) {
        LocalVarNode var = this.declareLocalVar(null, type, ParserRuleContext.EMPTY);
        if (var == null) {
            throw Exceptions.unexceptedValue(var);
        }
        return var;
    }

    @Nullable
    private LocalVarNode declareLocalVar(String name, Type type, ParserRuleContext ctx) {
        LocalVarNode localVarNode = new LocalVarNode(type, name);
        ParameterNode param = this.getNamedParameter(name);
        LocalVarNode var = this.getNamedLocalVar(name);
        if (param != null || var != null) {
            this.handleSyntaxError("variable is defined", ctx);
            return null;
        }
        if (name != null) {
            this.varTables.put(name, localVarNode);
        }
        return localVarNode;
    }

    public Object visitForEachStat(KalangParser.ForEachStatContext ctx) {
        LoopStmt loopStmt;
        TerminalNode varId;
        BlockStmt block = this.newBlock();
        ExprNode expr = this.visitExpression(ctx.expression());
        Type exprType = expr.getType();
        List<TerminalNode> idsCtx = ctx.Identifier();
        VarExpr indexVarExpr = null;
        if (idsCtx.size() == 1) {
            varId = idsCtx.get(0);
        } else {
            TerminalNode indexId = idsCtx.get(0);
            LocalVarNode indexVar = this.declareLocalVar(indexId.getText(), Types.INT_TYPE, ctx);
            if (indexVar == null) {
                return null;
            }
            block.statements.add(new VarDeclStmt(indexVar));
            indexVarExpr = new VarExpr(indexVar);
            varId = idsCtx.get(1);
        }
        if (exprType instanceof ArrayType) {
            LocalVarNode localVarNode = this.declareLocalVar(varId.getText(), ((ArrayType)exprType).getComponentType(), ctx);
            if (localVarNode == null) {
                return null;
            }
            VarExpr localVariable = new VarExpr(localVarNode);
            block.statements.add(new VarDeclStmt(localVarNode));
            LocalVarNode lenVar = this.declareTempLocalVar(Types.INT_TYPE);
            LocalVarNode counterVar = this.declareTempLocalVar(Types.INT_TYPE);
            block.statements.add(new VarDeclStmt(lenVar));
            block.statements.add(new VarDeclStmt(counterVar));
            VarExpr counterVarExpr = new VarExpr(counterVar);
            VarExpr lenVarExpr = new VarExpr(lenVar);
            block.statements.add(new ExprStmt(new AssignExpr(lenVarExpr, new ArrayLengthExpr(expr))));
            block.statements.add(new ExprStmt(new AssignExpr(counterVarExpr, new ConstExpr(0))));
            CompareExpr cnd = new CompareExpr(counterVarExpr, lenVarExpr, "<");
            BlockStmt loopBody = this.newBlock();
            loopBody.statements.add(new ExprStmt(new AssignExpr(localVariable, new ElementExpr(expr, counterVarExpr))));
            if (indexVarExpr != null) {
                loopBody.statements.add(new ExprStmt(new AssignExpr(indexVarExpr, counterVarExpr)));
            }
            loopBody.statements.add(this.visitStat(ctx.stat()));
            loopBody.statements.add(new ExprStmt(new AssignExpr(counterVarExpr, new MathExpr(counterVarExpr, new ConstExpr(1), "+"))));
            this.popBlock();
            loopStmt = new LoopStmt(cnd, null, loopBody);
        } else {
            ObjectType iterType = Types.getIterableClassType();
            if (iterType.isAssignableFrom(exprType)) {
                ObjectInvokeExpr nextInvokeExpr;
                ObjectInvokeExpr cnd;
                ObjectInvokeExpr getIterableExpr;
                try {
                    getIterableExpr = ObjectInvokeExpr.create(expr, "iterator", null);
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex) {
                    throw Exceptions.unexceptedException(ex);
                }
                LocalVarNode iterableVarNode = this.declareTempLocalVar(getIterableExpr.getType());
                block.statements.add(new VarDeclStmt(iterableVarNode));
                VarExpr iterableVarExpr = new VarExpr(iterableVarNode);
                block.statements.add(new ExprStmt(new AssignExpr(iterableVarExpr, getIterableExpr)));
                if (indexVarExpr != null) {
                    block.statements.add(new ExprStmt(new AssignExpr(indexVarExpr, new ConstExpr(0))));
                }
                try {
                    cnd = ObjectInvokeExpr.create(iterableVarExpr, "hasNext", null);
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex) {
                    throw Exceptions.unexceptedException(ex);
                }
                BlockStmt loopBody = this.newBlock();
                try {
                    nextInvokeExpr = ObjectInvokeExpr.create(iterableVarExpr, "next", null);
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex) {
                    throw Exceptions.unexceptedException(ex);
                }
                LocalVarNode localVarNode = this.declareLocalVar(varId.getText(), nextInvokeExpr.getType(), ctx);
                if (localVarNode == null) {
                    return null;
                }
                VarExpr localVariable = new VarExpr(localVarNode);
                loopBody.statements.add(new VarDeclStmt(localVarNode));
                loopBody.statements.add(new ExprStmt(new AssignExpr(localVariable, new CastExpr(localVariable.getType(), nextInvokeExpr))));
                loopBody.statements.add(this.visitStat(ctx.stat()));
                if (indexVarExpr != null) {
                    loopBody.statements.add(new ExprStmt(new AssignExpr(indexVarExpr, new MathExpr(indexVarExpr, new ConstExpr(1), "+"))));
                }
                loopStmt = new LoopStmt(cnd, null, loopBody);
                this.popBlock();
            } else {
                this.handleSyntaxError("require array type or iterable type", ctx.expression());
                loopStmt = null;
            }
        }
        this.popBlock();
        if (loopStmt != null) {
            block.statements.add(loopStmt);
        }
        return block;
    }

    public Object visitArrayExpr(KalangParser.ArrayExprContext ctx) {
        KalangParser.TypeContext typeCtx;
        ExprNode[] initExprs;
        List<KalangParser.ExpressionContext> exprCtx = ctx.expression();
        if (exprCtx != null) {
            initExprs = new ExprNode[exprCtx.size()];
            for (int i = 0; i < initExprs.length; ++i) {
                initExprs[i] = this.visitExpression(exprCtx.get(i));
            }
        } else {
            initExprs = new ExprNode[]{};
        }
        Type type = (typeCtx = ctx.type()) != null ? this.parseType(typeCtx) : TypeUtil.getCommonType(AstUtil.getExprTypes(initExprs));
        for (int i = 0; i < initExprs.length; ++i) {
            if (exprCtx == null) {
                throw Exceptions.unexceptedValue(exprCtx);
            }
            initExprs[i] = this.requireCastable(initExprs[i], initExprs[i].getType(), type, exprCtx.get(i).getStart());
            if (initExprs[i] != null) continue;
            return null;
        }
        ExprNode arrExpr = this.createInitializedArray(type, initExprs);
        this.mapAst((AstNode)arrExpr, ctx);
        return arrExpr;
    }

    private Type getVarObjectType(VarObject p) {
        Type type = this.overrideTypes.get(p);
        if (type == null) {
            type = p.getType();
        }
        if (type instanceof ClassType) {
            NullableKind nullable;
            Integer ns = this.nullState.get(p);
            if (ns == null) {
                nullable = ((ObjectType)type).getNullable();
            } else if (ns == 1) {
                nullable = NullableKind.NONNULL;
            } else if (ns == 2) {
                nullable = NullableKind.UNKNOWN;
            } else if (ns == 0 || ns == 3) {
                nullable = NullableKind.NULLABLE;
            } else {
                throw Exceptions.unexceptedValue(ns);
            }
            return Types.getClassType((ClassType)type, nullable);
        }
        return type;
    }

    public Object visitInterpolationExpr(KalangParser.InterpolationExprContext ctx) {
        List children = ctx.children;
        ExprNode[] exprs = new ExprNode[children.size()];
        Token[] exprTokens = new Token[children.size()];
        for (int i = 0; i < exprs.length; ++i) {
            ParseTree c = (ParseTree)children.get(i);
            if (c instanceof TerminalNode) {
                String text;
                Token token = ((TerminalNode)c).getSymbol();
                int t = token.getType();
                String rawText = c.getText();
                switch (t) {
                    case 110: {
                        text = rawText.substring(1, rawText.length() - 2);
                        break;
                    }
                    case 120: {
                        text = rawText;
                        break;
                    }
                    case 70: 
                    case 118: 
                    case 119: {
                        text = "";
                        break;
                    }
                    default: {
                        throw Exceptions.unexceptedValue(t);
                    }
                }
                exprs[i] = new ConstExpr(StringLiteralUtil.parse(text));
                exprTokens[i] = token;
                continue;
            }
            if (c instanceof KalangParser.ExpressionContext) {
                ExprNode expr = this.visitExpression((KalangParser.ExpressionContext)c);
                if (expr == null) {
                    return null;
                }
                exprs[i] = expr;
                exprTokens[i] = ((KalangParser.ExpressionContext)c).getStart();
                continue;
            }
            throw Exceptions.unexceptedValue(c);
        }
        return this.concatExpressionsToStringExpr(exprs, exprTokens);
    }

    public Object visitBitShiftExpr(KalangParser.BitShiftExprContext ctx) {
        Token opStart;
        String op;
        if (ctx.left != null) {
            op = "<<";
            opStart = ctx.left;
        } else if (ctx.right != null) {
            op = ">>";
            opStart = ctx.right;
        } else if (ctx.uright != null) {
            op = ">>>";
            opStart = ctx.uright;
        } else {
            throw Exceptions.unexceptedValue((Object)ctx);
        }
        return this.createBinaryExpr(op, ctx.expression(0), ctx.expression(1), opStart, ctx.stop, ctx);
    }

    public ExprNode createInitializedArray(Type type, ExprNode[] exprs) {
        NewArrayExpr ae = new NewArrayExpr(type, new ConstExpr(exprs.length));
        if (exprs.length > 0) {
            Statement[] initStmts = new Statement[exprs.length + 2];
            LocalVarNode local = this.declareTempLocalVar(ae.getType());
            initStmts[0] = new VarDeclStmt(local);
            VarExpr arrVar = new VarExpr(local);
            initStmts[1] = new ExprStmt(new AssignExpr(arrVar, ae));
            for (int i = 0; i < exprs.length; ++i) {
                initStmts[i + 2] = new ExprStmt(new AssignExpr(new ElementExpr(arrVar, new ConstExpr(i)), exprs[i]));
            }
            return new MultiStmtExpr(Arrays.asList(initStmts), arrVar);
        }
        return ae;
    }

    public void setDiagnosisHandler(DiagnosisHandler diagnosisHandler) {
        this.diagnosisReporter = new DiagnosisReporter(this.compilationUnit.getCompileContext(), diagnosisHandler, this.compilationUnit.getSource());
    }

    public DiagnosisReporter getDiagnosisReporter() {
        return this.diagnosisReporter;
    }

    static class VarInfo {
        public Type type;
        public String name;

        VarInfo() {
        }
    }
}

