/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.AstNotFoundException;
import kalang.ast.ClassNode;
import kalang.compiler.JavaAstLoader;
import kalang.util.AstUtil;

public class AstLoader {
    public static final AstLoader BASE_AST_LOADER = new JavaAstLoader();
    @Nonnull
    private final HashMap<String, ClassNode> cachedAsts = new HashMap();
    @Nullable
    private AstLoader parent = null;

    public AstLoader() {
    }

    public AstLoader(@Nonnull AstLoader astLoader) {
        this.parent = astLoader;
    }

    public void add(@Nonnull ClassNode clazz) {
        this.cachedAsts.put(clazz.name, clazz);
    }

    @Nonnull
    protected ClassNode findAst(@Nonnull String className) throws AstNotFoundException {
        ClassNode ast = null;
        if (this != BASE_AST_LOADER) {
            ast = BASE_AST_LOADER.findAst(className);
        }
        if (ast == null) {
            throw new AstNotFoundException(className);
        }
        return ast;
    }

    @Nonnull
    public ClassNode loadAst(@Nonnull String className) throws AstNotFoundException {
        ClassNode ast = this.cachedAsts.get(className);
        if (ast != null) {
            return ast;
        }
        if (this.parent != null) {
            try {
                return this.parent.loadAst(className);
            }
            catch (AstNotFoundException astNotFoundException) {
                // empty catch block
            }
        }
        if (className.endsWith("[]")) {
            String name = className;
            name = name.substring(0, name.length() - 2);
            ast = AstUtil.createArrayAst(this.loadAst((String)name).name);
        } else {
            ast = this.findAst(className);
            if (ast == null) {
                throw new AstNotFoundException(className);
            }
        }
        this.cachedAsts.put(className, ast);
        return ast;
    }

    @Nullable
    public ClassNode getAst(@Nonnull String className) {
        try {
            return this.loadAst(className);
        }
        catch (AstNotFoundException e) {
            return null;
        }
    }
}

