/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import kalang.antlr.KalangParser;
import kalang.antlr.KalangParserBaseVisitor;
import kalang.ast.AstNode;
import kalang.ast.ClassNode;
import kalang.compiler.AstBuilder;
import kalang.compiler.CompilationUnit;
import kalang.compiler.Diagnosis;
import kalang.compiler.DiagnosisHandler;
import kalang.compiler.DiagnosisReporter;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class ClassNodeBuilder
extends KalangParserBaseVisitor<Object> {
    private ClassNode topClass;
    private ClassNode thisClazz;
    private Map<ClassNode, ParserRuleContext> defContext = new HashMap<ClassNode, ParserRuleContext>();
    private boolean inScriptMode = false;
    private boolean isScript = false;
    AstBuilder astBuilder;
    private final CompilationUnit compilationUnit;
    private DiagnosisReporter diagnosisReporter;

    public ClassNodeBuilder(CompilationUnit compilationUnit, AstBuilder astBuilder) {
        this.compilationUnit = compilationUnit;
        this.astBuilder = astBuilder;
    }

    public ClassNode build(KalangParser.CompilationUnitContext ctx) {
        this.visitCompilationUnit(ctx);
        return this.topClass;
    }

    @Override
    public Object visitScriptDef(KalangParser.ScriptDefContext ctx) {
        this.isScript = true;
        this.inScriptMode = true;
        String className = this.astBuilder.getClassName();
        int modifier = 1;
        this.topClass = this.thisClazz = new ClassNode(className, modifier);
        this.defContext.put(this.topClass, ctx);
        super.visitScriptDef(ctx);
        return null;
    }

    @Override
    public Object visitClassDef(KalangParser.ClassDefContext ctx) {
        String classDefName;
        ClassNode oldClass = this.thisClazz;
        Token nameIdentifier = ctx.name;
        int modifier = this.astBuilder.parseModifier(ctx.varModifier());
        if (this.inScriptMode) {
            modifier |= 8;
        }
        Token classKind = ctx.classKind;
        boolean isInterface = false;
        if (classKind != null && classKind.getText().equals("interface")) {
            modifier |= 0x600;
            isInterface = true;
        }
        if (oldClass != null) {
            if (nameIdentifier == null) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "Identifier excepted", ctx);
                return null;
            }
            classDefName = oldClass.name + "$" + nameIdentifier.getText();
        } else {
            classDefName = this.astBuilder.getClassName();
        }
        ClassNode theClass = this.thisClazz = new ClassNode(classDefName, modifier);
        this.astBuilder.thisClazz = this.thisClazz;
        this.defContext.put(theClass, ctx);
        if (oldClass == null) {
            this.topClass = theClass;
        } else {
            oldClass.classes.add(this.thisClazz);
            this.thisClazz.enclosingClass = oldClass;
        }
        boolean oldScriptMode = this.inScriptMode;
        this.inScriptMode = false;
        this.visit((ParseTree)ctx.classBody());
        this.inScriptMode = oldScriptMode;
        this.astBuilder.mapAst((AstNode)this.thisClazz, ctx);
        this.thisClazz = oldClass;
        return null;
    }

    private boolean isNonStaticInnerClass(ClassNode clazz) {
        return clazz.enclosingClass != null && !Modifier.isStatic(clazz.modifier);
    }

    private boolean isDeclaringNonStaticInnerClass() {
        return this.isNonStaticInnerClass(this.thisClazz);
    }

    public ClassNode getClassNode() {
        return this.topClass;
    }

    public ParserRuleContext getClassNodeDefContext(ClassNode classNode) {
        return this.defContext.get(classNode);
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setDiagnosisHandler(DiagnosisHandler diagnosisHandler) {
        this.diagnosisReporter = new DiagnosisReporter(this.compilationUnit.getCompileContext(), diagnosisHandler, this.compilationUnit.getSource());
    }
}

