/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import kalang.antlr.KalangParser;
import kalang.antlr.KalangParserBaseVisitor;
import kalang.ast.AnnotationNode;
import kalang.ast.AssignExpr;
import kalang.ast.AssignableExpr;
import kalang.ast.AstNode;
import kalang.ast.BlockStmt;
import kalang.ast.ClassNode;
import kalang.ast.ClassReference;
import kalang.ast.ExprNode;
import kalang.ast.ExprStmt;
import kalang.ast.FieldNode;
import kalang.ast.MethodNode;
import kalang.ast.ObjectFieldExpr;
import kalang.ast.ParameterExpr;
import kalang.ast.ParameterNode;
import kalang.ast.StaticFieldExpr;
import kalang.ast.ThisExpr;
import kalang.compiler.AstBuilder;
import kalang.compiler.ClassNodeBuilder;
import kalang.compiler.CompilationUnit;
import kalang.compiler.Diagnosis;
import kalang.compiler.DiagnosisHandler;
import kalang.compiler.DiagnosisReporter;
import kalang.core.GenericType;
import kalang.core.MethodDescriptor;
import kalang.core.NullableKind;
import kalang.core.ObjectType;
import kalang.core.Type;
import kalang.core.Types;
import kalang.exception.Exceptions;
import kalang.util.AstUtil;
import kalang.util.ClassTypeUtil;
import kalang.util.MethodUtil;
import kalang.util.ModifierUtil;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class ClassNodeMetaBuilder
extends KalangParserBaseVisitor<Object> {
    AstBuilder astBuilder;
    private final ClassNodeBuilder classNodeBuilder;
    private ClassNode thisClazz;
    private Map<MethodNode, KalangParser.StatContext[]> methodStatsContexts = new HashMap<MethodNode, KalangParser.StatContext[]>();
    private Map<MethodNode, KalangParser.MethodDeclContext> methodContexts = new HashMap<MethodNode, KalangParser.MethodDeclContext>();
    private MethodNode method;
    private boolean inScriptMode;
    private final CompilationUnit compilationUnit;
    private DiagnosisReporter diagnosisReporter;

    public ClassNodeMetaBuilder(CompilationUnit compilationUnit, AstBuilder astBuilder, ClassNodeBuilder classNodeBuilder) {
        this.compilationUnit = compilationUnit;
        this.astBuilder = astBuilder;
        this.classNodeBuilder = classNodeBuilder;
    }

    public void build(ClassNode cn, boolean inScriptMode) {
        this.thisClazz = cn;
        this.astBuilder.thisClazz = cn;
        ParserRuleContext ctx = this.classNodeBuilder.getClassNodeDefContext(cn);
        if (ctx != null) {
            this.visit((ParseTree)ctx);
        }
        for (ClassNode c : cn.classes) {
            this.build(c, false);
        }
    }

    @Override
    public Object visitClassDef(KalangParser.ClassDefContext ctx) {
        Object parentClass;
        this.thisClazz.annotations.addAll(this.astBuilder.getAnnotations(ctx.annotation()));
        this.thisClazz.modifier = this.astBuilder.parseModifier(ctx.varModifier());
        List<Token> gnrTypes = ctx.genericTypes;
        if (gnrTypes != null && !gnrTypes.isEmpty()) {
            for (Token g : gnrTypes) {
                GenericType gt = new GenericType(g.getText(), Types.getRootType(), null, NullableKind.NONNULL);
                this.thisClazz.declareGenericType(gt);
            }
        }
        ObjectType superType = null;
        if (ctx.parentClass != null) {
            parentClass = this.astBuilder.parseClassType(ctx.parentClass);
            if (parentClass != null) {
                superType = parentClass;
            }
        } else {
            superType = Types.getRootType();
        }
        if (Modifier.isInterface(this.thisClazz.modifier)) {
            this.thisClazz.addInterface(superType);
        } else {
            this.thisClazz.superType = superType;
        }
        if (ctx.interfaces != null && ctx.interfaces.size() > 0) {
            for (KalangParser.ClassTypeContext itf : ctx.interfaces) {
                ObjectType itfClz = this.astBuilder.parseClassType(itf);
                if (itfClz == null) continue;
                this.thisClazz.addInterface(itfClz);
            }
        }
        if (this.isDeclaringNonStaticInnerClass()) {
            parentClass = this.thisClazz.enclosingClass;
            if (parentClass == null) {
                throw Exceptions.unexceptedValue(parentClass);
            }
            this.thisClazz.createField(Types.getClassType(parentClass), "this$0", 4098);
        }
        this.visit((ParseTree)ctx.classBody());
        if (!(ModifierUtil.isInterface(this.thisClazz.modifier) || AstUtil.containsConstructor(this.thisClazz) || AstUtil.createEmptyConstructor(this.thisClazz))) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "failed to create constructor with no parameters", ctx);
        }
        MethodNode[] methods = this.thisClazz.getDeclaredMethodNodes();
        for (int i = 0; i < methods.length; ++i) {
            MethodNode node = methods[i];
            BlockStmt body = node.getBody();
            if (body == null || !AstUtil.isConstructor(node) || !this.isDeclaringNonStaticInnerClass()) continue;
            ClassNode enclosingClass = this.thisClazz.enclosingClass;
            if (enclosingClass == null) {
                throw Exceptions.unexceptedValue(enclosingClass);
            }
            ParameterNode outerInstanceParam = node.createParameter(0, Types.getClassType(enclosingClass), "this$0");
            ExprNode parentFieldExpr = this.astBuilder.getObjectFieldExpr(new ThisExpr(Types.getClassType(this.thisClazz)), "this$0", ParserRuleContext.EMPTY);
            if (parentFieldExpr == null) {
                throw Exceptions.unexceptedValue(parentFieldExpr);
            }
            body.statements.add(1, new ExprStmt(new AssignExpr((AssignableExpr)parentFieldExpr, new ParameterExpr(outerInstanceParam))));
        }
        for (FieldNode fieldNode : this.thisClazz.getFields()) {
            int mdf = fieldNode.modifier;
            if (!AstUtil.hasGetter(this.thisClazz, fieldNode)) {
                AstUtil.createGetter(this.thisClazz, fieldNode, mdf);
            }
            if (!AstUtil.hasSetter(this.thisClazz, fieldNode)) {
                AstUtil.createSetter(this.thisClazz, fieldNode, mdf);
            }
            fieldNode.modifier = ModifierUtil.setPrivate(mdf);
        }
        return null;
    }

    private boolean isNonStaticInnerClass(ClassNode clazz) {
        return clazz.enclosingClass != null && !Modifier.isStatic(clazz.modifier);
    }

    private boolean isDeclaringNonStaticInnerClass() {
        return this.isNonStaticInnerClass(this.thisClazz);
    }

    @Override
    public Object visitMethodDecl(KalangParser.MethodDeclContext ctx) {
        Object stats;
        MethodDescriptor overriddenMd;
        String[] paramNames;
        Type[] paramTypes;
        String name;
        Type type;
        boolean isOverriding;
        boolean bl = isOverriding = ctx.OVERRIDE() != null;
        if (ctx.prefix != null && ctx.prefix.getText().equals("constructor")) {
            type = Types.VOID_TYPE;
            name = "<init>";
        } else {
            type = ctx.type() == null ? Types.VOID_TYPE : this.astBuilder.parseType(ctx.returnType);
            name = ctx.name.getText();
        }
        List<KalangParser.TypeContext> paramTypesCtx = ctx.paramTypes;
        int modifier = this.astBuilder.parseModifier(ctx.varModifier());
        if (this.inScriptMode) {
            modifier |= 8;
        }
        if (paramTypesCtx != null) {
            int paramSize = paramTypesCtx.size();
            paramTypes = new Type[paramSize];
            paramNames = new String[paramSize];
            for (int i = 0; i < paramSize; ++i) {
                KalangParser.TypeContext t = paramTypesCtx.get(i);
                paramTypes[i] = this.astBuilder.parseType(t);
                paramNames[i] = ctx.paramIds.get(i).getText();
            }
        } else {
            paramTypes = new Type[]{};
            paramNames = new String[]{};
        }
        String mStr = MethodUtil.getDeclarationKey(name, paramTypes);
        boolean existed = Arrays.asList(this.thisClazz.getDeclaredMethodNodes()).stream().anyMatch(m -> MethodUtil.getDeclarationKey(m).equals(mStr));
        if (existed) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "declare method duplicately:" + mStr, ctx);
            return null;
        }
        KalangParser.BlockStmtContext blockStmt = ctx.blockStmt();
        if (blockStmt == null) {
            if (ModifierUtil.isInterface(this.thisClazz.modifier)) {
                modifier |= 0x400;
            } else if (!Modifier.isAbstract(modifier)) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method body required", ctx);
            } else if (!Modifier.isAbstract(this.thisClazz.modifier)) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "declare abstract method in non-abstract class", ctx);
            }
        }
        this.method = this.thisClazz.createMethodNode(type, name, modifier);
        for (int i = 0; i < paramTypes.length; ++i) {
            this.method.createParameter(paramTypes[i], paramNames[i]);
        }
        for (AnnotationNode a : this.astBuilder.getAnnotations(ctx.annotation())) {
            this.method.addAnnotation(a);
        }
        ObjectType superType = this.thisClazz.superType;
        if (superType == null) {
            superType = Types.getRootType();
        }
        if ((overriddenMd = ClassTypeUtil.getMethodDescriptor(superType, mStr, this.thisClazz, true, true)) == null) {
            overriddenMd = ClassTypeUtil.getMethodDescriptor(this.thisClazz.getInterfaces(), mStr, this.thisClazz, true, true);
        }
        if (isOverriding && overriddenMd == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method does not override any method", ctx);
        }
        if (!isOverriding && overriddenMd != null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method override a method but not declare", ctx);
        }
        this.methodContexts.put(this.method, ctx);
        KalangParser.BlockStmtContext bstm = ctx.blockStmt();
        if (bstm != null && (stats = bstm.stat()) != null) {
            this.methodStatsContexts.put(this.method, stats.toArray(new KalangParser.StatContext[stats.size()]));
        }
        if (ctx.exceptionTypes != null) {
            for (Token et : ctx.exceptionTypes) {
                ObjectType exType = this.astBuilder.requireClassType(et);
                if (exType == null) continue;
                this.method.addExceptionType(exType);
            }
        }
        this.astBuilder.mapAst((AstNode)this.method, ctx);
        MethodNode m2 = this.method;
        this.method = null;
        return m2;
    }

    @Nullable
    public KalangParser.StatContext[] getStatContexts(MethodNode mn) {
        return this.methodStatsContexts.get(mn);
    }

    @Override
    public Object visitClassBody(KalangParser.ClassBodyContext ctx) {
        for (KalangParser.FieldDeclContext f : ctx.fieldDecl()) {
            this.visit((ParseTree)f);
        }
        for (KalangParser.MethodDeclContext m : ctx.methodDecl()) {
            this.visit((ParseTree)m);
        }
        return null;
    }

    @Override
    public Void visitFieldDecl(KalangParser.FieldDeclContext ctx) {
        int mdf = this.astBuilder.parseModifier(ctx.varModifier());
        for (KalangParser.VarDeclContext vd : ctx.varDecl()) {
            ExprNode initExpr = vd.expression() != null ? this.astBuilder.visitExpression(vd.expression()) : null;
            AstBuilder.VarInfo varInfo = this.astBuilder.varDecl(vd, initExpr == null ? Types.getRootType() : initExpr.getType());
            FieldNode fieldNode = this.thisClazz.createField(varInfo.type, varInfo.name, mdf);
            if (initExpr == null) continue;
            if (AstUtil.isStatic(fieldNode.modifier)) {
                this.thisClazz.staticInitStmts.add(new ExprStmt(new AssignExpr(new StaticFieldExpr(new ClassReference(this.thisClazz), fieldNode), initExpr)));
                continue;
            }
            this.thisClazz.initStmts.add(new ExprStmt(new AssignExpr(new ObjectFieldExpr(new ThisExpr(Types.getClassType(this.thisClazz)), fieldNode), initExpr)));
        }
        return null;
    }

    @Override
    public Object visitScriptDef(KalangParser.ScriptDefContext ctx) {
        this.thisClazz.superType = Types.getRootType();
        List<KalangParser.MethodDeclContext> mds = ctx.methodDecl();
        if (mds != null) {
            for (KalangParser.MethodDeclContext m : mds) {
                this.visit((ParseTree)m);
            }
        }
        MethodNode mm = this.thisClazz.createMethodNode(Types.VOID_TYPE, "main", 9);
        mm.addExceptionType(Types.getExceptionClassType());
        mm.createParameter(Types.getArrayType(Types.getStringClassType()), "args");
        this.method = mm;
        List<KalangParser.StatContext> stats = ctx.stat();
        if (stats != null) {
            this.methodStatsContexts.put(mm, stats.toArray(new KalangParser.StatContext[stats.size()]));
        }
        AstUtil.createEmptyConstructor(this.thisClazz);
        return null;
    }

    public KalangParser.MethodDeclContext getMethodDeclContext(MethodNode mn) {
        return this.methodContexts.get(mn);
    }

    public void setDiagnosisHandler(DiagnosisHandler diagnosisHandler) {
        this.diagnosisReporter = new DiagnosisReporter(this.compilationUnit.getCompileContext(), diagnosisHandler, this.compilationUnit.getSource());
    }
}

