/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import kalang.compiler.CompileContext;
import kalang.compiler.Diagnosis;
import kalang.compiler.DiagnosisHandler;
import kalang.compiler.KalangSource;
import kalang.compiler.OffsetRange;
import kalang.util.OffsetRangeHelper;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public class DiagnosisReporter {
    private final CompileContext compileContext;
    private final DiagnosisHandler disgnosisHandler;
    private final KalangSource kalangSource;

    public DiagnosisReporter(CompileContext compileContext, DiagnosisHandler disgnosisHandler, KalangSource kalangSource) {
        this.compileContext = compileContext;
        this.disgnosisHandler = disgnosisHandler;
        this.kalangSource = kalangSource;
    }

    public void report(Diagnosis.Kind kind, String message, OffsetRange offset) {
        Diagnosis diagnosis = new Diagnosis(this.compileContext, kind, offset, message, this.kalangSource);
        this.disgnosisHandler.handleDiagnosis(diagnosis);
    }

    public void report(Diagnosis.Kind kind, String message, Token start, Token end) {
        OffsetRange offset = OffsetRangeHelper.getOffsetRange(start, end);
        this.report(kind, message, offset);
    }

    public void report(Diagnosis.Kind kind, String message, Token offset) {
        this.report(kind, message, offset, offset);
    }

    public void report(Diagnosis.Kind kind, String message, ParserRuleContext parserRuleCtx) {
        OffsetRange offset = OffsetRangeHelper.getOffsetRange(parserRuleCtx);
        this.report(kind, message, offset);
    }

    public void report(Diagnosis.Kind kind, String message) {
        this.report(kind, message, OffsetRange.NONE);
    }

    public CompileContext getCompileContext() {
        return this.compileContext;
    }

    public DiagnosisHandler getDisgnosisHandler() {
        return this.disgnosisHandler;
    }

    public KalangSource getKalangSource() {
        return this.kalangSource;
    }
}

