/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.AstNotFoundException;
import kalang.ast.ClassNode;
import kalang.ast.FieldNode;
import kalang.ast.MethodNode;
import kalang.compiler.AstLoader;
import kalang.core.ClassType;
import kalang.core.GenericType;
import kalang.core.NullableKind;
import kalang.core.ObjectType;
import kalang.core.Types;
import kalang.core.WildcardType;
import kalang.exception.Exceptions;
import kalang.util.MethodUtil;
import kalang.util.ModifierUtil;

public class JavaAstLoader
extends AstLoader {
    static String ROOT_CLASS = "java.lang.Object";
    private ClassLoader javaClassLoader;
    private Map<String, ClassNode> loadedClasses = new HashMap<String, ClassNode>();
    private final AstLoader parentAstLoader;

    private static String getMethodDeclarationKey(Executable m) {
        Class<?>[] pts = m.getParameterTypes();
        String[] types = new String[pts.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = pts[i].getName();
        }
        return MethodUtil.getDeclarationKey(m.getName(), types);
    }

    private ObjectType[] castToClassTypes(kalang.core.Type[] types) {
        if (types == null) {
            return null;
        }
        ObjectType[] cts = new ObjectType[types.length];
        for (int i = 0; i < types.length; ++i) {
            cts[i] = (ClassType)types[i];
        }
        return cts;
    }

    @Nonnull
    public ClassNode buildFromClass(@Nonnull Class clz) throws AstNotFoundException {
        ClassNode cn = new ClassNode();
        cn.name = clz.getName();
        cn.modifier = clz.getModifiers();
        this.loadedClasses.put(clz.getName(), cn);
        HashMap<TypeVariable, GenericType> genericTypes = new HashMap<TypeVariable, GenericType>();
        TypeVariable<Class<T>>[] typeParameters = clz.getTypeParameters();
        if (typeParameters.length > 0) {
            for (TypeVariable pt : typeParameters) {
                ObjectType[] interfaces;
                ObjectType superType;
                ObjectType[] bounds = this.castToClassTypes(this.transType(pt.getBounds(), genericTypes));
                if (bounds != null && bounds.length > 0) {
                    if (ModifierUtil.isInterface(bounds[0].getModifier())) {
                        superType = Types.getRootType();
                        interfaces = bounds;
                    } else {
                        superType = bounds[0];
                        interfaces = new ObjectType[bounds.length - 1];
                        System.arraycopy(bounds, 1, interfaces, 0, interfaces.length);
                    }
                } else {
                    superType = Types.getRootType();
                    interfaces = bounds;
                }
                GenericType gt = new GenericType(pt.getName(), superType, interfaces, NullableKind.NONNULL);
                genericTypes.put(pt, gt);
                cn.declareGenericType(gt);
            }
        }
        Type superType = clz.getGenericSuperclass();
        Class superClazz = clz.getSuperclass();
        if (superType != null) {
            cn.superType = (ObjectType)this.getType(superType, genericTypes, superClazz, NullableKind.NONNULL);
        }
        Type[] typeInterfaces = clz.getGenericInterfaces();
        Class<?>[] clzInterfaces = clz.getInterfaces();
        if (clzInterfaces != null) {
            for (int i = 0; i < clzInterfaces.length; ++i) {
                cn.addInterface((ObjectType)this.getType(typeInterfaces[i], genericTypes, clzInterfaces[i], NullableKind.NONNULL));
            }
        }
        LinkedList<Executable> methods = new LinkedList<Executable>();
        methods.addAll(Arrays.asList(clz.getDeclaredMethods()));
        methods.addAll(Arrays.asList(clz.getDeclaredConstructors()));
        for (Executable m : methods) {
            int mModifier;
            String mName;
            kalang.core.Type mType;
            NullableKind nullable = this.getNullable(m.getAnnotations());
            if (m instanceof Method) {
                mType = this.getType(((Method)m).getGenericReturnType(), genericTypes, ((Method)m).getReturnType(), nullable);
                mName = m.getName();
                mModifier = m.getModifiers();
            } else if (m instanceof Constructor) {
                mName = "<init>";
                mType = Types.VOID_TYPE;
                mModifier = m.getModifiers();
            } else {
                throw Exceptions.unexceptedValue(m);
            }
            MethodNode methodNode = cn.createMethodNode(mType, mName, mModifier);
            for (Parameter parameter : m.getParameters()) {
                NullableKind pnullable = this.getNullable(parameter.getAnnotations());
                methodNode.createParameter(this.getType(parameter.getParameterizedType(), genericTypes, parameter.getType(), pnullable), parameter.getName());
            }
            for (AnnotatedElement annotatedElement : m.getExceptionTypes()) {
                methodNode.addExceptionType(this.getType((Type)((Object)annotatedElement), genericTypes, (Class)annotatedElement, NullableKind.NONNULL));
            }
        }
        for (Field f : clz.getDeclaredFields()) {
            NullableKind nullable = this.getNullable(f.getAnnotations());
            FieldNode fieldNode = cn.createField(this.getType(f.getGenericType(), genericTypes, f.getType(), nullable), f.getName(), f.getModifiers());
        }
        return cn;
    }

    public JavaAstLoader(@Nullable AstLoader parentAstLoader, @Nonnull ClassLoader javaClassLoader) {
        this.javaClassLoader = javaClassLoader;
        this.parentAstLoader = parentAstLoader;
    }

    public JavaAstLoader() {
        this(null, JavaAstLoader.class.getClassLoader());
    }

    @Override
    protected ClassNode findAst(String className) throws AstNotFoundException {
        if (className == null) {
            System.err.println("warning:trying to null class");
            throw new AstNotFoundException("null");
        }
        ClassNode ast = this.loadedClasses.get(className);
        if (ast != null) {
            return ast;
        }
        try {
            return super.findAst(className);
        }
        catch (AstNotFoundException e) {
            try {
                Class<?> clz = this.javaClassLoader.loadClass(className);
                ast = this.buildFromClass(clz);
                return ast;
            }
            catch (ClassNotFoundException ex) {
                throw e;
            }
        }
    }

    @Nullable
    private kalang.core.Type[] transType(Type[] ts, Map<TypeVariable, GenericType> genericTypes) throws AstNotFoundException {
        kalang.core.Type[] ret = new kalang.core.Type[ts.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.transType(ts[i], genericTypes);
            if (ret[i] != null) continue;
            return null;
        }
        return ret;
    }

    @Nullable
    private kalang.core.Type transType(Type t, Map<TypeVariable, GenericType> genericTypes) throws AstNotFoundException {
        if (t instanceof TypeVariable) {
            GenericType vt = genericTypes.get((TypeVariable)t);
            if (vt != null) {
                return vt;
            }
            return null;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            kalang.core.Type rawType = this.transType(pt.getRawType(), genericTypes);
            if (!(rawType instanceof ObjectType)) {
                return null;
            }
            Type[] typeArgs = pt.getActualTypeArguments();
            kalang.core.Type[] gTypes = this.transType(typeArgs, genericTypes);
            if (gTypes == null) {
                return null;
            }
            return Types.getClassType(((ObjectType)rawType).getClassNode(), gTypes);
        }
        if (t instanceof java.lang.reflect.WildcardType) {
            java.lang.reflect.WildcardType wt = (java.lang.reflect.WildcardType)t;
            kalang.core.Type[] upperBounds = this.transType(wt.getUpperBounds(), genericTypes);
            if (upperBounds == null) {
                return null;
            }
            kalang.core.Type[] lowerBounds = this.transType(wt.getLowerBounds(), genericTypes);
            if (lowerBounds == null) {
                return null;
            }
            return new WildcardType(upperBounds, lowerBounds);
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)t;
            kalang.core.Type ct = this.transType(gt.getGenericComponentType(), genericTypes);
            if (ct == null) {
                return null;
            }
            return Types.getArrayType(ct, NullableKind.NONNULL);
        }
        if (t instanceof Class) {
            Class type = (Class)t;
            if (type.isPrimitive()) {
                return Types.getPrimitiveType(type.getTypeName());
            }
            if (type.isArray()) {
                kalang.core.Type ct = this.transType(type.getComponentType(), genericTypes);
                if (ct == null) {
                    return null;
                }
                return Types.getArrayType(ct);
            }
            return Types.getClassType(this.findAst(type.getName()));
        }
        return null;
    }

    private kalang.core.Type getType(Type t, Map<TypeVariable, GenericType> genericTypes, Class defaultClass, NullableKind nullable) throws AstNotFoundException {
        kalang.core.Type type = this.transType(t, genericTypes);
        if (type == null) {
            type = this.transType(defaultClass, genericTypes);
        }
        if (type instanceof ClassType) {
            return Types.getClassType((ClassType)type, nullable);
        }
        return type;
    }

    private NullableKind getNullable(Annotation[] annotations) {
        for (Annotation a : annotations) {
            String simpleName;
            Class<? extends Annotation> at = a.annotationType();
            switch (simpleName = at.getSimpleName().toLowerCase()) {
                case "nullable": 
                case "nullallowed": {
                    return NullableKind.NULLABLE;
                }
                case "nonnull": 
                case "notnull": {
                    return NullableKind.NONNULL;
                }
            }
        }
        return NullableKind.UNKNOWN;
    }
}

