/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.AstNotFoundException;
import kalang.antlr.KalangLexer;
import kalang.antlr.KalangParser;
import kalang.ast.ClassNode;
import kalang.compiler.AstBuilder;
import kalang.compiler.AstLoader;
import kalang.compiler.CodeGenerator;
import kalang.compiler.CompilationUnit;
import kalang.compiler.CompileContext;
import kalang.compiler.Diagnosis;
import kalang.compiler.DiagnosisHandler;
import kalang.compiler.JavaAstLoader;
import kalang.compiler.KalangSource;
import kalang.compiler.SemanticAnalyzer;
import kalang.compiler.SourceLoader;
import kalang.compiler.StandardDiagnosisHandler;
import kalang.compiler.codegen.Ast2Java;
import kalang.util.AntlrErrorString;
import kalang.util.LexerFactory;
import kalang.util.OffsetRangeHelper;
import kalang.util.TokenStreamFactory;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class KalangCompiler
extends AstLoader
implements CompileContext {
    private int compileTargetPhase = 6;
    private HashMap<String, CompilationUnit> compilationUnits = new HashMap();
    @Nonnull
    private final HashMap<String, KalangSource> sources = new HashMap();
    private int compilingPhase;
    protected DiagnosisHandler diagnosisHandler = StandardDiagnosisHandler.INSTANCE;
    protected AstLoader astLoader;

    public KalangCompiler() {
        this(new JavaAstLoader());
    }

    public KalangCompiler(AstLoader astLoader) {
        this.astLoader = astLoader;
    }

    public void addSource(String className, String source, String fileName) {
        KalangSource src = new KalangSource(className, source, fileName);
        this.addSource(src);
    }

    public void addSource(KalangSource source) {
        String className = source.getClassName();
        this.sources.put(className, source);
        this.compilationUnits.put(className, this.createCompilationUnit(source));
    }

    public void setCompileTargetPhase(int targetPhase) {
        this.compileTargetPhase = targetPhase;
    }

    public int getCompileTargetPhase() {
        return this.compileTargetPhase;
    }

    public void compile(int targetPhase) {
        while (this.compilingPhase < targetPhase && this.compilingPhase < this.compileTargetPhase) {
            ++this.compilingPhase;
            for (CompilationUnit unit : this.compilationUnits.values()) {
                unit.compile(this.compilingPhase);
            }
        }
    }

    public void compile() {
        this.compile(this.compileTargetPhase);
    }

    private ClassNode findInnerClass(ClassNode topClass, String className) {
        for (ClassNode c : topClass.classes) {
            if (className.equals(c.name)) {
                return c;
            }
            ClassNode ic = this.findInnerClass(c, className);
            if (ic == null) continue;
            return ic;
        }
        return null;
    }

    @Override
    protected ClassNode findAst(@Nonnull String className) throws AstNotFoundException {
        KalangSource source;
        SourceLoader sourceLoader;
        String[] classNameInfo = className.split("\\$", 2);
        String topClassName = classNameInfo[0];
        if (this.compilationUnits.containsKey(topClassName)) {
            CompilationUnit compilationUnit = this.compilationUnits.get(topClassName);
            ClassNode clazz = compilationUnit.getAst();
            if (classNameInfo.length == 1) {
                return clazz;
            }
            ClassNode c = this.findInnerClass(clazz, className);
            if (c != null) {
                return c;
            }
        }
        if ((sourceLoader = this.getSourceLoader()) != null && (source = sourceLoader.loadSource(className)) != null) {
            return this.createCompilationUnit(source).getAst();
        }
        return AstLoader.BASE_AST_LOADER.findAst(className);
    }

    @Nonnull
    public HashMap<String, KalangSource> getSources() {
        return this.sources;
    }

    @Nonnull
    public HashMap<String, CompilationUnit> getCompilationUnits() {
        return this.compilationUnits;
    }

    @Nullable
    public CompilationUnit getCompilationUnit(@Nonnull String className) {
        return this.compilationUnits.get(className);
    }

    protected CompilationUnit newCompilationUnit(KalangSource source) {
        return new CompilationUnit(source, this);
    }

    private CompilationUnit createCompilationUnit(KalangSource source) {
        CompilationUnit unit = this.newCompilationUnit(source);
        this.compilationUnits.put(source.getClassName(), unit);
        unit.compile(this.compilingPhase);
        return unit;
    }

    public int getCurrentCompilePhase() {
        return this.compilingPhase;
    }

    @Override
    public KalangLexer createLexer(CompilationUnit compilationUnit, String source) {
        return LexerFactory.createLexer(source);
    }

    @Override
    public CommonTokenStream createTokenStream(CompilationUnit compilationUnit, KalangLexer lexer) {
        return TokenStreamFactory.createTokenStream((TokenSource)lexer);
    }

    @Override
    public KalangParser createParser(final CompilationUnit compilationUnit, CommonTokenStream tokenStream) {
        KalangParser parser = new KalangParser((TokenStream)tokenStream);
        parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy(){

            public void reportError(Parser recognizer, RecognitionException e) {
                String msg = AntlrErrorString.exceptionString(recognizer, e);
                Diagnosis diagnosis = new Diagnosis(compilationUnit.getCompileContext(), Diagnosis.Kind.ERROR, OffsetRangeHelper.getOffsetRange(e.getOffendingToken()), msg, compilationUnit.getSource());
                KalangCompiler.this.diagnosisHandler.handleDiagnosis(diagnosis);
            }
        });
        return parser;
    }

    @Override
    public AstBuilder createAstBuilder(CompilationUnit compilationUnit, KalangParser parser) {
        return new AstBuilder(compilationUnit, parser);
    }

    @Override
    public CodeGenerator createCodeGenerator(CompilationUnit compilationUnit) {
        return new Ast2Java();
    }

    @Override
    public SemanticAnalyzer createSemanticAnalyzer(CompilationUnit compilationUnit, AstLoader astLoader) {
        return new SemanticAnalyzer(compilationUnit, astLoader);
    }

    @Override
    public AstLoader getAstLoader() {
        return this;
    }

    @Override
    public SourceLoader getSourceLoader() {
        return new SourceLoader(){

            @Override
            public KalangSource loadSource(String className) {
                return null;
            }
        };
    }

    @Override
    public DiagnosisHandler getDiagnosisHandler() {
        return this.diagnosisHandler;
    }

    public void setDiagnosisHandler(DiagnosisHandler diagnosisHandler) {
        this.diagnosisHandler = diagnosisHandler;
    }

    @Override
    public void stopCompile(int stopPhase) {
        this.setCompileTargetPhase(stopPhase);
    }

    @Override
    public int getCompilingPhase() {
        return this.compilingPhase;
    }
}

