/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.io.PrintStream;
import kalang.compiler.CompileContext;
import kalang.compiler.Diagnosis;
import kalang.compiler.DiagnosisHandler;

public class StandardDiagnosisHandler
implements DiagnosisHandler {
    public static StandardDiagnosisHandler INSTANCE = new StandardDiagnosisHandler();
    private final PrintStream errOut;
    private final PrintStream stdOut;

    public StandardDiagnosisHandler() {
        this(System.out, System.err);
    }

    public StandardDiagnosisHandler(PrintStream stdOut, PrintStream errOut) {
        this.stdOut = stdOut;
        this.errOut = errOut;
    }

    @Override
    public void handleDiagnosis(Diagnosis diagnosis) {
        boolean isError = diagnosis.getKind().isError();
        if (isError) {
            CompileContext ctx = diagnosis.getContext();
            ctx.stopCompile(ctx.getCompilingPhase());
        }
        PrintStream o = isError ? this.stdOut : this.errOut;
        o.println(diagnosis);
    }
}

