/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import kalang.ast.ClassNode;
import kalang.compiler.AstLoader;
import kalang.util.AstUtil;
import kalang.util.NameUtil;

public class TypeNameResolver {
    private Map<String, String> simpleToFullNames = new HashMap<String, String>();
    private List<String> importPackages = new LinkedList<String>();
    private AstLoader astLoader;

    public void importClass(String className) {
        this.importClass(className, NameUtil.getSimpleClassName(className));
    }

    public void importClass(String className, String alias) {
        this.simpleToFullNames.put(alias, className);
    }

    public void importPackage(String packageName) {
        this.importPackages.add(packageName);
    }

    private String fixInnerClassName(String className) {
        String name = "";
        for (String n : className.split("\\.")) {
            name = name + n;
            name = this.astLoader != null && this.astLoader.getAst(name) != null ? name + "$" : name + ".";
        }
        return name.substring(0, name.length() - 1);
    }

    @Nullable
    public String resolve(String id, ClassNode topClass, ClassNode declaringClass) {
        if (id.contains(".")) {
            return id;
        }
        if (this.simpleToFullNames.containsKey(id)) {
            return this.fixInnerClassName(this.simpleToFullNames.get(id));
        }
        String[] innerClassesNames = AstUtil.listInnerClassesNames(topClass, true);
        ArrayList<String> candidates = new ArrayList<String>(innerClassesNames.length + 1);
        candidates.add(topClass.name);
        candidates.addAll(Arrays.asList(innerClassesNames));
        for (String c : candidates) {
            if (id.equals(NameUtil.getClassNameWithoutPackage(c))) {
                return c;
            }
            if (!(declaringClass.name + "$" + id).equals(c)) continue;
            return c;
        }
        ArrayList<String> paths = new ArrayList<String>(this.importPackages.size() + 1);
        paths.add(NameUtil.getPackageName(topClass.name));
        paths.addAll(this.importPackages);
        for (String p : paths) {
            String clsName = p != null && p.length() > 0 ? p + "." + id : id;
            if (this.astLoader == null || this.astLoader.getAst(this.fixInnerClassName(clsName)) == null) continue;
            return clsName;
        }
        return null;
    }

    public void setAstLoader(AstLoader astLoader) {
        this.astLoader = astLoader;
    }
}

