/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.codegen;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kalang.ast.AbstractAstVisitor;
import kalang.ast.ArrayLengthExpr;
import kalang.ast.AssignExpr;
import kalang.ast.BinaryExpr;
import kalang.ast.BlockStmt;
import kalang.ast.BreakStmt;
import kalang.ast.CastExpr;
import kalang.ast.CatchBlock;
import kalang.ast.ClassNode;
import kalang.ast.ClassReference;
import kalang.ast.ConstExpr;
import kalang.ast.ContinueStmt;
import kalang.ast.ElementExpr;
import kalang.ast.ErrorousExpr;
import kalang.ast.ExprNode;
import kalang.ast.ExprStmt;
import kalang.ast.FieldExpr;
import kalang.ast.FieldNode;
import kalang.ast.IfStmt;
import kalang.ast.IncrementExpr;
import kalang.ast.InstanceOfExpr;
import kalang.ast.InvocationExpr;
import kalang.ast.LocalVarNode;
import kalang.ast.LoopStmt;
import kalang.ast.MethodNode;
import kalang.ast.MultiStmt;
import kalang.ast.MultiStmtExpr;
import kalang.ast.NewArrayExpr;
import kalang.ast.NewObjectExpr;
import kalang.ast.ObjectFieldExpr;
import kalang.ast.ObjectInvokeExpr;
import kalang.ast.ParameterExpr;
import kalang.ast.ParameterNode;
import kalang.ast.PrimitiveCastExpr;
import kalang.ast.ReturnStmt;
import kalang.ast.Statement;
import kalang.ast.StaticFieldExpr;
import kalang.ast.StaticInvokeExpr;
import kalang.ast.StoreArrayElementExpr;
import kalang.ast.SuperExpr;
import kalang.ast.ThisExpr;
import kalang.ast.ThrowStmt;
import kalang.ast.TryStmt;
import kalang.ast.UnaryExpr;
import kalang.ast.UnknownFieldExpr;
import kalang.ast.UnknownInvocationExpr;
import kalang.ast.VarDeclStmt;
import kalang.ast.VarExpr;
import kalang.ast.VarObject;
import kalang.compiler.CodeGenerator;
import kalang.core.ObjectType;
import kalang.core.Type;
import kalang.core.Types;
import kalang.exception.Exceptions;

@Deprecated
public class Ast2Java
extends AbstractAstVisitor<String>
implements CodeGenerator {
    private List<VarObject> varList = new LinkedList<VarObject>();
    protected String code = "";
    private String indent = "";
    private boolean trim = false;
    private ClassNode cls;
    private MethodNode method;

    private String getVarName(VarObject vo) {
        String name = vo.getName();
        String tmpNamePrefix = "tmp";
        if (name == null || name.startsWith(tmpNamePrefix)) {
            if (!this.varList.contains(vo)) {
                this.varList.add(vo);
            }
            name = tmpNamePrefix + "_" + this.varList.indexOf(vo);
        }
        return name;
    }

    private List<String> trimStmtAll(List<String> stmts) {
        LinkedList<String> retList = new LinkedList<String>();
        for (String s : stmts) {
            retList.add(this.trimStmt(s));
        }
        return retList;
    }

    private void p(String code) {
        this.code = this.code + code;
    }

    private void c(String code) {
        this.addCode(code);
    }

    private void addCode(String code) {
        if (code == null) {
            return;
        }
        if ((code = code.trim()).endsWith("}")) {
            if (this.indent.length() >= 4) {
                this.indent = this.indent.substring(4);
            }
            code = "\r\n" + this.indent + code + "\r\n";
            code = code + this.indent;
        }
        if (code.endsWith("{")) {
            this.indent = this.indent + "    ";
            code = code + "\r\n" + this.indent;
        }
        if (code.endsWith(";")) {
            code = this.trim ? code.substring(0, code.length() - 1) : code + "\r\n" + this.indent;
        }
        this.code = this.code + code + " ";
    }

    private String trimStmt(String stmt) {
        if ((stmt = stmt.trim()).endsWith(";")) {
            stmt = stmt.substring(0, stmt.length() - 1);
        }
        return stmt;
    }

    private String toJavaString(ConstExpr ce) {
        Object v = ce.getValue();
        Type t = ce.getType();
        if (v instanceof String) {
            return "\"" + v + "\"";
        }
        if (Types.CHAR_TYPE.equals(t)) {
            return "'" + v + "'";
        }
        if (Types.NULL_TYPE.equals(t)) {
            return "null";
        }
        return String.valueOf(v);
    }

    @Override
    public void generate(ClassNode cls) {
        this.code = "";
        this.visit(cls);
    }

    public String getCode() {
        return this.code;
    }

    private String className(String name) {
        return name.replace("$", ".");
    }

    @Override
    public String visitCastExpr(CastExpr node) {
        return String.format("(%s)%s", this.className(node.getToType().toString()), this.visit(node.getExpr()));
    }

    @Override
    public String visitParameterExpr(ParameterExpr node) {
        return node.getParameter().getName();
    }

    @Override
    public String visitVarExpr(VarExpr node) {
        return this.getVarName(node.getVar());
    }

    public String visitModifier(Integer modifier) {
        int m = modifier != null ? modifier : 0;
        return Modifier.toString(m);
    }

    String getVarStr(VarObject f) {
        String fs = "";
        String mdf = "";
        fs = fs + Modifier.toString(f.modifier) + " ";
        fs = fs + f.getType() + " " + f.getName();
        return fs;
    }

    @Override
    public String visitClassNode(ClassNode node) {
        this.cls = node;
        String imports = "";
        String fs = "";
        String mdf = this.visitModifier(node.modifier);
        String pkg = "";
        String name = node.name;
        int dotIdx = name.lastIndexOf(46);
        if (dotIdx > 0) {
            pkg = name.substring(0, dotIdx);
            name = name.substring(dotIdx + 1);
        }
        String pkgStr = pkg.length() > 0 ? "package " + pkg + ";" : "";
        String parentStr = "";
        if (node.superType != null) {
            parentStr = "extends " + node.superType.getName();
        }
        String impStr = "";
        if (node.getInterfaces().length > 0) {
            LinkedList<String> interfaces = new LinkedList<String>();
            for (ObjectType itf : node.getInterfaces()) {
                interfaces.add(itf.getName());
            }
            impStr = "implements " + String.join((CharSequence)",", interfaces);
        }
        String classType = Modifier.isInterface(node.modifier) ? "interface" : "class";
        this.c(pkgStr + "\r\n" + imports + "\r\n" + mdf + " " + classType + " " + name + " " + parentStr + " " + impStr + " {");
        for (FieldNode f : node.getFields()) {
            this.c(this.getVarStr(f) + ";\r\n");
        }
        this.visitAll(Arrays.asList(node.getDeclaredMethodNodes()));
        this.c("}");
        return null;
    }

    @Override
    public String visitMethodNode(MethodNode node) {
        this.method = node;
        LinkedList<String> psList = new LinkedList<String>();
        for (ParameterNode p : node.getParameters()) {
            psList.add(this.getVarStr(p));
        }
        String ps = String.join((CharSequence)",", psList);
        String exStr = "";
        Type[] exceptionTypes = node.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            ArrayList<String> types = new ArrayList<String>(exceptionTypes.length);
            for (Type et : exceptionTypes) {
                types.add(et.getName());
            }
            exStr = "throws " + String.join((CharSequence)",", types);
        }
        String mname = node.getName();
        String typeStr = "";
        int mdf = node.getModifier();
        if (mname.equals("<init>")) {
            mdf &= 0xFFFFFFF7;
            Objects.requireNonNull(this.cls, "cls must be not null");
            int lastIdx = this.cls.name.lastIndexOf(".");
            mname = lastIdx < 0 ? this.cls.name : this.cls.name.substring(lastIdx + 1);
        } else {
            typeStr = node.getType().getName();
        }
        this.c(this.visitModifier(mdf) + " " + typeStr + " " + mname + "(" + ps + ") " + exStr);
        if (node.getBody() != null) {
            this.c((String)this.visit(node.getBody()));
        } else {
            this.c(";");
        }
        return null;
    }

    @Override
    public String visitBlockStmt(BlockStmt node) {
        this.addCode("{");
        this.visitAll(node.statements);
        this.addCode("}");
        return null;
    }

    @Override
    public String visitBreakStmt(BreakStmt node) {
        this.addCode("break;");
        return null;
    }

    @Override
    public String visitContinueStmt(ContinueStmt node) {
        this.addCode("continue;");
        return null;
    }

    @Override
    public String visitExprStmt(ExprStmt node) {
        String expr = (String)this.visit(node.getExpr());
        this.addCode(expr + ';');
        return null;
    }

    @Override
    public String visitIfStmt(IfStmt node) {
        String cdt = this.trimStmt((String)this.visit(node.getConditionExpr()));
        this.c("if(" + cdt + ")");
        this.visit(node.getTrueBody());
        if (node.getFalseBody() != null) {
            this.c("else");
            this.visit(node.getFalseBody());
        }
        return null;
    }

    @Override
    public String visitLoopStmt(LoopStmt node) {
        ExprNode pre = node.getPreConditionExpr();
        ExprNode post = node.getPostConditionExpr();
        if (pre != null) {
            this.c("for(");
            this.trim = true;
            this.trim = false;
            this.p(";");
            this.c((String)this.visit(pre));
            this.p(";");
            this.c(")");
            this.visit(node.getLoopBody());
        } else {
            this.c("do");
            this.visit(node.getLoopBody());
            this.c("while(");
            this.visit(post);
            this.c(");");
        }
        return null;
    }

    @Override
    public String visitReturnStmt(ReturnStmt node) {
        String expr = "";
        if (node.expr != null) {
            expr = (String)this.visit(node.expr);
        }
        this.c("return " + expr + ";");
        return null;
    }

    public void visitVarObject(VarObject var) {
        String type = var.getType() != null ? var.getType().getName() : "Object";
        type = this.className(type);
        String name = this.getVarName(var);
        String code = type + " " + name;
        this.c(code + ";");
    }

    @Override
    public String visitAssignExpr(AssignExpr node) {
        String from = (String)this.visit(node.getFrom());
        String to = (String)this.visit(node.getTo());
        return to + "=" + from;
    }

    @Override
    public String visitBinaryExpr(BinaryExpr node) {
        return "(" + (String)this.visit(node.getExpr1()) + node.getOperation() + (String)this.visit(node.getExpr2()) + ")";
    }

    @Override
    public String visitConstExpr(ConstExpr node) {
        return this.toJavaString(node);
    }

    @Override
    public String visitElementExpr(ElementExpr node) {
        return (String)this.visit(node.getArrayExpr()) + "[" + (String)this.visit(node.getIndex()) + "]";
    }

    @Override
    public String visitFieldExpr(FieldExpr node) {
        String target;
        if (node instanceof ObjectFieldExpr) {
            target = (String)this.visit(((ObjectFieldExpr)node).getTarget());
        } else if (node instanceof StaticFieldExpr) {
            target = ((StaticFieldExpr)node).getClassReference().getReferencedClassNode().name;
        } else {
            throw Exceptions.unsupportedTypeException(node);
        }
        return target + "." + node.getField().getName();
    }

    @Override
    public String visitInvocationExpr(InvocationExpr node) {
        String fullCallName = null;
        String mname = node.getMethod().getName();
        if (node instanceof ObjectInvokeExpr) {
            ObjectInvokeExpr oie = (ObjectInvokeExpr)node;
            String invokeTarget = (String)this.visit(oie.getInvokeTarget());
            fullCallName = mname.equals("<init>") ? invokeTarget : invokeTarget + "." + mname;
        } else if (node instanceof StaticInvokeExpr) {
            StaticInvokeExpr sie = (StaticInvokeExpr)node;
            String invokeTarget = sie.getInvokeClass().getReferencedClassNode().name;
            fullCallName = invokeTarget + "." + mname;
        } else {
            throw Exceptions.unsupportedTypeException(node);
        }
        String args = String.join((CharSequence)",", this.visitAll(node.getArguments()));
        return fullCallName + "(" + args + ")";
    }

    @Override
    public String visitUnaryExpr(UnaryExpr node) {
        String expr = (String)this.visit(node.getExpr());
        String op = node.getOperation();
        return "(" + op + expr + ")";
    }

    @Override
    public String visitNewArrayExpr(NewArrayExpr node) {
        String type = node.getComponentType().toString();
        return "new " + type + "[" + (String)this.visit(node.getSize()) + "]";
    }

    @Override
    public String visitTryStmt(TryStmt node) {
        this.c("try");
        if (node.getExecStmt() instanceof BlockStmt) {
            this.visit(node.getExecStmt());
        } else {
            this.c("{");
            this.visit(node.getExecStmt());
            this.c("}");
        }
        for (CatchBlock c : node.getCatchStmts()) {
            this.visit(c);
        }
        if (node.getFinallyStmt() != null) {
            this.c("finally ");
            if (node.getFinallyStmt() instanceof BlockStmt) {
                this.visit(node.getFinallyStmt());
            } else {
                this.c("{");
                this.visit(node.getFinallyStmt());
                this.c("}");
            }
        }
        return null;
    }

    @Override
    public String visitCatchBlock(CatchBlock node) {
        this.c("catch(");
        this.trim = true;
        this.visit(node.catchVar);
        this.trim = false;
        this.c(")");
        if (node.execStmt instanceof BlockStmt) {
            this.visit(node.execStmt);
        } else {
            this.c("{");
            this.visit(node.execStmt);
            this.c("}");
        }
        return null;
    }

    @Override
    public String visitThisExpr(ThisExpr node) {
        return "this";
    }

    @Override
    public String visitMultiStmtExpr(MultiStmtExpr node) {
        for (Statement s : node.stmts) {
            this.visit(s);
        }
        return (String)this.visit(node.reference);
    }

    @Override
    public String visitThrowStmt(ThrowStmt node) {
        String expr = (String)this.visit(node.expr);
        this.c("throw " + expr + ";");
        return null;
    }

    @Override
    public String visitPrimitiveCastExpr(PrimitiveCastExpr node) {
        String expr = (String)this.visit(node.getExpr());
        return "(" + node.getToType() + "/*" + node.getFromType() + "*/)" + expr;
    }

    @Override
    public String visitLocalVarNode(LocalVarNode localVarNode) {
        this.visitVarObject(localVarNode);
        return null;
    }

    @Override
    public String visitParameterNode(ParameterNode parameterNode) {
        this.visitVarObject(parameterNode);
        return null;
    }

    @Override
    public String visitFieldNode(FieldNode fieldNode) {
        this.visitVarObject(fieldNode);
        return null;
    }

    @Override
    public String visitVarDeclStmt(VarDeclStmt node) {
        for (LocalVarNode v : node.vars) {
            this.visitVarObject(v);
        }
        return null;
    }

    @Override
    public String visitNewObjectExpr(NewObjectExpr node) {
        String args = "";
        if (node.getConstructor() != null && node.getConstructor().getArguments() != null) {
            args = String.join((CharSequence)",", this.visitAll(Arrays.asList(node.getConstructor().getArguments())));
        }
        return String.format("new %s(%s)", this.className(node.getObjectType().toString()), args);
    }

    @Override
    public String visitIncrementExpr(IncrementExpr node) {
        String op = node.isIsDesc() ? "--" : "++";
        String vn = (String)this.visit(node.getExpr());
        if (node.isIsPrefix()) {
            return op + vn;
        }
        return vn + op;
    }

    @Override
    public String visitArrayLengthExpr(ArrayLengthExpr node) {
        return (String)this.visit(node.getArrayExpr()) + ".length";
    }

    @Override
    public String visitUnknownFieldExpr(UnknownFieldExpr node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String visitUnknownInvocationExpr(UnknownInvocationExpr node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String visitClassReference(ClassReference node) {
        return node.getReferencedClassNode().name;
    }

    @Override
    public String visitSuperExpr(SuperExpr node) {
        return "super";
    }

    @Override
    public String visitErrorousExpr(ErrorousExpr node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String visitInstanceOfExpr(InstanceOfExpr node) {
        return "(" + (String)this.visit(node.getExpr()) + " instanceof " + (String)this.visit(node.getTarget()) + ")";
    }

    @Override
    public String visitMultiStmt(MultiStmt node) {
        this.visitAll(node.statements);
        return null;
    }

    @Override
    public String visitStoreArrayElementExpr(StoreArrayElementExpr node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

