/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.codegen;

import java.lang.reflect.Modifier;
import kalang.ast.AstVisitor;
import kalang.ast.ClassNode;
import kalang.ast.FieldNode;
import kalang.ast.MethodNode;
import kalang.ast.ParameterNode;
import kalang.compiler.CodeGenerator;
import kalang.core.GenericType;
import kalang.util.NameUtil;

public class Ast2JavaStub
extends AstVisitor<Void>
implements CodeGenerator {
    protected StringBuilder sb;
    private boolean isInterface = false;

    private static String getJavaTypeName(String typeName) {
        String type = typeName.replace('$', '.');
        if (type.endsWith("?")) {
            return type.substring(0, type.length() - 1);
        }
        return type;
    }

    @Override
    public Void visitFieldNode(FieldNode fieldNode) {
        this.sb.append(this.modifier2String(fieldNode.modifier)).append(" ").append(Ast2JavaStub.getJavaTypeName(fieldNode.getType().getName())).append(" ").append(fieldNode.getName()).append(";\n");
        return (Void)super.visitFieldNode(fieldNode);
    }

    @Override
    public Void visitMethodNode(MethodNode node) {
        this.sb.append(this.modifier2String(node.getModifier())).append(" ");
        boolean isConstructor = "<init>".equals(node.getName());
        if (isConstructor) {
            this.sb.append(NameUtil.getSimpleClassName(node.getClassNode().name));
        } else {
            this.sb.append(this.isInterface ? "" : "native ").append(Ast2JavaStub.getJavaTypeName(node.getType().getName())).append(" ").append(node.getName());
        }
        this.sb.append("(");
        super.visitMethodNode(node);
        this.sb.append(")");
        if (isConstructor) {
            this.sb.append("{}");
        } else {
            this.sb.append(";");
        }
        this.sb.append('\n');
        return null;
    }

    @Override
    public Void visitParameterNode(ParameterNode parameterNode) {
        char last = this.sb.charAt(this.sb.length() - 1);
        if (last != '(') {
            this.sb.append(",");
        }
        this.sb.append(Ast2JavaStub.getJavaTypeName(parameterNode.getType().getName())).append(" ").append(parameterNode.getName());
        return (Void)super.visitParameterNode(parameterNode);
    }

    private String modifier2String(int modifier) {
        if (this.isInterface) {
            modifier &= 0xFFFFFBFF;
        }
        return Modifier.toString(modifier);
    }

    @Override
    public Void visitClassNode(ClassNode node) {
        String pkgName;
        boolean isInnerClass;
        this.isInterface = Modifier.isInterface(node.modifier);
        String clsName = node.name;
        boolean bl = isInnerClass = node.enclosingClass != null;
        if (!isInnerClass && (pkgName = NameUtil.getPackageName(clsName)) != null) {
            this.sb.append("package ").append(pkgName).append(";\n");
        }
        this.sb.append(this.modifier2String(node.modifier)).append(this.isInterface ? " " : " class ").append(NameUtil.getSimpleClassName(clsName));
        GenericType[] genTypes = node.getGenericTypes();
        if (genTypes.length > 0) {
            CharSequence[] genTypeStrs = new String[genTypes.length];
            for (int i = 0; i < genTypeStrs.length; ++i) {
                genTypeStrs[i] = genTypes[i].getName();
            }
            this.sb.append("<").append(String.join((CharSequence)",", genTypeStrs)).append(">");
        }
        this.sb.append("{\n");
        super.visitClassNode(node);
        this.sb.append("\n}");
        return null;
    }

    public String getJavaStubCode() {
        return this.sb.toString();
    }

    @Override
    public void generate(ClassNode classNode) {
        this.sb = new StringBuilder();
        this.visit(classNode);
    }
}

