/*
 * Decompiled with CFR 0.152.
 */
package kalang.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.AstNotFoundException;
import kalang.ast.ClassNode;
import kalang.compiler.AstLoader;
import kalang.core.ArrayType;
import kalang.core.ClassType;
import kalang.core.NullableKind;
import kalang.core.ObjectType;
import kalang.core.PrimitiveType;
import kalang.core.Type;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class Types {
    private static Map<String, PrimitiveType> primitiveTypes = new HashMap<String, PrimitiveType>();
    private static Map<List, ArrayType> arrayTypes = new HashMap<List, ArrayType>();
    private static final Map<List, ClassType> classTypes = new HashMap<List, ClassType>();
    private static final DualHashBidiMap<PrimitiveType, String> primitive2class = new DualHashBidiMap();
    public static final PrimitiveType BOOLEAN_TYPE = Types.getPrimitiveType("boolean");
    public static final PrimitiveType BYTE_TYPE = Types.getPrimitiveType("byte");
    public static final PrimitiveType CHAR_TYPE = Types.getPrimitiveType("char");
    public static final PrimitiveType SHORT_TYPE = Types.getPrimitiveType("short");
    public static final PrimitiveType INT_TYPE = Types.getPrimitiveType("int");
    public static final PrimitiveType LONG_TYPE = Types.getPrimitiveType("long");
    public static final PrimitiveType FLOAT_TYPE = Types.getPrimitiveType("float");
    public static final PrimitiveType DOUBLE_TYPE = Types.getPrimitiveType("double");
    public static final PrimitiveType NULL_TYPE = Types.getPrimitiveType("null");
    public static final PrimitiveType VOID_TYPE = Types.getPrimitiveType("void");
    public static final String FLOAT_CLASS_NAME = "java.lang.Float";
    public static final String DOUBLE_CLASS_NAME = "java.lang.Double";
    public static final String INT_CLASS_NAME = "java.lang.Integer";
    public static final String LONG_CLASS_NAME = "java.lang.Long";
    public static final String BOOLEAN_CLASS_NAME = "java.lang.Boolean";
    public static final String CHAR_CLASS_NAME = "java.lang.Character";
    public static final String STRING_CLASS_NAME = "java.lang.String";
    public static final String VOID_CLASS_NAME = "java.lang.Void";
    public static final String SHORT_CLASS_NAME = "java.lang.Short";
    public static final String BYTE_CLASS_NAME = "java.lang.Byte";
    public static final String ROOT_CLASS_NAME = "java.lang.Object";
    public static final String MAP_IMPL_CLASS_NAME = "java.util.HashMap";
    public static final String LIST_IMPL_CLASS_NAME = "java.util.LinkedList";
    public static final String EXCEPTION_CLASS_NAME = "java.lang.Exception";
    public static final String CLASS_CLASS_NAME = "java.lang.Class";
    public static final String ITERABLE_CLASS_NAME = "java.lang.Iterable";
    private static String[] numberClass;
    private static PrimitiveType[] numberPrimitive;

    @Nonnull
    public static PrimitiveType getPrimitiveType(String name) {
        PrimitiveType t = primitiveTypes.get(name);
        if (t == null) {
            t = new PrimitiveType(name);
            primitiveTypes.put(name, t);
        }
        return t;
    }

    public static ArrayType getArrayType(ArrayType type, NullableKind nullable) {
        return Types.getArrayType(type.getComponentType(), nullable);
    }

    @Nonnull
    public static ArrayType getArrayType(@Nonnull Type componentType) {
        return Types.getArrayType(componentType, NullableKind.NONNULL);
    }

    @Nonnull
    public static ArrayType getArrayType(@Nonnull Type componentType, NullableKind nullable) {
        List<Object> key = Arrays.asList(new Object[]{componentType, nullable});
        ArrayType at = arrayTypes.get(key);
        if (at == null) {
            at = new ArrayType(componentType, nullable);
            arrayTypes.put(key, at);
        }
        return at;
    }

    public static ClassType getClassType(ClassNode clazz, Type[] typeArguments) {
        return Types.getClassType(clazz, typeArguments, NullableKind.NONNULL);
    }

    public static ClassType getClassType(ClassNode clazz, Type[] typeArguments, NullableKind nullable) {
        ArrayList<Object> key = new ArrayList<Object>(typeArguments.length + 2);
        key.add(clazz);
        key.addAll(Arrays.asList(typeArguments));
        key.add((Object)nullable);
        ClassType pt = classTypes.get(key);
        if (pt == null) {
            pt = new ClassType(clazz, typeArguments, nullable);
            classTypes.put(key, pt);
        }
        return pt;
    }

    @Nonnull
    public static ClassType getClassType(@Nonnull ClassNode clazz) {
        return Types.getClassType(clazz, clazz.getGenericTypes(), NullableKind.NONNULL);
    }

    @Nonnull
    public static ClassType getClassType(@Nonnull ClassNode clazz, NullableKind nullable) {
        return Types.getClassType(clazz, new Type[0], nullable);
    }

    @Nullable
    public static PrimitiveType getPrimitiveType(ObjectType classType) {
        return (PrimitiveType)primitive2class.getKey((Object)classType.getName());
    }

    public static ObjectType requireClassType(String className) {
        try {
            return Types.getClassType(className);
        }
        catch (AstNotFoundException ex) {
            Logger.getLogger(Types.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("failed to load class type:" + className);
        }
    }

    @Nonnull
    public static ClassType getClassType(String className) throws AstNotFoundException {
        return Types.getClassType(className, NullableKind.NONNULL);
    }

    @Nonnull
    public static ClassType getClassType(String className, NullableKind nullable) throws AstNotFoundException {
        ClassNode ast = AstLoader.BASE_AST_LOADER.loadAst(className);
        return Types.getClassType(ast, nullable);
    }

    @Nullable
    public static ObjectType getClassType(PrimitiveType primitiveType) {
        return Types.requireClassType((String)primitive2class.get((Object)primitiveType));
    }

    public static boolean isNumberPrimitive(Type type) {
        if (type instanceof PrimitiveType) {
            return Arrays.asList(numberPrimitive).contains((PrimitiveType)type);
        }
        return false;
    }

    public static boolean isNumberClass(Type type) {
        if (type instanceof ObjectType) {
            return Arrays.asList(numberClass).contains(((ObjectType)type).getName());
        }
        return false;
    }

    public static boolean isNumber(Type type) {
        return Types.isNumberPrimitive(type) || Types.isNumberClass(type);
    }

    public static boolean isBoolean(Type type) {
        return type.equals(Types.getBooleanClassType()) || type.equals(BOOLEAN_TYPE);
    }

    @Nonnull
    public static Type getHigherType(Type type1, Type type2) {
        if (type1.equals(Types.getDoubleClassType()) || type1.equals(DOUBLE_TYPE) || type2.equals(Types.getDoubleClassType()) || type2.equals(DOUBLE_TYPE)) {
            return DOUBLE_TYPE;
        }
        if (type1.equals(Types.getFloatClassType()) || type1.equals(FLOAT_TYPE) || type2.equals(Types.getFloatClassType()) || type2.equals(FLOAT_TYPE)) {
            return FLOAT_TYPE;
        }
        if (type1.equals(Types.getLongClassType()) || type1.equals(LONG_TYPE) || type2.equals(Types.getLongClassType()) || type2.equals(LONG_TYPE)) {
            return LONG_TYPE;
        }
        return INT_TYPE;
    }

    public static ObjectType getVoidClassType() {
        return Types.requireClassType(VOID_CLASS_NAME);
    }

    public static ObjectType getBooleanClassType() {
        return Types.requireClassType(BOOLEAN_CLASS_NAME);
    }

    public static ObjectType getByteClassType() {
        return Types.requireClassType(BYTE_CLASS_NAME);
    }

    public static ObjectType getCharClassType() {
        return Types.requireClassType(CHAR_CLASS_NAME);
    }

    public static ObjectType getIntClassType() {
        return Types.requireClassType(INT_CLASS_NAME);
    }

    public static ObjectType getLongClassType() {
        return Types.requireClassType(LONG_CLASS_NAME);
    }

    public static ObjectType getFloatClassType() {
        return Types.requireClassType(FLOAT_CLASS_NAME);
    }

    public static ObjectType getDoubleClassType() {
        return Types.requireClassType(DOUBLE_CLASS_NAME);
    }

    public static ObjectType getMapImplClassType() {
        return Types.requireClassType(MAP_IMPL_CLASS_NAME);
    }

    public static ObjectType getListImplClassType() {
        return Types.requireClassType(LIST_IMPL_CLASS_NAME);
    }

    public static ObjectType getExceptionClassType() {
        return Types.requireClassType(EXCEPTION_CLASS_NAME);
    }

    public static ObjectType getShortClassType() {
        return Types.requireClassType(SHORT_CLASS_NAME);
    }

    public static ObjectType getClassClassType() {
        return Types.requireClassType(CLASS_CLASS_NAME);
    }

    public static ObjectType getRootType() {
        return Types.requireClassType(ROOT_CLASS_NAME);
    }

    public static ObjectType getStringClassType() {
        return Types.requireClassType(STRING_CLASS_NAME);
    }

    public static ClassType getClassType(ClassType clazzType, NullableKind nullable) {
        return Types.getClassType(clazzType.getClassNode(), clazzType.getTypeArguments(), nullable);
    }

    public static ObjectType getIterableClassType() {
        return Types.requireClassType(ITERABLE_CLASS_NAME);
    }

    static {
        primitive2class.put((Object)INT_TYPE, (Object)INT_CLASS_NAME);
        primitive2class.put((Object)LONG_TYPE, (Object)LONG_CLASS_NAME);
        primitive2class.put((Object)FLOAT_TYPE, (Object)FLOAT_CLASS_NAME);
        primitive2class.put((Object)DOUBLE_TYPE, (Object)DOUBLE_CLASS_NAME);
        primitive2class.put((Object)CHAR_TYPE, (Object)CHAR_CLASS_NAME);
        primitive2class.put((Object)BOOLEAN_TYPE, (Object)BOOLEAN_CLASS_NAME);
        primitive2class.put((Object)VOID_TYPE, (Object)VOID_CLASS_NAME);
        primitive2class.put((Object)SHORT_TYPE, (Object)SHORT_CLASS_NAME);
        primitive2class.put((Object)BYTE_TYPE, (Object)BYTE_CLASS_NAME);
        numberClass = new String[]{BYTE_CLASS_NAME, SHORT_CLASS_NAME, INT_CLASS_NAME, LONG_CLASS_NAME, FLOAT_CLASS_NAME, DOUBLE_CLASS_NAME};
        numberPrimitive = new PrimitiveType[]{BYTE_TYPE, SHORT_TYPE, INT_TYPE, LONG_TYPE, FLOAT_TYPE, DOUBLE_TYPE};
    }
}

