/*
 * Decompiled with CFR 0.152.
 */
package kalang.java;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import kalang.java.MemoryJavaSource;
import kalang.java.StringJavaSource;
import org.apache.commons.io.FileUtils;

public class FileSystemFileManager
implements JavaFileManager {
    protected JavaFileManager fm;
    protected final List<File> sourcePaths = new LinkedList<File>();

    public FileSystemFileManager(JavaFileManager fm) {
        this.fm = fm;
    }

    public void addSourcePath(File path) {
        this.sourcePaths.add(path);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.fm.hasLocation(location) || location == StandardLocation.SOURCE_PATH && this.sourcePaths.size() > 0;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> superList = this.fm.list(location, packageName, kinds, recurse);
        if (location == StandardLocation.SOURCE_PATH) {
            LinkedList<JavaFileObject> list = new LinkedList<JavaFileObject>();
            for (File p : this.sourcePaths) {
                Collection files;
                File dir = packageName != null && !packageName.isEmpty() ? new File(p, packageName.replace('.', '/')) : p;
                if (!dir.exists() || !dir.isDirectory() || (files = FileUtils.listFiles((File)dir, (String[])new String[]{"java"}, (boolean)recurse)) == null) continue;
                for (File f : files) {
                    list.add(StringJavaSource.loadFromFile(p, f));
                }
            }
            if (superList != null) {
                superList.forEach(i -> list.add((JavaFileObject)i));
            }
            return list;
        }
        return superList;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof MemoryJavaSource) {
            return ((MemoryJavaSource)file).getClassName();
        }
        return this.fm.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.fm.isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fm.handleOption(current, remaining);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.fm.getClassLoader(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.fm.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return this.fm.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fm.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fm.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
        this.fm.flush();
    }

    @Override
    public void close() throws IOException {
        this.fm.close();
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fm.isSupportedOption(option);
    }
}

