/*
 * Decompiled with CFR 0.152.
 */
package kalang.tool;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import kalang.AstNotFoundException;
import kalang.ast.ClassNode;
import kalang.compiler.JavaAstLoader;
import kalang.compiler.KalangSource;
import kalang.java.MemoryCompiler;
import kalang.java.MemoryFileManager;
import kalang.java.StringJavaSource;
import kalang.java.StringJavaSourceBase;
import kalang.tool.FileSystemCompiler;
import kalang.tool.MemoryOutputManager;
import kalang.tool.OutputManager;
import kalang.util.ClassNameUtil;
import kalang.util.FilePathUtil;
import org.apache.commons.io.FileUtils;

public class JointFileSystemCompiler
extends FileSystemCompiler {
    final Map<String, JavaFileObject> javaFiles = new HashMap<String, JavaFileObject>();
    final List<File> javaSourcePath = new LinkedList<File>();
    final MemoryOutputManager javaStubManager = new MemoryOutputManager();
    private MemoryCompiler javaCompiler;
    private OutputManager javaOutputManager;

    public void addJavaSourcePath(File path) {
        this.javaSourcePath.add(path);
    }

    public void addJavaSourceDir(File sourceDir) throws IOException {
        Collection files = FileUtils.listFiles((File)sourceDir, (String[])new String[]{"java"}, (boolean)true);
        if (files != null) {
            for (File f : files) {
                this.addJavaSource(sourceDir, f);
            }
        }
    }

    public void addKalangOrJavaSource(File dir, File file) throws IOException {
        if (file.getName().endsWith(".java")) {
            this.addJavaSource(dir, file);
        } else {
            this.addSource(dir, file);
        }
    }

    public void addKalangAndJavaSourceDir(File srcDir) throws IOException {
        this.addSourceDir(srcDir);
        this.addJavaSourceDir(srcDir);
    }

    public void addJavaSource(File srcDir, File file) throws IOException {
        String className = ClassNameUtil.getClassName(srcDir, file);
        this.javaFiles.put(className, StringJavaSource.loadFromFile(srcDir, file));
    }

    private ClassNode createMockClass(String className) {
        ClassNode node = new ClassNode(className, 1);
        return node;
    }

    @Override
    public ClassNode loadAst(String className) throws AstNotFoundException {
        try {
            return super.loadAst(className);
        }
        catch (AstNotFoundException ex) {
            try {
                JavaFileObject js = this.loadJavaSource(className);
                if (js == null) {
                    throw ex;
                }
                if (this.getCurrentCompilePhase() < 3) {
                    return this.createMockClass(className);
                }
                if (this.javaCompiler == null) {
                    throw ex;
                }
                JavaAstLoader javaAstLoader = new JavaAstLoader(null, this.javaCompiler);
                return javaAstLoader.loadAst(className);
            }
            catch (IOException ioEx) {
                this.handleIOException(ioEx);
                throw ex;
            }
        }
    }

    @Override
    public void compile() {
        String[] stubNames;
        this.generateJavaStub(this.javaStubManager);
        final JointFileSystemCompiler that = this;
        this.javaCompiler = new MemoryCompiler(){

            @Override
            protected JavaFileObject loadJavaSource(String className) throws IOException {
                JavaFileObject js = super.loadJavaSource(className);
                if (js != null) {
                    return js;
                }
                return that.loadJavaSource(className);
            }

            @Override
            protected MemoryFileManager createFileManager(StandardJavaFileManager sfm) {
                MemoryFileManager superFm = super.createFileManager(sfm);
                return new MemoryFileManager(superFm){

                    @Override
                    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                        Iterable<JavaFileObject> superList = super.list(location, packageName, kinds, recurse);
                        LinkedList<JavaFileObject> files = new LinkedList<JavaFileObject>();
                        if (superList != null) {
                            superList.forEach(i -> files.add((JavaFileObject)i));
                        }
                        for (File p : JointFileSystemCompiler.this.sourcePaths) {
                            File dir = packageName != null && !packageName.isEmpty() ? new File(p, packageName.replace('.', '/')) : p;
                            if (!dir.exists() || !dir.isDirectory()) continue;
                            Collection klFiles = FileUtils.listFiles((File)dir, (String[])new String[]{"kl", "kalang"}, (boolean)recurse);
                            klFiles.forEach(f -> {
                                String className = ClassNameUtil.getClassName(p, f);
                                files.add(new StringJavaSourceBase(className){

                                    @Override
                                    protected CharSequence getContent() {
                                        try {
                                            return this.loadJavaSource(this.className).getCharContent(true);
                                        }
                                        catch (IOException ex) {
                                            JointFileSystemCompiler.this.handleIOException(ex);
                                            return "";
                                        }
                                    }
                                });
                            });
                        }
                        return files;
                    }
                };
            }
        };
        for (URL uRL : this.classPaths) {
            this.javaCompiler.addClassPath(uRL);
        }
        for (File file : this.javaSourcePath) {
            this.javaCompiler.addSourcePath(file);
        }
        for (Map.Entry entry : this.javaFiles.entrySet()) {
            this.javaCompiler.addSource((JavaFileObject)entry.getValue());
        }
        for (String n : stubNames = this.javaStubManager.getClassNames()) {
            String code = new String(this.javaStubManager.getBytes(n));
            this.javaCompiler.addSourceFromString(n, code);
        }
        if (!this.javaCompiler.compile()) {
            DiagnosticCollector<JavaFileObject> diagnosticCollector = this.javaCompiler.getDiagnosticCollector();
            for (Diagnostic<JavaFileObject> d : diagnosticCollector.getDiagnostics()) {
                this.handleJavaDiagnostic(d);
            }
            return;
        }
        MemoryFileManager memoryFileManager = this.javaCompiler.getFileManager();
        Map<String, byte[]> bytes = null;
        if (memoryFileManager != null) {
            bytes = memoryFileManager.getBytes();
        }
        OutputManager outManager = this.javaOutputManager;
        if (bytes != null && outManager != null) {
            for (Map.Entry<String, byte[]> e : bytes.entrySet()) {
                try {
                    OutputStream os = outManager.createOutputStream(e.getKey());
                    os.write(e.getValue());
                    os.close();
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                }
            }
        }
        this.getClassLoader().addClassLoader(this.javaCompiler);
        super.compile();
    }

    protected void handleJavaDiagnostic(Diagnostic<? extends JavaFileObject> d) {
        JavaFileObject source = d.getSource();
        if (source != null) {
            try {
                CharSequence code = source.getCharContent(true);
                System.err.print(code);
                System.err.println(source.getName() + ":" + d.getLineNumber());
            }
            catch (IOException ex) {
                Logger.getLogger(JointFileSystemCompiler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.err.println((Object)((Object)d.getKind()) + ":" + d.getMessage(null));
    }

    @Nullable
    protected JavaFileObject loadJavaSource(String className) throws IOException {
        if (this.javaFiles.containsKey(className)) {
            return this.javaFiles.get(className);
        }
        for (File p : this.javaSourcePath) {
            File f;
            if (!p.isDirectory() || !FilePathUtil.existFile(f = new File(p, ClassNameUtil.getRelativePathOfClass(className, "java")))) continue;
            StringJavaSource source = StringJavaSource.loadFromFile(p, f);
            this.javaFiles.put(className, source);
            return source;
        }
        JavaFileObject js = this.getJavaStub(className);
        if (js != null) {
            return js;
        }
        KalangSource klSource = this.getSourceLoader().loadSource(className);
        if (klSource != null) {
            this.addSource(klSource);
            this.generateJavaStub(this.javaStubManager);
            return this.getJavaStub(className);
        }
        return null;
    }

    @Nullable
    protected JavaFileObject getJavaStub(String className) {
        byte[] data = this.javaStubManager.getBytes(className);
        if (data == null) {
            return null;
        }
        String code = new String(data);
        return new StringJavaSource(className, code);
    }

    public OutputManager getJavaOutputManager() {
        return this.javaOutputManager;
    }

    public void setJavaOutputManager(OutputManager javaOutputManager) {
        this.javaOutputManager = javaOutputManager;
    }
}

