/*
 * Decompiled with CFR 0.152.
 */
package kalang.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.AmbiguousMethodException;
import kalang.MethodNotFoundException;
import kalang.ast.AssignExpr;
import kalang.ast.BlockStmt;
import kalang.ast.ClassNode;
import kalang.ast.ClassReference;
import kalang.ast.ExprNode;
import kalang.ast.ExprStmt;
import kalang.ast.FieldExpr;
import kalang.ast.FieldNode;
import kalang.ast.InvocationExpr;
import kalang.ast.MethodNode;
import kalang.ast.ObjectFieldExpr;
import kalang.ast.ObjectInvokeExpr;
import kalang.ast.ParameterExpr;
import kalang.ast.ParameterNode;
import kalang.ast.ReturnStmt;
import kalang.ast.Statement;
import kalang.ast.StaticFieldExpr;
import kalang.ast.SuperExpr;
import kalang.ast.ThisExpr;
import kalang.core.ClassType;
import kalang.core.ConstructorDescriptor;
import kalang.core.ExecutableDescriptor;
import kalang.core.FieldDescriptor;
import kalang.core.MethodDescriptor;
import kalang.core.ObjectType;
import kalang.core.ParameterDescriptor;
import kalang.core.Type;
import kalang.core.Types;
import kalang.util.BoxUtil;
import kalang.util.MethodUtil;
import kalang.util.ModifierUtil;
import kalang.util.NameUtil;
import kalang.util.OverrideUtil;

public class AstUtil {
    @Nonnull
    public static List<MethodDescriptor> getUnimplementedMethod(ClassNode theClass) {
        LinkedList<MethodDescriptor> list = new LinkedList<MethodDescriptor>();
        for (ObjectType i : theClass.getInterfaces()) {
            list.addAll(AstUtil.getUnimplementedMethod(theClass, i));
        }
        return list;
    }

    @Nonnull
    public static List<MethodDescriptor> getUnimplementedMethod(ClassNode theClass, ObjectType theInterface) {
        ClassType theType = Types.getClassType(theClass);
        MethodDescriptor[] implementedMethods = theType.getMethodDescriptors(theClass, true, false);
        LinkedList<MethodDescriptor> list = new LinkedList<MethodDescriptor>();
        for (MethodDescriptor m : theInterface.getMethodDescriptors(theClass, false, true)) {
            Type[] types;
            String name;
            MethodDescriptor overridingMd;
            if (ModifierUtil.isDefault(m.getModifier()) || (overridingMd = MethodUtil.getMethodDescriptor(implementedMethods, name = m.getName(), types = m.getParameterTypes())) != null && OverrideUtil.overridingCompatible(overridingMd.getModifier(), m.getModifier()) && OverrideUtil.returnTypeCompatible(overridingMd.getReturnType(), m.getReturnType()) && OverrideUtil.exceptionTypeCompatible(overridingMd.getExceptionTypes(), m.getExceptionTypes())) continue;
            list.add(m);
        }
        return list;
    }

    public static boolean createEmptyConstructor(ClassNode clazzNode) {
        ObjectType supType = clazzNode.superType;
        if (supType == null) {
            throw new RuntimeException("super type is null:" + clazzNode.name);
        }
        ConstructorDescriptor[] constructors = supType.getConstructorDescriptors(clazzNode);
        ConstructorDescriptor m = MethodUtil.getConstructorDescriptor(constructors, null);
        if (m != null) {
            ParameterDescriptor[] pds;
            MethodNode mm = clazzNode.createMethodNode(Types.VOID_TYPE, m.getName(), m.getModifier());
            for (Type e : m.getExceptionTypes()) {
                mm.addExceptionType(e);
            }
            for (ParameterDescriptor pd : pds = m.getParameterDescriptors()) {
                ParameterNode p = mm.createParameter(pd.getType(), pd.getName());
                p.modifier = pd.getModifier();
            }
            BlockStmt body = mm.getBody();
            ParameterNode[] parameters = mm.getParameters();
            ExprNode[] params = new ExprNode[parameters.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = new ParameterExpr(parameters[i]);
            }
            body.statements.add(new ExprStmt(new ObjectInvokeExpr(new SuperExpr(clazzNode), (ExecutableDescriptor)m, params)));
            return true;
        }
        return false;
    }

    public static boolean containsConstructor(ClassNode clazz) {
        MethodNode[] dms;
        for (MethodNode m : dms = clazz.getDeclaredMethodNodes()) {
            if (!"<init>".equals(m.getName())) continue;
            return true;
        }
        return false;
    }

    public static ExecutableDescriptor[] filterMethodByName(ExecutableDescriptor[] mds, String methodName) {
        ArrayList<ExecutableDescriptor> methods = new ArrayList<ExecutableDescriptor>(mds.length);
        for (ExecutableDescriptor m : mds) {
            if (!m.getName().equals(methodName)) continue;
            methods.add(m);
        }
        return methods.toArray(new ExecutableDescriptor[methods.size()]);
    }

    public static ExprNode matchType(Type from, Type target, ExprNode expr) {
        if (from.equals(target)) {
            return expr;
        }
        return BoxUtil.assign(expr, from, target);
    }

    @Nullable
    public static ExprNode[] matchTypes(ExprNode[] args, Type[] from, Type[] target) {
        if (args == null) {
            return null;
        }
        if (from == null || from.length == 0) {
            if (target == null || target.length == 0) {
                return args;
            }
            return null;
        }
        if (from.length != target.length || from.length != args.length) {
            return null;
        }
        if (from.length == 0) {
            return new ExprNode[0];
        }
        ExprNode[] newParams = new ExprNode[from.length];
        for (int i = 0; i < from.length; ++i) {
            Type f = from[i];
            Type t = target[i];
            newParams[i] = AstUtil.matchType(f, t, args[i]);
            if (newParams[i] != null) continue;
            return null;
        }
        return newParams;
    }

    @Nullable
    public static ExecutableDescriptor getExactedMethod(ObjectType targetType, ExecutableDescriptor[] candidates, String methodName, @Nullable Type[] types) {
        ExecutableDescriptor[] methods;
        for (ExecutableDescriptor m : methods = AstUtil.filterMethodByName(candidates, methodName)) {
            Object[] mdTypes = m.getParameterTypes();
            if (Arrays.equals(mdTypes, types)) {
                return m;
            }
            if (mdTypes != null && mdTypes.length != 0 || types != null && types.length != 0) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public static Type[] getExprTypes(ExprNode[] exprs) {
        if (exprs == null) {
            return null;
        }
        Type[] types = new Type[exprs.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = exprs[i].getType();
        }
        return types;
    }

    public static boolean isStatic(int modifier) {
        return Modifier.isStatic(modifier);
    }

    public static boolean isConstructorCallStatement(Statement stmt) {
        try {
            ExprStmt exprStmt = (ExprStmt)stmt;
            InvocationExpr invExpr = (InvocationExpr)exprStmt.getExpr();
            ExecutableDescriptor method = invExpr.getMethod();
            return method.getName().equals("<init>") && !Modifier.isStatic(method.getModifier());
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public static boolean isConstructor(MethodNode m) {
        return !AstUtil.isStatic(m.getModifier()) && m.getName().equals("<init>");
    }

    public static boolean hasConstructorCallStatement(List<Statement> statements) {
        for (Statement s : statements) {
            if (!AstUtil.isConstructorCallStatement(s)) continue;
            return true;
        }
        return false;
    }

    public static Statement createDefaultSuperConstructorCall(ClassNode clazz) throws MethodNotFoundException, AmbiguousMethodException {
        SuperExpr thisExpr = new SuperExpr(clazz);
        return new ExprStmt(ObjectInvokeExpr.create(thisExpr, "<init>", null, clazz));
    }

    public static boolean hasSetter(ClassNode clazz, FieldNode field) {
        ClassType type = Types.getClassType(clazz);
        MethodDescriptor md = MethodUtil.getMethodDescriptor(type.getMethodDescriptors(clazz, true, true), "set" + NameUtil.firstCharToUpperCase(field.getName()), new Type[]{field.getType()});
        return md != null;
    }

    public static boolean hasGetter(ClassNode clazz, FieldNode field) {
        ClassType type = Types.getClassType(clazz);
        MethodDescriptor md = MethodUtil.getMethodDescriptor(type.getMethodDescriptors(clazz, true, true), "get" + NameUtil.firstCharToUpperCase(field.getName()), null);
        return md != null;
    }

    public static void createGetter(ClassNode clazz, FieldDescriptor field, int accessModifier) {
        String fn = field.getName();
        String getterName = "get" + NameUtil.firstCharToUpperCase(fn);
        boolean isStatic = AstUtil.isStatic(field.getModifier());
        if (isStatic) {
            accessModifier |= 8;
        }
        MethodNode getter = clazz.createMethodNode(field.getType(), getterName, accessModifier);
        BlockStmt body = getter.getBody();
        ClassReference cr = new ClassReference(clazz);
        FieldExpr fe = isStatic ? new StaticFieldExpr(cr, field) : new ObjectFieldExpr(new ThisExpr(Types.getClassType(clazz)), field);
        body.statements.add(new ReturnStmt(fe));
    }

    public static void createSetter(ClassNode clazz, FieldDescriptor field, int accessModifier) {
        String fn = field.getName();
        String setterName = "set" + NameUtil.firstCharToUpperCase(fn);
        boolean isStatic = AstUtil.isStatic(field.getModifier());
        if (isStatic) {
            accessModifier |= 8;
        }
        MethodNode setter = clazz.createMethodNode(Types.VOID_TYPE, setterName, accessModifier);
        ParameterNode param = setter.createParameter(field.getType(), field.getName());
        BlockStmt body = setter.getBody();
        ParameterExpr paramVal = new ParameterExpr(param);
        ClassReference cr = new ClassReference(clazz);
        FieldExpr fe = isStatic ? new StaticFieldExpr(cr, field) : new ObjectFieldExpr(new ThisExpr(Types.getClassType(clazz)), field);
        body.statements.add(new ExprStmt(new AssignExpr(fe, paramVal)));
    }

    public static ClassNode createClassNodeWithInterfaces(String name, @Nullable ObjectType superType, ObjectType ... interfaces) {
        ClassNode cn = new ClassNode();
        cn.name = name;
        ObjectType objectType = cn.superType = superType == null ? Types.getRootType() : superType;
        if (interfaces != null) {
            for (ObjectType itf : interfaces) {
                cn.addInterface(itf);
            }
        }
        return cn;
    }

    public static ClassNode createArrayAst(String component) {
        ClassNode clazz = new ClassNode();
        clazz.name = component + "[]";
        clazz.superType = Types.getRootType();
        return clazz;
    }

    public static ClassNode[] listInnerClasses(ClassNode classNode, boolean recursive) {
        LinkedList<ClassNode> classes = new LinkedList<ClassNode>();
        for (ClassNode ic : classNode.classes) {
            classes.add(ic);
            if (!recursive) continue;
            classes.addAll(Arrays.asList(AstUtil.listInnerClasses(ic, true)));
        }
        return classes.toArray(new ClassNode[classes.size()]);
    }

    public static String[] listInnerClassesNames(ClassNode clazz, boolean recursive) {
        ClassNode[] classes = AstUtil.listInnerClasses(clazz, recursive);
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].name;
        }
        return names;
    }
}

