/*
 * Decompiled with CFR 0.152.
 */
package kalang.runtime.dynamic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import kalang.runtime.dynamic.JavaMethodSelector;
import kalang.runtime.dynamic.MethodAmbiguousException;

public class MethodDispatcher {
    private static final JavaMethodSelector methodSelector = new JavaMethodSelector();

    public static Class[] getObjectTypes(Object ... objects) {
        Class[] types = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            types[i] = objects[i].getClass();
        }
        return types;
    }

    public static Object invokeMethodExactly(Object obj, String method, Object[] args, String[] types) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Class[] typeClasses = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            typeClasses[i] = Class.forName(types[i]);
        }
        Method md = clazz.getMethod(method, typeClasses);
        return md.invoke(obj, args);
    }

    public static Object invokeMethod(Object object, String method, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, MethodAmbiguousException {
        List<Method> mds = methodSelector.select(object.getClass().getMethods(), method, MethodDispatcher.getObjectTypes(args));
        if (mds.isEmpty()) {
            throw new NoSuchMethodException(method);
        }
        if (mds.size() == 1) {
            return mds.get(0).invoke(object, args);
        }
        throw new MethodAmbiguousException(mds.toArray(new Method[mds.size()]));
    }
}

