/*
 * Decompiled with CFR 0.152.
 */
package kalang.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class MethodSelector<M, T> {
    public boolean matchType(T objClass, T declaredClass) {
        return this.isAssignableFrom(declaredClass, objClass);
    }

    public boolean matchType(T[] objClasses, T[] declaredClasses) {
        int objLen = objClasses.length;
        int declaredLen = declaredClasses.length;
        if (objLen != declaredLen) {
            return false;
        }
        for (int i = 0; i < objLen; ++i) {
            if (this.matchType(objClasses[i], declaredClasses[i])) continue;
            return false;
        }
        return true;
    }

    private boolean equalsTypes(T[] types1, T[] types2) {
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            if (this.equalsType(types1[i], types2[i])) continue;
            return false;
        }
        return true;
    }

    public List<M> select(M[] mds, String name, T ... argTypes) {
        ArrayList<M> matched = new ArrayList<M>(mds.length);
        for (M m : mds) {
            if (!name.equals(this.getMethodName(m))) continue;
            T[] types = this.getMethodParameterTypes(m);
            if (this.equalsTypes(argTypes, types)) {
                return Collections.singletonList(m);
            }
            if (!this.matchType(argTypes, types)) continue;
            matched.add(m);
        }
        if (matched.size() <= 1) {
            return matched;
        }
        return this.selectMostPrecise(matched, argTypes);
    }

    private boolean isMorePreciseTypes(T[] actualTypes, T[] typesToCompare1, T[] typesToCompare2) {
        if (typesToCompare1.length != typesToCompare2.length) {
            return false;
        }
        boolean isMorePrecise = false;
        for (int i = 0; i < typesToCompare1.length; ++i) {
            T at = actualTypes[i];
            T t1 = typesToCompare1[i];
            T t2 = typesToCompare2[i];
            if (this.equalsType(t1, t2)) continue;
            if (this.isMorePreciseType(at, t2, t1)) {
                return false;
            }
            if (!this.isMorePreciseType(at, t1, t2)) continue;
            isMorePrecise = true;
        }
        return isMorePrecise;
    }

    private List<M> selectMostPrecise(List<M> mds, T[] actualTypes) {
        int size = mds.size();
        if (size == 0) {
            return new ArrayList();
        }
        M ret = mds.get(0);
        for (int i = 1; i < size; ++i) {
            T[] retTypes;
            M m = mds.get(i);
            T[] mpts = this.getMethodParameterTypes(m);
            if (this.isMorePreciseTypes(actualTypes, mpts, retTypes = this.getMethodParameterTypes(ret))) {
                ret = m;
                continue;
            }
            if (this.isMorePreciseTypes(actualTypes, retTypes, mpts)) continue;
            return Arrays.asList(ret, m);
        }
        return Collections.singletonList(ret);
    }

    protected abstract String getMethodName(M var1);

    protected abstract T[] getMethodParameterTypes(M var1);

    protected abstract boolean isMorePreciseType(T var1, T var2, T var3);

    protected abstract boolean isAssignableFrom(T var1, T var2);

    protected abstract boolean equalsType(T var1, T var2);
}

