/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.engine;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import site.kason.tempera.engine.EscapeHandler;
import site.kason.tempera.engine.TemplateLoader;
import site.kason.tempera.extension.Filter;
import site.kason.tempera.extension.Function;
import site.kason.tempera.filters.LowerFilter;
import site.kason.tempera.filters.UpperFilter;
import site.kason.tempera.functions.FormatFunction;
import site.kason.tempera.functions.LeftFunction;
import site.kason.tempera.functions.RightFunction;
import site.kason.tempera.html.HtmlEscapeHandler;
import site.kason.tempera.html.JsFilter;
import site.kason.tempera.html.JsonFilter;
import site.kason.tempera.loader.ClasspathTemplateLoader;
import site.kason.tempera.loader.FileTemplateLoader;
import site.kason.tempera.parser.ClassNameStrategy;
import site.kason.tempera.parser.DefaultClassNameStrategy;

public class Configuration {
    private static final ClassNameStrategy DEFAULT_CLASS_NAME_STRATEGY = new DefaultClassNameStrategy();
    public static final Configuration DEFAULT = new Configuration();
    public static final Configuration DEFAULT_HTML;
    private String cacheDir;
    private ClassLoader classLoader;
    private List<TemplateLoader> templateLoaders = new LinkedList<TemplateLoader>();
    private Map<String, Function> functions = new HashMap<String, Function>();
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private EscapeHandler escapeHandler;
    private String leftDelimiter = "{{";
    private String rightDelimiter = "}}";
    private ClassNameStrategy classNameStrategy = DEFAULT_CLASS_NAME_STRATEGY;

    public Configuration() {
    }

    public Configuration(Configuration config) {
        this.cacheDir = config.getCacheDir();
        this.classLoader = config.getClassLoader();
        for (TemplateLoader t : config.getTemplateLoaders()) {
            this.registerTemplateLoader(t);
        }
        this.filters.putAll(config.getFilters());
        this.functions.putAll(config.getFunctions());
        this.escapeHandler = config.getEscapeHandler();
        this.classNameStrategy = config.getClassNameStrategy();
    }

    @Nullable
    public String getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Nullable
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public TemplateLoader[] getTemplateLoaders() {
        return this.templateLoaders.toArray(new TemplateLoader[0]);
    }

    public void registerTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoaders.add(templateLoader);
    }

    public void registerClasspathTemplateLoader(@Nullable String[] suffix) {
        this.registerTemplateLoader(new ClasspathTemplateLoader(suffix));
    }

    public void registerFileTemplateLoader(File baseDir, String[] suffix, String encoding) {
        this.registerTemplateLoader(new FileTemplateLoader(baseDir, suffix, encoding));
    }

    public void registerFileTemplateLoader(File baseDir) {
        this.registerFileTemplateLoader(baseDir, new String[0], "utf-8");
    }

    public void registerFilter(String name, Filter filter) {
        this.filters.put(name, filter);
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void registerFunction(String name, Function function) {
        this.functions.put(name, function);
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    @Nullable
    public EscapeHandler getEscapeHandler() {
        return this.escapeHandler;
    }

    public void setEscapeHandler(EscapeHandler escapeHandler) {
        this.escapeHandler = escapeHandler;
    }

    public String getLeftDelimiter() {
        return this.leftDelimiter;
    }

    public void setLeftDelimiter(String leftDelimiter) {
        this.leftDelimiter = leftDelimiter;
    }

    public String getRightDelimiter() {
        return this.rightDelimiter;
    }

    public void setRightDelimiter(String rightDelimiter) {
        this.rightDelimiter = rightDelimiter;
    }

    public ClassNameStrategy getClassNameStrategy() {
        return this.classNameStrategy;
    }

    public void setClassNameStrategy(ClassNameStrategy classNameStrategy) {
        this.classNameStrategy = classNameStrategy;
    }

    static {
        DEFAULT.registerFilter("lower", new LowerFilter());
        DEFAULT.registerFilter("upper", new UpperFilter());
        DEFAULT.registerFunction("format", new FormatFunction());
        DEFAULT.registerFunction("left", new LeftFunction());
        DEFAULT.registerFunction("right", new RightFunction());
        DEFAULT_HTML = new Configuration(DEFAULT);
        DEFAULT_HTML.registerFilter("js", new JsFilter());
        DEFAULT_HTML.registerFilter("json", new JsonFilter());
        DEFAULT_HTML.setEscapeHandler(new HtmlEscapeHandler());
    }
}

