/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.engine;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kalang.compiler.AstNotFoundException;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.JavaAstLoader;
import kalang.compiler.exception.Exceptions;
import site.kason.tempera.engine.Configuration;
import site.kason.tempera.engine.DefaultTemplate;
import site.kason.tempera.engine.Template;
import site.kason.tempera.engine.TemplateAstLoader;
import site.kason.tempera.engine.TemplateLoader;
import site.kason.tempera.engine.TemplateNotFoundException;
import site.kason.tempera.engine.TemplateSource;
import site.kason.tempera.extension.Filter;
import site.kason.tempera.extension.Function;
import site.kason.tempera.model.RenderContext;
import site.kason.tempera.parser.ClassNameStrategy;
import site.kason.tempera.parser.Renderer;
import site.kason.tempera.parser.TemplateClassLoader;
import site.kason.tempera.parser.TemplateParser;
import site.kason.tempera.source.StringTemplateSource;

public class Engine
implements TemplateAstLoader {
    private final TemplateLoader[] templateLoaders;
    private final Map<String, CompileCache> compiledCacheMap = new HashMap<String, CompileCache>();
    private final Map<String, CompileCache> compilingCacheMap = new HashMap<String, CompileCache>();
    private final TemplateClassLoader templateClassLoader;
    private final AstLoader astLoader;
    private final RenderContext renderContext = new RenderContext();
    private final ClassNameStrategy templateClassNameStrategy;
    private final String leftDelimiter;
    private final String rightDelimiter;

    public Engine() {
        this(Configuration.DEFAULT);
    }

    public Engine(Configuration conf) {
        this.templateLoaders = conf.getTemplateLoaders();
        ClassLoader classLoader = conf.getClassLoader();
        if (classLoader == null) {
            classLoader = Engine.class.getClassLoader();
        }
        this.astLoader = new JavaAstLoader(AstLoader.BASE_AST_LOADER, classLoader);
        String cachePath = conf.getCacheDir();
        File cacheDir = cachePath == null ? null : new File(cachePath);
        this.templateClassLoader = new TemplateClassLoader(classLoader, cacheDir);
        Map<String, Filter> filters = conf.getFilters();
        for (Map.Entry<String, Filter> entry : filters.entrySet()) {
            this.renderContext.addFilter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : conf.getFunctions().entrySet()) {
            this.renderContext.addFunction(entry.getKey(), (Function)entry.getValue());
        }
        this.renderContext.setEscapeHandler(conf.getEscapeHandler());
        this.leftDelimiter = conf.getLeftDelimiter();
        this.rightDelimiter = conf.getRightDelimiter();
        this.templateClassNameStrategy = conf.getClassNameStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template compile(TemplateSource source) throws IOException {
        long lastModified;
        String tplName = source.getName();
        CompileCache compileCache = this.getCompiledCache(tplName, lastModified = source.lastModified());
        if (compileCache != null) {
            return compileCache.template;
        }
        Map<String, CompileCache> map = this.compilingCacheMap;
        synchronized (map) {
            compileCache = this.getCompiledCache(tplName, lastModified);
            if (compileCache == null) {
                String tplContent = source.getContent();
                String tplClassName = this.templateClassNameStrategy.generateClassName(source);
                TemplateParser parser = new TemplateParser(tplClassName, tplName, tplContent, this.leftDelimiter, this.rightDelimiter, this, this.templateClassLoader);
                ClassNode ast = parser.getClassNode();
                compileCache = new CompileCache();
                compileCache.classNode = ast;
                compileCache.sourceLastModified = lastModified;
                this.compilingCacheMap.put(tplName, compileCache);
                Class<Renderer> clazz = parser.parse();
                DefaultTemplate tpl = new DefaultTemplate(clazz, this.renderContext);
                compileCache.template = tpl;
                this.compilingCacheMap.remove(tplName);
                this.compiledCacheMap.put(tplName, compileCache);
            }
            return compileCache.template;
        }
    }

    public Template compile(String templateName) throws IOException {
        return this.compile(this.loadTemplate(templateName));
    }

    public Template compileInline(String templateContent, String templateName) throws IOException {
        return this.compile(new StringTemplateSource(templateName, templateContent));
    }

    @Override
    public ClassNode loadTemplateAst(String templateName) throws IOException {
        TemplateSource source = this.loadTemplate(templateName);
        long lastModified = source.lastModified();
        CompileCache compileCache = this.getCompiledCache(templateName, lastModified);
        if (compileCache == null) {
            compileCache = this.compilingCacheMap.get(templateName);
        }
        if (compileCache == null) {
            this.compile(templateName);
            compileCache = this.compiledCacheMap.get(templateName);
            if (compileCache == null) {
                throw Exceptions.unexceptedException((String)("BUG:template not compiled:" + templateName));
            }
        }
        return compileCache.classNode;
    }

    @Override
    public ClassNode loadAst(String className) throws AstNotFoundException {
        return this.astLoader.loadAst(className);
    }

    private CompileCache getCompiledCache(String tplName, long lastModified) {
        CompileCache compiledTemplate = this.compiledCacheMap.get(tplName);
        if (compiledTemplate != null && compiledTemplate.sourceLastModified == lastModified) {
            return compiledTemplate;
        }
        return null;
    }

    private TemplateSource loadTemplate(String templateName) throws TemplateNotFoundException {
        for (TemplateLoader tl : this.templateLoaders) {
            try {
                TemplateSource source = tl.load(templateName);
                return source;
            }
            catch (TemplateNotFoundException templateNotFoundException) {
            }
        }
        throw new TemplateNotFoundException("template not found:" + templateName);
    }

    private static class CompileCache {
        Template template;
        long sourceLastModified;
        ClassNode classNode;

        private CompileCache() {
        }
    }
}

