/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.loader;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import kamons.stream.InputStreamUtil;
import site.kason.tempera.engine.TemplateLoader;
import site.kason.tempera.engine.TemplateNotFoundException;
import site.kason.tempera.engine.TemplateSource;
import site.kason.tempera.source.StringTemplateSource;

public class ClasspathTemplateLoader
implements TemplateLoader {
    private final String[] suffixs;
    private String encoding = "utf-8";
    private String path = "/";

    public ClasspathTemplateLoader() {
        this(null);
    }

    public ClasspathTemplateLoader(@Nullable String[] suffixs) {
        if (suffixs == null || suffixs.length == 0) {
            suffixs = new String[]{""};
        }
        this.suffixs = suffixs;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public TemplateSource load(String templateName) throws TemplateNotFoundException {
        if (templateName.startsWith("/")) {
            templateName = templateName.substring(1);
        }
        for (String s : this.suffixs) {
            String fullName = this.path + templateName + s;
            InputStream is = ClasspathTemplateLoader.class.getResourceAsStream(fullName);
            if (is == null) continue;
            try {
                String content = InputStreamUtil.readAsString((InputStream)is, (String)this.encoding);
                return new StringTemplateSource(templateName, content);
            }
            catch (IOException ex) {
                throw new TemplateNotFoundException(ex);
            }
        }
        throw new TemplateNotFoundException(templateName);
    }
}

