/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.source;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import site.kason.tempera.engine.TemplateSource;

public class FileTemplateSource
implements TemplateSource {
    File file;
    String name;
    private final String encoding;
    private final String content;

    public FileTemplateSource(String name, File file, String encoding) throws IOException {
        this.file = file;
        this.encoding = encoding;
        this.name = name;
        this.content = FileUtils.readFileToString((File)file, (String)encoding);
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ex) {
            return this.file.getAbsolutePath();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }
}

