/*
 * Decompiled with CFR 0.152.
 */
package kalang.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kalang.annotation.Nullable;
import kalang.annotation.PluginMethod;

public class FilePlugin {
    public static String DEFAULT_ENCODING = "utf-8";

    @PluginMethod
    public static String readToString(File file, @Nullable String charset) throws IOException {
        try (FileInputStream isr = new FileInputStream(file);){
            long fileLen = file.length();
            if (fileLen > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("file is too large");
            }
            int len = (int)fileLen;
            byte[] data = new byte[len];
            ((InputStream)isr).read(data);
            String string = new String(data, charset);
            return string;
        }
    }

    @PluginMethod
    public static String readToString(File file) throws IOException {
        return FilePlugin.readToString(file, DEFAULT_ENCODING);
    }

    @PluginMethod
    public static void write(File file, String data, @Nullable String charset, boolean append) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file, append);){
            fos.write(data.getBytes(charset));
        }
    }

    @PluginMethod
    public static void write(File file, String data, @Nullable String charset) throws IOException {
        FilePlugin.write(file, data, charset, false);
    }

    @PluginMethod
    public static void write(File file, String data) throws IOException {
        FilePlugin.write(file, data, DEFAULT_ENCODING);
    }
}

