/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import kalang.compiler.CompileException;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.compile.CodeGenerator;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.Configuration;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisHandler;
import kalang.compiler.compile.JavaAstLoader;
import kalang.compiler.compile.KalangCompiler;
import kalang.compiler.compile.KalangSource;
import kalang.compiler.compile.OffsetRange;
import kalang.compiler.compile.SourceLoader;
import kalang.compiler.compile.codegen.Ast2Class;
import kalang.compiler.tool.FileSystemSourceLoader;
import kalang.compiler.tool.MemoryOutputManager;
import org.apache.commons.io.FileUtils;

public class KalangClassLoader
extends URLClassLoader
implements CodeGenerator,
DiagnosisHandler {
    private final KalangCompiler compiler;
    private final HashMap<String, Class> loadedClasses = new HashMap();
    private final FileSystemSourceLoader sourceLoader;
    private Configuration configuration;
    private ClassLoader parentClassLoader = KalangClassLoader.class.getClassLoader();
    final MemoryOutputManager outputManager = new MemoryOutputManager();

    public KalangClassLoader() {
        this(new File[0], null, null);
    }

    public KalangClassLoader(File[] sourceDir, @Nullable Configuration config, @Nullable ClassLoader parentClassLoader) {
        super(new URL[]{}, parentClassLoader == null ? (parentClassLoader = KalangClassLoader.class.getClassLoader()) : parentClassLoader);
        this.configuration = config == null ? new Configuration() : config;
        this.parentClassLoader = parentClassLoader;
        this.sourceLoader = new FileSystemSourceLoader(sourceDir, new String[]{"kl", "kalang"});
        final KalangClassLoader cg = this;
        this.compiler = new KalangCompiler(new JavaAstLoader(null, parentClassLoader)){

            @Override
            public SourceLoader getSourceLoader() {
                return KalangClassLoader.this.sourceLoader;
            }

            @Override
            public CodeGenerator createCodeGenerator(CompilationUnit compilationUnit) {
                return cg;
            }
        };
        this.compiler.setConfiguration(this.configuration);
        this.compiler.setDiagnosisHandler(this);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = this.loadedClasses.get(name);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.tryLoadGeneratedClass(name);
        if (clazz != null) {
            return clazz;
        }
        KalangSource src = this.sourceLoader.loadSource(name);
        if (src != null) {
            this.compiler.addSource(src);
            this.compiler.compile();
            clazz = this.tryLoadGeneratedClass(name);
            if (clazz != null) {
                return clazz;
            }
        }
        if ((clazz = this.loadedClasses.get(name)) != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    @Override
    public void generate(ClassNode classNode) {
        Ast2Class ast2Class = new Ast2Class(this.outputManager);
        ast2Class.generate(classNode);
    }

    public void addClassPath(File path) {
        try {
            super.addURL(path.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(KalangClassLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.sourceLoader.addSourceDir(path);
    }

    public Class parseSource(String className, String code, String fileName) {
        this.compiler.addSource(className, code, fileName);
        this.compiler.compile();
        return this.tryLoadGeneratedClass(className);
    }

    public Class parseFile(String className, File file) throws IOException {
        String code = FileUtils.readFileToString((File)file);
        return this.parseSource(className, code, file.getName());
    }

    @Override
    public void handleDiagnosis(Diagnosis diagnosis) {
        if (diagnosis.getKind().isError()) {
            KalangSource source = diagnosis.getSource();
            OffsetRange offset = diagnosis.getOffset();
            throw new CompileException(String.format("%s @%s:%s", diagnosis.getDescription(), source.getFileName(), offset.startLine));
        }
    }

    @Nullable
    private Class tryLoadGeneratedClass(String name) {
        byte[] bs = this.outputManager.getBytes(name);
        if (bs != null) {
            Class<?> clazz = this.defineClass(name, bs, 0, bs.length);
            this.loadedClasses.put(name, clazz);
            return clazz;
        }
        return null;
    }
}

