/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kalang.compiler.ast.ArrayLengthExpr;
import kalang.compiler.ast.AssignExpr;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.BinaryExpr;
import kalang.compiler.ast.BlockStmt;
import kalang.compiler.ast.BreakStmt;
import kalang.compiler.ast.CastExpr;
import kalang.compiler.ast.CatchBlock;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ClassReference;
import kalang.compiler.ast.ConstExpr;
import kalang.compiler.ast.ContinueStmt;
import kalang.compiler.ast.ElementExpr;
import kalang.compiler.ast.ErrorousExpr;
import kalang.compiler.ast.ExprStmt;
import kalang.compiler.ast.FieldExpr;
import kalang.compiler.ast.FieldNode;
import kalang.compiler.ast.IAstVisitor;
import kalang.compiler.ast.IfStmt;
import kalang.compiler.ast.IncrementExpr;
import kalang.compiler.ast.InstanceOfExpr;
import kalang.compiler.ast.InvocationExpr;
import kalang.compiler.ast.LocalVarNode;
import kalang.compiler.ast.LoopStmt;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.MultiStmt;
import kalang.compiler.ast.MultiStmtExpr;
import kalang.compiler.ast.NewArrayExpr;
import kalang.compiler.ast.NewObjectExpr;
import kalang.compiler.ast.ParameterExpr;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.ast.PrimitiveCastExpr;
import kalang.compiler.ast.ReturnStmt;
import kalang.compiler.ast.SuperExpr;
import kalang.compiler.ast.ThisExpr;
import kalang.compiler.ast.ThrowStmt;
import kalang.compiler.ast.TryStmt;
import kalang.compiler.ast.UnaryExpr;
import kalang.compiler.ast.UnknownFieldExpr;
import kalang.compiler.ast.UnknownInvocationExpr;
import kalang.compiler.ast.VarDeclStmt;
import kalang.compiler.ast.VarExpr;

public abstract class AbstractAstVisitor<T>
implements IAstVisitor<T> {
    public T visit(AstNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof MultiStmt) {
            return this.visitMultiStmt((MultiStmt)node);
        }
        if (node instanceof InstanceOfExpr) {
            return this.visitInstanceOfExpr((InstanceOfExpr)node);
        }
        if (node instanceof ErrorousExpr) {
            return this.visitErrorousExpr((ErrorousExpr)node);
        }
        if (node instanceof SuperExpr) {
            return this.visitSuperExpr((SuperExpr)node);
        }
        if (node instanceof ClassReference) {
            return this.visitClassReference((ClassReference)node);
        }
        if (node instanceof UnknownFieldExpr) {
            return this.visitUnknownFieldExpr((UnknownFieldExpr)node);
        }
        if (node instanceof UnknownInvocationExpr) {
            return this.visitUnknownInvocationExpr((UnknownInvocationExpr)node);
        }
        if (node instanceof ArrayLengthExpr) {
            return this.visitArrayLengthExpr((ArrayLengthExpr)node);
        }
        if (node instanceof IncrementExpr) {
            return this.visitIncrementExpr((IncrementExpr)node);
        }
        if (node instanceof NewObjectExpr) {
            return this.visitNewObjectExpr((NewObjectExpr)node);
        }
        if (node instanceof ClassNode) {
            return this.visitClassNode((ClassNode)node);
        }
        if (node instanceof MethodNode) {
            return this.visitMethodNode((MethodNode)node);
        }
        if (node instanceof BlockStmt) {
            return this.visitBlockStmt((BlockStmt)node);
        }
        if (node instanceof BreakStmt) {
            return this.visitBreakStmt((BreakStmt)node);
        }
        if (node instanceof ContinueStmt) {
            return this.visitContinueStmt((ContinueStmt)node);
        }
        if (node instanceof ExprStmt) {
            return this.visitExprStmt((ExprStmt)node);
        }
        if (node instanceof IfStmt) {
            return this.visitIfStmt((IfStmt)node);
        }
        if (node instanceof LoopStmt) {
            return this.visitLoopStmt((LoopStmt)node);
        }
        if (node instanceof ReturnStmt) {
            return this.visitReturnStmt((ReturnStmt)node);
        }
        if (node instanceof VarDeclStmt) {
            return this.visitVarDeclStmt((VarDeclStmt)node);
        }
        if (node instanceof TryStmt) {
            return this.visitTryStmt((TryStmt)node);
        }
        if (node instanceof CatchBlock) {
            return this.visitCatchBlock((CatchBlock)node);
        }
        if (node instanceof ThrowStmt) {
            return this.visitThrowStmt((ThrowStmt)node);
        }
        if (node instanceof AssignExpr) {
            return this.visitAssignExpr((AssignExpr)node);
        }
        if (node instanceof BinaryExpr) {
            return this.visitBinaryExpr((BinaryExpr)node);
        }
        if (node instanceof ConstExpr) {
            return this.visitConstExpr((ConstExpr)node);
        }
        if (node instanceof ElementExpr) {
            return this.visitElementExpr((ElementExpr)node);
        }
        if (node instanceof FieldExpr) {
            return this.visitFieldExpr((FieldExpr)node);
        }
        if (node instanceof InvocationExpr) {
            return this.visitInvocationExpr((InvocationExpr)node);
        }
        if (node instanceof UnaryExpr) {
            return this.visitUnaryExpr((UnaryExpr)node);
        }
        if (node instanceof VarExpr) {
            return this.visitVarExpr((VarExpr)node);
        }
        if (node instanceof ParameterExpr) {
            return this.visitParameterExpr((ParameterExpr)node);
        }
        if (node instanceof CastExpr) {
            return this.visitCastExpr((CastExpr)node);
        }
        if (node instanceof PrimitiveCastExpr) {
            return this.visitPrimitiveCastExpr((PrimitiveCastExpr)node);
        }
        if (node instanceof NewArrayExpr) {
            return this.visitNewArrayExpr((NewArrayExpr)node);
        }
        if (node instanceof ThisExpr) {
            return this.visitThisExpr((ThisExpr)node);
        }
        if (node instanceof MultiStmtExpr) {
            return this.visitMultiStmtExpr((MultiStmtExpr)node);
        }
        if (node instanceof LocalVarNode) {
            return this.visitLocalVarNode((LocalVarNode)node);
        }
        if (node instanceof ParameterNode) {
            return this.visitParameterNode((ParameterNode)node);
        }
        if (node instanceof FieldNode) {
            return this.visitFieldNode((FieldNode)node);
        }
        throw new IllegalArgumentException("BUG!Unknown node type:" + node.getClass());
    }

    public List<T> visitAll(AstNode[] nodes) {
        if (nodes == null) {
            return Collections.EMPTY_LIST;
        }
        return this.visitAll(Arrays.asList(nodes));
    }

    public List<T> visitAll(List<? extends AstNode> nodes) {
        if (nodes == null) {
            return null;
        }
        LinkedList<T> result = new LinkedList<T>();
        for (AstNode astNode : nodes) {
            result.add(this.visit(astNode));
        }
        return result;
    }

    public Map<AstNode, T> visitChildren(AstNode node) {
        HashMap<AstNode, T> result = new HashMap<AstNode, T>();
        List<AstNode> children = node.getChildren();
        for (AstNode c : children) {
            result.put(c, this.visit(c));
        }
        return result;
    }
}

