/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ExprNode;

public abstract class BinaryExpr
extends ExprNode {
    public static final String OP_ADD = "+";
    public static final String OP_SUB = "-";
    public static final String OP_MUL = "*";
    public static final String OP_DIV = "/";
    public static final String OP_REM = "%";
    public static final String OP_AND = "&";
    public static final String OP_OR = "|";
    public static final String OP_XOR = "^";
    public static final String OP_SHIFT_LEFT = "<<";
    public static final String OP_SHIFT_RIGHT = ">>";
    public static final String OP_LE = "<=";
    public static final String OP_GE = ">=";
    public static final String OP_LT = "<";
    public static final String OP_GT = ">";
    public static final String OP_EQ = "==";
    public static final String OP_NE = "!=";
    public static final String OP_LOGIC_AND = "&&";
    public static final String OP_LOGIC_OR = "||";
    @Nonnull
    protected ExprNode expr1;
    @Nonnull
    protected ExprNode expr2;
    @Nonnull
    protected String operation;

    public BinaryExpr(@Nonnull ExprNode expr1, @Nonnull ExprNode expr2, @Nonnull String operation) {
        this.expr1 = expr1;
        this.expr2 = expr2;
        this.operation = operation;
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> ls = new LinkedList<AstNode>();
        this.addChild(ls, this.getExpr1());
        this.addChild(ls, this.getExpr2());
        return ls;
    }

    public ExprNode getExpr1() {
        return this.expr1;
    }

    public void setExpr1(ExprNode expr1) {
        Objects.requireNonNull(expr1);
        this.expr1 = expr1;
    }

    public ExprNode getExpr2() {
        return this.expr2;
    }

    public void setExpr2(ExprNode expr2) {
        Objects.requireNonNull(expr2);
        this.expr2 = expr2;
    }

    public String getOperation() {
        return this.operation;
    }
}

