/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import javax.annotation.Nullable;
import kalang.compiler.ast.ClassReference;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.exception.Exceptions;

public class ConstExpr
extends ExprNode {
    @Nullable
    protected Object value;
    protected Type constType;

    public ConstExpr(@Nullable Object value) {
        Type t;
        if (value == null) {
            t = Types.NULL_TYPE;
        } else {
            Class<?> vt = value.getClass();
            if (vt.equals(Integer.class)) {
                t = Types.INT_TYPE;
            } else if (vt.equals(Long.class)) {
                t = Types.LONG_TYPE;
            } else if (vt.equals(Float.class)) {
                t = Types.FLOAT_TYPE;
            } else if (vt.equals(Double.class)) {
                t = Types.DOUBLE_TYPE;
            } else if (vt.equals(Byte.class)) {
                t = Types.BYTE_TYPE;
            } else if (vt.equals(Boolean.class)) {
                t = Types.BOOLEAN_TYPE;
            } else if (vt.equals(Short.class)) {
                t = Types.SHORT_TYPE;
            } else if (vt.equals(Character.class)) {
                t = Types.CHAR_TYPE;
            } else if (vt.equals(String.class)) {
                t = Types.getStringClassType();
            } else if (vt.equals(ClassReference.class)) {
                t = Types.getClassClassType();
            } else {
                throw Exceptions.unsupportedTypeException(value);
            }
        }
        this.constType = t;
        this.value = value;
    }

    @Override
    public Type getType() {
        return this.constType;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }
}

