/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kalang.compiler.ast.AssignableExpr;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.core.ArrayType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;

public class ElementExpr
extends AssignableExpr {
    protected ExprNode arrayExpr;
    protected ExprNode index;

    public ElementExpr(ExprNode target, ExprNode key) {
        this.arrayExpr = target;
        this.index = key;
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> ls = new LinkedList<AstNode>();
        this.addChild(ls, this.arrayExpr);
        this.addChild(ls, this.index);
        return ls;
    }

    @Override
    public Type getType() {
        Type arrayType = ElementExpr.getType(this.getArrayExpr());
        if (arrayType == null) {
            return Types.VOID_TYPE;
        }
        if (!(arrayType instanceof ArrayType)) {
            throw new UnknownError("ArrayType is required!");
        }
        return ((ArrayType)arrayType).getComponentType();
    }

    public ExprNode getArrayExpr() {
        return this.arrayExpr;
    }

    public void setArrayExpr(ExprNode arrayExpr) {
        Objects.requireNonNull(arrayExpr);
        this.arrayExpr = arrayExpr;
    }

    public ExprNode getIndex() {
        return this.index;
    }

    public void setIndex(ExprNode index) {
        Objects.requireNonNull(index);
        this.index = index;
    }
}

