/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import kalang.compiler.AmbiguousMethodException;
import kalang.compiler.MethodNotFoundException;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.compile.KalangMethodSelector;
import kalang.compiler.core.GenericType;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;
import kalang.compiler.util.AstUtil;

public abstract class InvocationExpr
extends ExprNode {
    private final ObjectType clazz;
    private static final KalangMethodSelector methodSelector = new KalangMethodSelector();
    protected ExprNode[] arguments;
    private MethodDescriptor method;

    public static MethodSelection applyMethod(ObjectType clazz, String methodName, @Nullable ExprNode[] args, MethodDescriptor[] candidates) throws MethodNotFoundException, AmbiguousMethodException {
        List selectedList;
        Object[] types;
        if (args == null) {
            args = new ExprNode[]{};
        }
        if ((types = AstUtil.getExprTypes(args)) == null) {
            types = new Type[]{};
        }
        if ((selectedList = methodSelector.select(candidates, methodName, types)).isEmpty()) {
            throw new MethodNotFoundException(clazz, methodName);
        }
        if (selectedList.size() > 1) {
            throw new AmbiguousMethodException(selectedList);
        }
        MethodDescriptor md = (MethodDescriptor)selectedList.get(0);
        ExprNode[] matchedParam = AstUtil.matchTypes(args, (Type[])types, md.getParameterTypes());
        Objects.requireNonNull(matchedParam);
        md = md.toParameterized(new HashMap<GenericType, Type>(), AstUtil.getExprTypes(matchedParam));
        return new MethodSelection(md, matchedParam);
    }

    public InvocationExpr(ObjectType clazz, MethodDescriptor method, ExprNode[] args) {
        this.method = method;
        this.arguments = args;
        this.clazz = clazz;
    }

    @Nullable
    public Type[] getArgumentTypes() {
        if (this.getArguments() == null) {
            return null;
        }
        return AstUtil.getExprTypes(this.getArguments());
    }

    @Override
    public Type getType() {
        return this.method.getReturnType();
    }

    public ExprNode[] getArguments() {
        return this.arguments;
    }

    public MethodDescriptor getMethod() {
        return this.method;
    }

    public static class MethodSelection {
        public MethodDescriptor selectedMethod;
        public ExprNode[] appliedArguments;

        public MethodSelection(MethodDescriptor selectedMethod, ExprNode[] appliedArguments) {
            this.selectedMethod = selectedMethod;
            this.appliedArguments = appliedArguments;
        }
    }
}

