/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import kalang.compiler.AmbiguousMethodException;
import kalang.compiler.MethodNotFoundException;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.InvocationExpr;
import kalang.compiler.ast.ObjectInvokeExpr;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;

public class NewObjectExpr
extends ExprNode {
    protected ObjectType objectType;
    protected InvocationExpr constructor;

    public NewObjectExpr(ObjectType objectType, InvocationExpr constructor) {
        this.objectType = objectType;
        this.constructor = constructor;
    }

    public NewObjectExpr(ObjectType objectType, ExprNode[] args) throws MethodNotFoundException, AmbiguousMethodException {
        this(objectType, args, null);
    }

    public NewObjectExpr(ObjectType objectType) throws MethodNotFoundException, AmbiguousMethodException {
        this(objectType, new ExprNode[0], null);
    }

    public NewObjectExpr(ObjectType objectType, ExprNode[] args, @Nullable ClassNode caller) throws MethodNotFoundException, AmbiguousMethodException {
        this.objectType = objectType;
        this.initDefaultConstructor(args, caller);
    }

    private void initDefaultConstructor(ExprNode[] args, @Nullable ClassNode caller) throws MethodNotFoundException, AmbiguousMethodException {
        this.constructor = ObjectInvokeExpr.create(this, "<init>", args, caller);
    }

    @Override
    public List<AstNode> getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Type getType() {
        return this.getObjectType();
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        Objects.requireNonNull(objectType);
        this.objectType = objectType;
    }

    public InvocationExpr getConstructor() {
        return this.constructor;
    }

    public void setConstructor(InvocationExpr constructor) {
        Objects.requireNonNull(constructor);
        this.constructor = constructor;
    }
}

