/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import kalang.compiler.AmbiguousMethodException;
import kalang.compiler.MethodNotFoundException;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.InvocationExpr;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.ObjectType;
import kalang.compiler.util.AstUtil;
import kalang.compiler.util.Parameters;

public class ObjectInvokeExpr
extends InvocationExpr {
    private ExprNode invokeTarget;

    public static ObjectInvokeExpr create(ExprNode target, String methodName, ExprNode[] args) throws MethodNotFoundException, AmbiguousMethodException {
        return ObjectInvokeExpr.create(target, methodName, args, null);
    }

    public static ObjectInvokeExpr create(ExprNode target, String methodName, ExprNode[] args, @Nullable ClassNode caller) throws MethodNotFoundException, AmbiguousMethodException {
        ObjectType targetType = (ObjectType)target.getType();
        ClassNode clazz = targetType.getClassNode();
        boolean recursive = !"<init>".equals(methodName);
        LinkedList<MethodDescriptor> candidates = new LinkedList<MethodDescriptor>();
        candidates.addAll(Arrays.asList(targetType.getMethodDescriptors(caller, recursive, true)));
        InvocationExpr.MethodSelection ms = ObjectInvokeExpr.applyMethod(targetType, methodName, args, candidates.toArray(new MethodDescriptor[candidates.size()]));
        MethodDescriptor md = ms.selectedMethod;
        if (AstUtil.isStatic(md.getModifier())) {
            throw new MethodNotFoundException(methodName + " is static");
        }
        return new ObjectInvokeExpr(target, ms.selectedMethod, ms.appliedArguments);
    }

    public ObjectInvokeExpr(ExprNode invokeTarget, MethodDescriptor method, ExprNode[] args) {
        super((ObjectType)invokeTarget.getType(), method, args);
        Parameters.requireTrue(!Modifier.isStatic(method.getModifier()));
        this.invokeTarget = invokeTarget;
    }

    public ExprNode getInvokeTarget() {
        return this.invokeTarget;
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> list = new LinkedList<AstNode>();
        this.addChild(list, this.invokeTarget);
        this.addChild(list, this.arguments);
        return list;
    }
}

