/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import javax.annotation.Nullable;
import kalang.compiler.FieldNotFoundException;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ClassReference;
import kalang.compiler.ast.FieldExpr;
import kalang.compiler.core.FieldDescriptor;
import kalang.compiler.core.Types;
import kalang.compiler.util.AstUtil;

public class StaticFieldExpr
extends FieldExpr {
    private ClassReference clazz;

    public static StaticFieldExpr create(ClassReference clazz, String fieldName, @Nullable ClassNode caller) throws FieldNotFoundException {
        FieldDescriptor field = StaticFieldExpr.getField(Types.getClassType(clazz.getReferencedClassNode()), fieldName, caller);
        if (!AstUtil.isStatic(field.getModifier())) {
            throw new FieldNotFoundException(fieldName + " is not static");
        }
        return new StaticFieldExpr(clazz, field);
    }

    public StaticFieldExpr(ClassReference clazz, FieldDescriptor field) {
        super(field);
        if (!AstUtil.isStatic(field.getModifier())) {
            throw new IllegalArgumentException("static field required");
        }
        this.clazz = clazz;
    }

    public ClassReference getClassReference() {
        return this.clazz;
    }
}

