/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import kalang.compiler.AmbiguousMethodException;
import kalang.compiler.MethodNotFoundException;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ClassReference;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.InvocationExpr;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.Types;
import kalang.compiler.util.AstUtil;

public class StaticInvokeExpr
extends InvocationExpr {
    private ClassReference invokeClass;

    public static StaticInvokeExpr create(ClassReference clazz, String methodName, ExprNode[] args) throws MethodNotFoundException, AmbiguousMethodException {
        return StaticInvokeExpr.create(clazz, methodName, args, null);
    }

    public static StaticInvokeExpr create(ClassReference clazz, String methodName, ExprNode[] args, @Nullable ClassNode caller) throws MethodNotFoundException, AmbiguousMethodException {
        ClassType clazzType = Types.getClassType(clazz.getReferencedClassNode());
        MethodDescriptor[] candidates = clazzType.getMethodDescriptors(caller, true, true);
        InvocationExpr.MethodSelection ms = StaticInvokeExpr.applyMethod(Types.getClassType(clazz.getReferencedClassNode()), methodName, args, candidates);
        MethodDescriptor md = ms.selectedMethod;
        if (!AstUtil.isStatic(md.getModifier())) {
            throw new MethodNotFoundException(methodName + " is not static");
        }
        return new StaticInvokeExpr(clazz, md, ms.appliedArguments);
    }

    public StaticInvokeExpr(ClassReference invokeClass, MethodDescriptor method, ExprNode[] args) {
        super(Types.getClassType(invokeClass.getReferencedClassNode()), method, args);
        if (!AstUtil.isStatic(method.getModifier())) {
            throw new IllegalArgumentException("static method is required");
        }
        this.invokeClass = invokeClass;
    }

    public ClassReference getInvokeClass() {
        return this.invokeClass;
    }

    @Override
    public List<AstNode> getChildren() {
        ArrayList<AstNode> list = new ArrayList<AstNode>();
        this.addChild(list, this.invokeClass);
        this.addChild(list, this.arguments);
        return list;
    }
}

