/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.VarObject;
import kalang.compiler.core.ArrayType;
import kalang.compiler.core.Type;
import kalang.compiler.exception.Exceptions;

public class StoreArrayElementExpr
extends ExprNode {
    private VarObject array;
    private ExprNode index;
    private ExprNode valueExpr;

    public StoreArrayElementExpr(VarObject array, ExprNode index, ExprNode from) {
        if (!(array.getType() instanceof ArrayType)) {
            throw Exceptions.illegalArgument(array);
        }
        this.array = array;
        this.index = index;
        this.valueExpr = from;
    }

    @Override
    public Type getType() {
        return ((ArrayType)this.array.getType()).getComponentType();
    }

    public VarObject getArray() {
        return this.array;
    }

    public ExprNode getIndex() {
        return this.index;
    }

    public ExprNode getValueExpr() {
        return this.valueExpr;
    }
}

