/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;

public class UnaryExpr
extends ExprNode {
    public static final String OPERATION_NEG = "-";
    public static final String OPERATION_POS = "+";
    public static final String OPERATION_LOGIC_NOT = "!";
    public static final String OPERATION_NOT = "~";
    protected ExprNode expr;
    protected String operation;

    public UnaryExpr(ExprNode expr, String operation) {
        this.expr = expr;
        this.operation = operation;
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> ls = new LinkedList<AstNode>();
        this.addChild(ls, this.getExpr());
        return ls;
    }

    @Override
    public Type getType() {
        switch (this.getOperation()) {
            case "!": {
                return Types.BOOLEAN_TYPE;
            }
        }
        return UnaryExpr.getType(this.getExpr());
    }

    public ExprNode getExpr() {
        return this.expr;
    }

    public void setExpr(ExprNode expr) {
        Objects.requireNonNull(expr);
        this.expr = expr;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        Objects.requireNonNull(operation);
        this.operation = operation;
    }
}

