/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.annotation.PluginMethod;
import kalang.compiler.AmbiguousMethodException;
import kalang.compiler.FieldNotFoundException;
import kalang.compiler.MethodNotFoundException;
import kalang.compiler.antlr.KalangParser;
import kalang.compiler.antlr.KalangParserVisitor;
import kalang.compiler.ast.AnnotationNode;
import kalang.compiler.ast.ArrayLengthExpr;
import kalang.compiler.ast.AssignExpr;
import kalang.compiler.ast.AssignableExpr;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.BinaryExpr;
import kalang.compiler.ast.BlockStmt;
import kalang.compiler.ast.BreakStmt;
import kalang.compiler.ast.CastExpr;
import kalang.compiler.ast.CatchBlock;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ClassReference;
import kalang.compiler.ast.CompareExpr;
import kalang.compiler.ast.ConstExpr;
import kalang.compiler.ast.ContinueStmt;
import kalang.compiler.ast.ElementExpr;
import kalang.compiler.ast.ErrorousExpr;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.ExprStmt;
import kalang.compiler.ast.FieldExpr;
import kalang.compiler.ast.FieldNode;
import kalang.compiler.ast.IfStmt;
import kalang.compiler.ast.IncrementExpr;
import kalang.compiler.ast.InstanceOfExpr;
import kalang.compiler.ast.InvocationExpr;
import kalang.compiler.ast.LocalVarNode;
import kalang.compiler.ast.LogicExpr;
import kalang.compiler.ast.LoopStmt;
import kalang.compiler.ast.MathExpr;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.MultiStmt;
import kalang.compiler.ast.MultiStmtExpr;
import kalang.compiler.ast.NewArrayExpr;
import kalang.compiler.ast.NewObjectExpr;
import kalang.compiler.ast.ObjectFieldExpr;
import kalang.compiler.ast.ObjectInvokeExpr;
import kalang.compiler.ast.ParameterExpr;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.ast.PrimitiveCastExpr;
import kalang.compiler.ast.ReturnStmt;
import kalang.compiler.ast.Statement;
import kalang.compiler.ast.StaticFieldExpr;
import kalang.compiler.ast.StaticInvokeExpr;
import kalang.compiler.ast.SuperExpr;
import kalang.compiler.ast.ThisExpr;
import kalang.compiler.ast.ThrowStmt;
import kalang.compiler.ast.TryStmt;
import kalang.compiler.ast.UnaryExpr;
import kalang.compiler.ast.UnknownFieldExpr;
import kalang.compiler.ast.UnknownInvocationExpr;
import kalang.compiler.ast.VarDeclStmt;
import kalang.compiler.ast.VarExpr;
import kalang.compiler.ast.VarObject;
import kalang.compiler.compile.AstBuilderBase;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.ClassNodeInitializer;
import kalang.compiler.compile.ClassNodeStructureBuilder;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisReporter;
import kalang.compiler.compile.InitializationAnalyzer;
import kalang.compiler.compile.MethodContext;
import kalang.compiler.compile.OffsetRange;
import kalang.compiler.compile.TypeNameResolver;
import kalang.compiler.core.ArrayType;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.GenericType;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.PrimitiveType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.core.VarTable;
import kalang.compiler.exception.Exceptions;
import kalang.compiler.function.FunctionType;
import kalang.compiler.function.LambdaExpr;
import kalang.compiler.util.AnnotationUtil;
import kalang.compiler.util.AstUtil;
import kalang.compiler.util.BoxUtil;
import kalang.compiler.util.InterfaceUtil;
import kalang.compiler.util.LambdaUtil;
import kalang.compiler.util.MathType;
import kalang.compiler.util.MethodUtil;
import kalang.compiler.util.NameUtil;
import kalang.compiler.util.OffsetRangeHelper;
import kalang.compiler.util.StringLiteralUtil;
import kalang.compiler.util.TypeUtil;
import kalang.runtime.dynamic.MethodDispatcher;
import kalang.type.FunctionClasses;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AstBuilder
extends AstBuilderBase
implements KalangParserVisitor<Object> {
    public static final int PARSING_PHASE_INIT = 1;
    public static final int PARSING_PHASE_META = 2;
    public static final int PARSING_PHASE_ALL = 3;
    private ClassNodeInitializer classNodeInitializer;
    private ClassNodeStructureBuilder classNodeStructureBuilder;
    private Map<LambdaExpr, KalangParser.LambdaExprContext> lambdaExprCtxMap = new HashMap<LambdaExpr, KalangParser.LambdaExprContext>();
    private int anonymousClassCounter = 0;
    private int parsingPhase = 0;
    protected ClassNode thisClazz;
    private ClassNode topClass;
    private MethodContext methodCtx;
    @Nonnull
    private AstLoader astLoader;
    private ParserRuleContext compilationContext;
    @Nonnull
    private TokenStream tokenStream;
    @Nonnull
    private final String className;
    @Nonnull
    private KalangParser parser;
    private final CompilationUnit compilationUnit;

    @Override
    public Object visitEmptyStat(KalangParser.EmptyStatContext ctx) {
        BlockStmt b = this.newBlock();
        this.popBlock();
        return b;
    }

    @Override
    public Object visitAssertStmt(KalangParser.AssertStmtContext ctx) {
        NewObjectExpr newErrorExpr;
        ExprNode failExpr = this.visitExpression(ctx.testCondition);
        if (failExpr == null) {
            return null;
        }
        if ((failExpr = BoxUtil.assign(failExpr, failExpr.getType(), Types.BOOLEAN_TYPE)) == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "boolean type expected", ctx.testCondition);
            return null;
        }
        failExpr = new UnaryExpr(failExpr, "!");
        ExprNode failMsgExpr = null;
        if (ctx.failMessage != null) {
            failMsgExpr = this.visitExpression(ctx.failMessage);
            if (failMsgExpr == null) {
                return null;
            }
            if (Types.VOID_TYPE.equals(failMsgExpr.getType())) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "non-void type expected", ctx.failMessage);
                return null;
            }
        }
        BlockStmt body = this.newBlock();
        try {
            ExprNode[] exprNodeArray;
            ObjectType objectType = Types.requireAssertionErrorClassType();
            if (failMsgExpr != null) {
                ExprNode[] exprNodeArray2 = new ExprNode[1];
                exprNodeArray = exprNodeArray2;
                exprNodeArray2[0] = failMsgExpr;
            } else {
                exprNodeArray = new ExprNode[]{};
            }
            newErrorExpr = new NewObjectExpr(objectType, exprNodeArray);
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
        body.statements.add(new ThrowStmt(newErrorExpr));
        this.popBlock();
        return new IfStmt(failExpr, body, null);
    }

    @Override
    ClassNode getCurrentClass() {
        return this.thisClazz;
    }

    @Override
    ClassNode getTopClass() {
        return this.topClass;
    }

    public ParserRuleContext getParseTree() {
        return this.compilationContext;
    }

    @Nonnull
    public String getClassName() {
        return this.className;
    }

    public void compile() {
        this.compile(3, null);
    }

    public void compile(int targetPhase) {
        this.compile(targetPhase, null);
    }

    public void compile(int targetPhase, @Nullable AstLoader astLoader) {
        this.astLoader = astLoader == null ? new AstLoader() : astLoader;
        this.compilationUnit.getTypeNameResolver().setAstLoader(astLoader);
        if (targetPhase >= 1 && this.parsingPhase < 1) {
            this.parsingPhase = 1;
            KalangParser.CompilationUnitContext cunit = this.parser.compilationUnit();
            this.compilationContext = cunit;
            for (KalangParser.ImportDeclContext ic : cunit.importDecl()) {
                this.visitImportDecl(ic);
            }
            this.classNodeInitializer = new ClassNodeInitializer(this.compilationUnit);
            this.topClass = this.classNodeInitializer.build(cunit);
        }
        if (targetPhase >= 2 && this.parsingPhase < 2) {
            this.parsingPhase = 2;
            this.classNodeStructureBuilder = new ClassNodeStructureBuilder(this.compilationUnit, this.parser);
            this.buildClassNodeMeta(this.topClass);
        }
        if (targetPhase >= 3 && this.parsingPhase < 3) {
            this.parsingPhase = 3;
            this.visitMethods(this.topClass);
            this.processConstructor(this.topClass);
            this.checkAndBuildInterfaceMethods(this.topClass);
        }
    }

    private void visitMethods(ClassNode clazz) {
        this.thisClazz = clazz;
        for (MethodNode m : this.thisClazz.getDeclaredMethodNodes()) {
            BlockStmt mbody = m.getBody();
            KalangParser.StatContext[] stats = this.classNodeStructureBuilder.getStatContexts(m);
            if (stats == null) continue;
            this.enterMethod(m);
            this.visitBlockStmt(stats, mbody);
            this.checkMethod();
        }
        for (ClassNode c : clazz.classes) {
            this.visitMethods(c);
        }
    }

    public AstBuilder(@Nonnull CompilationUnit compilationUnit, @Nonnull KalangParser parser) {
        super(compilationUnit);
        this.compilationUnit = compilationUnit;
        this.className = compilationUnit.getSource().getClassName();
        this.parser = parser;
        this.tokenStream = parser.getTokenStream();
    }

    @Nonnull
    private String getPackageName() {
        if (this.className.contains(".")) {
            return this.className.substring(0, this.className.lastIndexOf(46));
        }
        return "";
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.className;
    }

    @Nonnull
    public AstLoader getAstLoader() {
        return this.astLoader;
    }

    @Nonnull
    public TokenStream getTokenStream() {
        return this.tokenStream;
    }

    @Nonnull
    public KalangParser getParser() {
        return this.parser;
    }

    @Override
    public ObjectType visitLambdaType(KalangParser.LambdaTypeContext ctx) {
        return this.parseLambdaType(ctx);
    }

    public Object visit(ParseTree tree) {
        if (tree == null) {
            System.err.print("visit null");
            Exception ex = new Exception();
            ex.printStackTrace(System.err);
            return null;
        }
        if (tree instanceof KalangParser.StatContext && this.methodCtx.returned) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "unreachable statement", (KalangParser.StatContext)tree);
        }
        return super.visit(tree);
    }

    public void importPackage(@Nonnull String packageName) {
        this.compilationUnit.getTypeNameResolver().importPackage(packageName);
    }

    private BlockStmt newBlock() {
        BlockStmt bs = new BlockStmt();
        this.methodCtx.newFrame();
        return bs;
    }

    private void popBlock() {
        this.methodCtx.popFrame();
    }

    @Nonnull
    public ClassNode getAst() {
        return this.topClass;
    }

    @Override
    public ThrowStmt visitThrowStat(KalangParser.ThrowStatContext ctx) {
        ThrowStmt ts = new ThrowStmt(this.visitExpression(ctx.expression()));
        this.mapAst((AstNode)ts, ctx);
        this.methodCtx.returned = true;
        return ts;
    }

    @Override
    public MultiStmtExpr visitMapExpr(KalangParser.MapExprContext ctx) {
        NewObjectExpr newExpr;
        ObjectType valueType;
        List<KalangParser.ExpressionContext> keys = ctx.keys;
        List<KalangParser.ExpressionContext> values = ctx.values;
        ExprNode[] keyExprs = new ExprNode[keys.size()];
        ExprNode[] valuesExprs = new ExprNode[values.size()];
        for (int i = 0; i < keys.size(); ++i) {
            KalangParser.ExpressionContext ke = keys.get(i);
            KalangParser.ExpressionContext e = values.get(i);
            ExprNode k = this.visitExpression(ke);
            if (k == null) {
                return null;
            }
            ExprNode v = this.visitExpression(e);
            if (v == null) {
                return null;
            }
            keyExprs[i] = k;
            valuesExprs[i] = v;
        }
        Type[] valuesTypes = AstUtil.getExprTypes(valuesExprs);
        Objects.requireNonNull(valuesTypes);
        Type[] keyTypes = AstUtil.getExprTypes(keyExprs);
        Objects.requireNonNull(keyTypes);
        ObjectType keyType = ctx.keyType != null ? this.requireClassType(ctx.keyType) : this.getTypeForGeneric(TypeUtil.getCommonType(keyTypes));
        ObjectType objectType = valueType = ctx.valueType != null ? this.requireClassType(ctx.valueType) : this.getTypeForGeneric(TypeUtil.getCommonType(valuesTypes));
        if (keyType == null || valueType == null) {
            return null;
        }
        LocalVarNode vo = this.declareTempLocalVar(Types.getClassType(Types.getMapImplClassType().getClassNode(), new Type[]{keyType, valueType}));
        VarDeclStmt vds = new VarDeclStmt(vo);
        try {
            newExpr = new NewObjectExpr(Types.getMapImplClassType());
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        stmts.add(vds);
        stmts.add(new ExprStmt(new AssignExpr(new VarExpr(vo), newExpr)));
        VarExpr ve = new VarExpr(vo);
        for (int i = 0; i < keyExprs.length; ++i) {
            ObjectInvokeExpr iv;
            ExprNode[] args = new ExprNode[]{keyExprs[i], valuesExprs[i]};
            try {
                iv = ObjectInvokeExpr.create(ve, "put", args);
            }
            catch (AmbiguousMethodException | MethodNotFoundException ex) {
                throw Exceptions.unexceptedException(ex);
            }
            ExprStmt es = new ExprStmt(iv);
            stmts.add(es);
        }
        MultiStmtExpr mse = new MultiStmtExpr(stmts, ve);
        this.mapAst((AstNode)mse, ctx);
        return mse;
    }

    @Override
    public ExprNode visitNewArrayExpr(KalangParser.NewArrayExprContext ctx) {
        ExprNode ret;
        Type type = this.parseType(ctx.type());
        if (ctx.size != null) {
            ExprNode size = this.visitExpression(ctx.size);
            ret = new NewArrayExpr(type, size);
        } else {
            ExprNode[] initExprs = new ExprNode[ctx.initExpr.size()];
            for (int i = 0; i < initExprs.length; ++i) {
                initExprs[i] = this.visitExpression(ctx.initExpr.get(i));
            }
            ret = this.createInitializedArray(type, initExprs);
        }
        this.mapAst((AstNode)ret, ctx);
        return ret;
    }

    @Override
    public AstNode visitQuestionExpr(KalangParser.QuestionExprContext ctx) {
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        ExprNode conditionExpr = (ExprNode)this.visit((ParseTree)ctx.expression(0));
        this.methodCtx.newOverrideTypeStack();
        this.methodCtx.onIf(conditionExpr, true);
        ExprNode trueExpr = (ExprNode)this.visit((ParseTree)ctx.expression(1));
        this.methodCtx.popOverrideTypeStack();
        this.methodCtx.newOverrideTypeStack();
        this.methodCtx.onIf(conditionExpr, false);
        ExprNode falseExpr = (ExprNode)this.visit((ParseTree)ctx.expression(2));
        this.methodCtx.popOverrideTypeStack();
        Type trueType = trueExpr.getType();
        Type falseType = falseExpr.getType();
        Type type = trueType.equals(falseType) ? trueType : TypeUtil.getCommonType(trueType, falseType);
        LocalVarNode vo = this.declareTempLocalVar(type);
        VarDeclStmt vds = new VarDeclStmt(vo);
        stmts.add(vds);
        VarExpr ve = new VarExpr(vo);
        IfStmt is = new IfStmt(conditionExpr);
        is.getTrueBody().statements.add(new ExprStmt(new AssignExpr(ve, trueExpr)));
        is.getFalseBody().statements.add(new ExprStmt(new AssignExpr(ve, falseExpr)));
        stmts.add(is);
        MultiStmtExpr mse = new MultiStmtExpr(stmts, ve);
        this.mapAst((AstNode)ve, ctx);
        return mse;
    }

    @Override
    public AstNode visitCompilationUnit(KalangParser.CompilationUnitContext ctx) {
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public AstNode visitClassBody(KalangParser.ClassBodyContext ctx) {
        this.visitChildren((RuleNode)ctx);
        this.mapAst((AstNode)this.thisClazz, ctx);
        return null;
    }

    @Override
    public Void visitFieldDecl(KalangParser.FieldDeclContext ctx) {
        int fieldModifier = this.parseModifier(ctx.varModifier());
        for (KalangParser.VarDeclContext vd : ctx.varDecl()) {
            ExprNode initExpr = vd.expression() != null ? this.visitExpression(vd.expression()) : null;
            VarInfo varInfo = this.varDecl(vd, initExpr == null ? Types.getRootType() : initExpr.getType());
            varInfo.modifier |= fieldModifier;
            FieldNode fieldNode = this.thisClazz.createField(varInfo.type, varInfo.name, varInfo.modifier);
            if (initExpr == null) continue;
            if (AstUtil.isStatic(fieldNode.modifier)) {
                this.thisClazz.staticInitStmts.add(new ExprStmt(new AssignExpr(new StaticFieldExpr(new ClassReference(this.thisClazz), fieldNode), initExpr)));
                continue;
            }
            this.thisClazz.initStmts.add(new ExprStmt(new AssignExpr(new ObjectFieldExpr(new ThisExpr(this.getThisType()), fieldNode), initExpr)));
        }
        return null;
    }

    private boolean isNonStaticInnerClass(ClassNode clazz) {
        return clazz.enclosingClass != null && !Modifier.isStatic(clazz.modifier);
    }

    @Override
    public AstNode visitMethodDecl(KalangParser.MethodDeclContext ctx) {
        throw Exceptions.unexceptedException("");
    }

    @Override
    public AstNode visitType(KalangParser.TypeContext ctx) {
        return null;
    }

    public List<Object> visitAll(List<? extends ParserRuleContext> list) {
        ArrayList<Object> ret = new ArrayList<Object>(list.size());
        for (ParserRuleContext parserRuleContext : list) {
            ret.add(this.visit((ParseTree)parserRuleContext));
        }
        return ret;
    }

    @Override
    public AstNode visitIfStat(KalangParser.IfStatContext ctx) {
        ExprNode expr = this.visitExpression(ctx.expression());
        if (expr == null) {
            return null;
        }
        Type exprType = expr.getType();
        if ((expr = BoxUtil.assign(expr, expr.getType(), Types.BOOLEAN_TYPE)) == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, exprType + " cannot be converted to boolean", ctx.expression());
            return null;
        }
        BlockStmt trueBody = null;
        BlockStmt falseBody = null;
        VarTable<VarObject, Integer> trueAssigned = this.methodCtx.nullState.newStack();
        this.methodCtx.nullState = trueAssigned;
        this.methodCtx.newOverrideTypeStack();
        this.methodCtx.onIf(expr, true);
        if (ctx.trueStmt != null) {
            trueBody = this.requireBlock(ctx.trueStmt);
        }
        this.methodCtx.popOverrideTypeStack();
        this.methodCtx.nullState = this.methodCtx.nullState.popStack();
        boolean trueReturned = this.methodCtx.returned;
        this.methodCtx.returned = false;
        VarTable<VarObject, Integer> falseAssigned = this.methodCtx.nullState.newStack();
        this.methodCtx.nullState = falseAssigned;
        this.methodCtx.newOverrideTypeStack();
        this.methodCtx.onIf(expr, false);
        if (ctx.falseStmt != null) {
            falseBody = this.requireBlock(ctx.falseStmt);
        }
        this.methodCtx.popOverrideTypeStack();
        this.methodCtx.nullState = this.methodCtx.nullState.popStack();
        this.methodCtx.handleMultiBranchedAssign(trueAssigned.vars(), falseAssigned.vars());
        boolean falseReturned = this.methodCtx.returned;
        if (trueReturned) {
            this.methodCtx.onIf(expr, false);
        }
        if (falseReturned) {
            this.methodCtx.onIf(expr, true);
        }
        this.methodCtx.returned = falseReturned && trueReturned;
        IfStmt ifStmt = new IfStmt(expr, trueBody, falseBody);
        this.mapAst((AstNode)ifStmt, ctx);
        return ifStmt;
    }

    protected ExprNode visitExpression(KalangParser.ExpressionContext expression) {
        Object node = this.visit((ParseTree)expression);
        if (node instanceof ExprNode) {
            return (ExprNode)node;
        }
        ErrorousExpr expr = node instanceof AstNode ? new ErrorousExpr((AstNode)node) : new ErrorousExpr(new AstNode[0]);
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "not an expression", expression);
        return expr;
    }

    @Override
    public Statement visitStat(KalangParser.StatContext ctx) {
        ParseTree child = ctx.getChild(0);
        return child == null ? null : (Statement)this.visit(child);
    }

    @Override
    public AstNode visitReturnStat(KalangParser.ReturnStatContext ctx) {
        ReturnStmt rs = new ReturnStmt();
        this.mapAst((AstNode)rs, ctx);
        if (ctx.expression() != null) {
            rs.expr = this.visitExpression(ctx.expression());
        } else if (this.methodCtx.method.getType().equals(Types.getVoidClassType())) {
            rs.expr = new ConstExpr(null);
        }
        if (!this.semanticAnalyzer.validateReturnStmt(this.methodCtx.method, rs)) {
            return null;
        }
        this.methodCtx.returned = true;
        Type rType = this.methodCtx.method.getType();
        if (rs.expr != null && rType instanceof GenericType) {
            Type eType = rs.expr.getType();
            Type oldType = this.thisClazz.inferredGenericTypes.get(rType);
            Type newType = oldType == null ? eType : TypeUtil.getCommonType(oldType, eType);
            this.thisClazz.inferredGenericTypes.put((GenericType)rType, newType);
        }
        return rs;
    }

    @Override
    public Statement visitVarDeclStat(KalangParser.VarDeclStatContext ctx) {
        Statement vars = this.visitLocalVarDecl(ctx.localVarDecl());
        this.mapAst((AstNode)vars, ctx);
        return vars;
    }

    @Override
    public VarObject visitVarDecl(KalangParser.VarDeclContext ctx) {
        throw Exceptions.unexceptedException("It should never be executed");
    }

    protected VarInfo varDecl(KalangParser.VarDeclContext ctx, Type inferedType) {
        Type declType;
        VarInfo vds = new VarInfo();
        String name = ctx.name.getText();
        KalangParser.TypeContext type = null;
        if (ctx.varType != null) {
            type = ctx.varType;
        } else if (ctx.type() != null) {
            type = ctx.type();
        }
        Type type2 = declType = type != null ? this.parseType(type) : inferedType;
        if (this.isDefindedId(name)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "the name is definded:" + name, ctx);
        }
        vds.name = name;
        vds.type = declType;
        int n = vds.modifier = ctx.valToken != null ? 16 : 0;
        if (vds.type == null) {
            vds.type = Types.getRootType();
        }
        return vds;
    }

    public void methodIsAmbiguous(Token token, AmbiguousMethodException ex) {
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, ex.getMessage(), token);
    }

    public void methodNotFound(Token token, Type type, String methodName, ExprNode[] params) {
        this.methodNotFound(token, type.getName(), methodName, params);
    }

    public void methodNotFound(Token token, String className, String methodName, ExprNode[] params) {
        Type[] types = AstUtil.getExprTypes(params);
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method not found:" + MethodUtil.toString(className, methodName, types), token);
    }

    @Override
    public AstNode visitBreakStat(KalangParser.BreakStatContext ctx) {
        BreakStmt bs = new BreakStmt();
        this.mapAst((AstNode)bs, ctx);
        return bs;
    }

    @Override
    public AstNode visitContinueStat(KalangParser.ContinueStatContext ctx) {
        ContinueStmt cs = new ContinueStmt();
        this.mapAst((AstNode)cs, ctx);
        return cs;
    }

    @Override
    public AstNode visitWhileStat(KalangParser.WhileStatContext ctx) {
        ExprNode preConditionExpr = this.visitExpression(ctx.expression());
        BlockStmt loopBody = null;
        if (ctx.stat() != null) {
            loopBody = this.requireBlock(ctx.stat());
        }
        LoopStmt ws = new LoopStmt(preConditionExpr, null, loopBody, null);
        this.mapAst((AstNode)ws, ctx);
        return ws;
    }

    @Override
    public AstNode visitDoWhileStat(KalangParser.DoWhileStatContext ctx) {
        BlockStmt loopBody = null;
        if (ctx.blockStmt() != null) {
            loopBody = this.requireBlock(ctx.blockStmt());
        }
        ExprNode postConditionExpr = this.visitExpression(ctx.expression());
        LoopStmt ls = new LoopStmt(null, postConditionExpr, loopBody, null);
        this.mapAst((AstNode)ls, ctx);
        return ls;
    }

    @Override
    public AstNode visitForStat(KalangParser.ForStatContext ctx) {
        BlockStmt forStmt = this.newBlock();
        if (ctx.localVarDecl() != null) {
            Statement vars = this.visitLocalVarDecl(ctx.localVarDecl());
            forStmt.statements.add(vars);
        }
        if (ctx.initExpressions != null) {
            forStmt.statements.addAll((Collection<Statement>)this.visitExpressions(ctx.initExpressions));
        }
        ExprNode preConditionExpr = ctx.condition != null ? this.visitExpression(ctx.condition) : null;
        BlockStmt bs = this.newBlock();
        if (ctx.stat() != null) {
            Statement st = this.visitStat(ctx.stat());
            if (st instanceof BlockStmt) {
                bs.statements.addAll(((BlockStmt)st).statements);
            } else if (st != null) {
                bs.statements.add(st);
            }
        }
        this.popBlock();
        BlockStmt updateBs = this.newBlock();
        if (ctx.updateExpressions != null) {
            updateBs.statements.addAll((Collection<Statement>)this.visitExpressions(ctx.updateExpressions));
        }
        this.popBlock();
        LoopStmt ls = new LoopStmt(preConditionExpr, null, bs, updateBs);
        this.mapAst((AstNode)ls, ctx);
        forStmt.statements.add(ls);
        this.popBlock();
        return forStmt;
    }

    @Override
    public List<Statement> visitExpressions(KalangParser.ExpressionsContext ctx) {
        LinkedList<Statement> list = new LinkedList<Statement>();
        for (KalangParser.ExpressionContext e : ctx.expression()) {
            ExprNode expr = this.visitExpression(e);
            list.add(new ExprStmt(expr));
        }
        return list;
    }

    @Override
    public AstNode visitExprStat(KalangParser.ExprStatContext ctx) {
        ExprNode expr = this.visitExpression(ctx.expression());
        ExprStmt es = new ExprStmt(expr);
        this.mapAst((AstNode)es, ctx);
        return es;
    }

    @Override
    public ExprNode visitMemberInvocationExpr(KalangParser.MemberInvocationExprContext ctx) {
        ExprNode ie;
        ObjectType clazz;
        ExprNode target;
        String methodName = ctx.key != null ? ctx.key.getText() : ctx.Identifier().getText();
        if (methodName.equals("this")) {
            methodName = "<init>";
            target = new ThisExpr(this.getThisType());
            clazz = this.getThisType();
        } else if (methodName.equals("super")) {
            methodName = "<init>";
            target = new SuperExpr(this.thisClazz);
            clazz = this.thisClazz.getSuperType();
        } else {
            target = new ThisExpr(this.getThisType());
            clazz = this.getThisType();
        }
        List<Object> argsList = this.visitAll(ctx.params);
        if (argsList.contains(null)) {
            return null;
        }
        ExprNode[] args = argsList.toArray(new ExprNode[argsList.size()]);
        if (methodName.equals("<init>")) {
            if (clazz == null) {
                throw Exceptions.unexceptedValue(clazz);
            }
            try {
                InvocationExpr.MethodSelection apply = InvocationExpr.applyMethod(clazz, methodName, args, clazz.getConstructorDescriptors(this.thisClazz));
                ie = this.onInvocationExpr(new ObjectInvokeExpr(target, apply.selectedMethod, apply.appliedArguments));
            }
            catch (AmbiguousMethodException | MethodNotFoundException ex) {
                this.methodNotFound(ctx.start, clazz.getName(), methodName, args);
                return null;
            }
        } else {
            ie = this.getImplicitInvokeExpr(methodName, args, ctx);
        }
        return ie;
    }

    private BinaryExpr constructBinaryExpr(ExprNode expr1, ExprNode expr2, String op) {
        BinaryExpr binExpr;
        switch (op) {
            case "==": 
            case "!=": 
            case ">": 
            case ">=": 
            case "<": 
            case "<=": {
                binExpr = new CompareExpr(expr1, expr2, op);
                break;
            }
            case "&&": 
            case "||": {
                binExpr = new LogicExpr(expr1, expr2, op);
                break;
            }
            default: {
                binExpr = new MathExpr(expr1, expr2, op);
            }
        }
        this.semanticAnalyzer.validateBinaryExpr(binExpr);
        return binExpr;
    }

    protected ExprNode createFieldExpr(KalangParser.GetFieldExprContext to, @Nullable KalangParser.ExpressionContext fromCtx, OffsetRange offsetRange) {
        String refKey = to.refKey.getText();
        KalangParser.ExpressionContext exp = to.expression();
        String fname = to.Identifier().getText();
        Object expr = this.visit((ParseTree)exp);
        if (expr == null) {
            return null;
        }
        if (refKey.equals(".")) {
            ExprNode fieldExpr;
            if (expr instanceof ExprNode) {
                ExprNode exprNode = (ExprNode)expr;
                fieldExpr = this.getObjectFieldLikeExpr(exprNode, fname, to);
            } else if (expr instanceof ClassReference) {
                fieldExpr = this.getStaticFieldExpr((ClassReference)expr, fname, to);
            } else {
                throw new UnknownError("unknown node:" + expr);
            }
            if (fromCtx == null) {
                return fieldExpr;
            }
            if (!(fieldExpr instanceof AssignableExpr)) {
                this.handleSyntaxError("unsupported", to);
                return null;
            }
            AssignableExpr toExpr = (AssignableExpr)fieldExpr;
            ExprNode fromExpr = this.visitExpression(fromCtx);
            if (!this.semanticAnalyzer.validateAssign(toExpr, fromExpr, offsetRange, this.isInConstructor())) {
                return null;
            }
            return new AssignExpr(toExpr, fromExpr);
        }
        if (refKey.equals("->")) {
            String methodName;
            ExprNode[] params;
            if (fromCtx == null) {
                params = new ExprNode[]{};
                methodName = "get" + NameUtil.firstCharToUpperCase(fname);
            } else {
                params = new ExprNode[1];
                methodName = "set" + NameUtil.firstCharToUpperCase(fname);
            }
            if (expr instanceof ExprNode) {
                if (fromCtx != null) {
                    params[0] = this.visitExpression(fromCtx);
                }
                return this.getObjectInvokeExpr((ExprNode)expr, methodName, params, (ParserRuleContext)to);
            }
            this.handleSyntaxError("object expression required.", to);
            return null;
        }
        throw Exceptions.unknownValue(refKey);
    }

    @Override
    public ExprNode visitAssignExpr(KalangParser.AssignExprContext ctx) {
        ExprNode expr;
        String assignOp = ctx.getChild(1).getText();
        KalangParser.ExpressionContext toCtx = ctx.expression(0);
        KalangParser.ExpressionContext fromCtx = ctx.expression(1);
        if (toCtx instanceof KalangParser.GetFieldExprContext) {
            expr = this.createFieldExpr((KalangParser.GetFieldExprContext)toCtx, fromCtx, OffsetRangeHelper.getOffsetRange(ctx));
        } else {
            ExprNode to = this.visitExpression(toCtx);
            ExprNode from = this.visitExpression(fromCtx);
            if (assignOp.length() > 1) {
                String op = assignOp.substring(0, assignOp.length() - 1);
                from = this.createBinaryExpr(op, toCtx, fromCtx, ctx);
            }
            if (to instanceof AssignableExpr) {
                AssignableExpr toExpr = (AssignableExpr)to;
                if (!this.semanticAnalyzer.validateAssign(toExpr, from, OffsetRangeHelper.getOffsetRange(ctx), this.isInConstructor())) {
                    return null;
                }
                AssignExpr aexpr = new AssignExpr(toExpr, from);
                this.mapAst((AstNode)aexpr, ctx);
                this.methodCtx.onAssign(toExpr, from);
                expr = aexpr;
            } else {
                this.handleSyntaxError("unsupported assign statement", ctx);
                return null;
            }
        }
        return expr;
    }

    @Nullable
    private ExprNode concatExpressionsToStringExpr(ExprNode[] expr, Token[] startTokens) {
        ExprNode ret;
        try {
            ret = new NewObjectExpr(Types.requireClassType("java.lang.StringBuilder"), new ExprNode[0]);
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
        for (int i = 0; i < expr.length; ++i) {
            try {
                ret = ObjectInvokeExpr.create(ret, "append", new ExprNode[]{expr[i]});
                continue;
            }
            catch (AmbiguousMethodException | MethodNotFoundException ex) {
                throw Exceptions.unexceptedException(ex);
            }
        }
        try {
            return ObjectInvokeExpr.create(ret, "toString", new ExprNode[0]);
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ExprNode createBinaryExpr(String op, KalangParser.ExpressionContext exprCtx1, KalangParser.ExpressionContext exprCtx2, ParserRuleContext ctx) {
        ExprNode expr;
        block18: {
            String errMsg;
            Type type2;
            Type type1;
            ExprNode expr2;
            ExprNode expr1;
            block20: {
                boolean isPrimitive2;
                boolean isPrimitive1;
                block19: {
                    expr1 = this.visitExpression(exprCtx1);
                    expr2 = this.visitExpression(exprCtx2);
                    if (expr1 == null || expr2 == null) {
                        return null;
                    }
                    type1 = expr1.getType();
                    type2 = expr2.getType();
                    isPrimitive1 = type1 instanceof PrimitiveType;
                    isPrimitive2 = type2 instanceof PrimitiveType;
                    errMsg = String.format("bad operand types:%s %s %s", type1, op, type2);
                    if (Types.VOID_TYPE.equals(type1) || Types.VOID_TYPE.equals(type2)) {
                        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, String.format("bad operand types:%s %s %s", type1, op, type2), ctx);
                        return null;
                    }
                    if (!"+".equals(op)) break block19;
                    if (Types.isNumber(type1) && Types.isNumber(type2)) {
                        expr = this.createBinaryMathExpr(expr1, expr2, op);
                        break block18;
                    } else {
                        if (!Types.isStringType(type1) && !Types.isStringType(type2)) {
                            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, errMsg, ctx);
                            return null;
                        }
                        expr = this.concatExpressionsToStringExpr(new ExprNode[]{expr1, expr2}, new Token[]{exprCtx1.getStart(), exprCtx2.getStart()});
                    }
                    break block18;
                }
                if (!"==".equals(op) && !"!=".equals(op)) break block20;
                if (type1 instanceof ObjectType) {
                    ClassReference objectsRef = new ClassReference(Types.requireClassType(Objects.class.getName()).getClassNode());
                    expr = this.getStaticInvokeExpr(objectsRef, "equals", new ExprNode[]{expr1, expr2}, ctx);
                    if ("!=".equals(op)) {
                        expr = new UnaryExpr(expr, "!");
                    }
                    break block18;
                } else {
                    expr = Types.isNumber(type1) && Types.isNumber(type2) && (isPrimitive1 || isPrimitive2) ? this.createBinaryMathExpr(expr1, expr2, op) : (Types.isBoolean(type1) && Types.isBoolean(type2) && (isPrimitive1 || isPrimitive2) ? this.createBinaryBoolOperateExpr(expr1, expr2, op) : this.constructBinaryExpr(expr1, expr2, op));
                }
                break block18;
            }
            if ("===".equals(op) || "!==".equals(op)) {
                if (!(type1 instanceof ObjectType)) {
                    String msg = "object type is required";
                    this.diagnosisReporter.report(Diagnosis.Kind.ERROR, msg, ctx);
                    return null;
                }
                expr = this.constructBinaryExpr(expr1, expr2, op.substring(0, 2));
            } else {
                if (">>>".equals(op) || "<<".equals(op) || ">>".equals(op)) {
                    if (Types.isExactNumber(type1) && Types.isExactNumber(type2)) {
                        expr = this.createBinaryMathExpr(expr1, expr2, op);
                        break block18;
                    } else {
                        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, errMsg, ctx);
                        return null;
                    }
                }
                if ("&&".equals(op) || "||".equals(op)) {
                    if (!Types.isBoolean(type1) || !Types.isBoolean(type2)) {
                        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, errMsg, ctx);
                        return null;
                    }
                    expr = this.createBinaryBoolOperateExpr(expr1, expr2, op);
                } else {
                    expr = this.createBinaryMathExpr(expr1, expr2, op);
                }
            }
        }
        if (expr == null) {
            return null;
        }
        this.mapAst((AstNode)expr, ctx);
        return expr;
    }

    @Override
    public AstNode visitBinaryExpr(KalangParser.BinaryExprContext ctx) {
        TerminalNode opNode = (TerminalNode)ctx.getChild(1);
        String op = opNode.getText();
        return this.createBinaryExpr(op, ctx.expression(0), ctx.expression(1), ctx);
    }

    @Nullable
    private ExprNode getImplicitInvokeExpr(String methodName, ExprNode[] args, ParserRuleContext ctx) {
        ExprNode expr;
        AstNode namedNode = this.getNodeById(methodName, ctx.start);
        if (namedNode != null && (namedNode instanceof ParameterExpr || namedNode instanceof VarExpr)) {
            return this.getLambdaCall(methodName, (ExprNode)namedNode, args, ctx);
        }
        ObjectType clazzType = this.getThisType();
        ThisExpr invokeTarget = new ThisExpr(clazzType);
        MethodDescriptor[] namedMethods = clazzType.getMethodDescriptors(this.thisClazz, methodName, true, true);
        if (namedMethods.length <= 0 && namedNode instanceof FieldExpr) {
            return this.getLambdaCall(methodName, (FieldExpr)namedNode, args, ctx);
        }
        if (namedMethods.length <= 0) {
            ExprNode outerClassExpr = new ThisExpr(this.thisClazz);
            while (namedMethods.length <= 0 && (outerClassExpr = this.getOuterClassInstanceExpr(outerClassExpr)) != null) {
                namedMethods = ((ObjectType)outerClassExpr.getType()).getMethodDescriptors(this.thisClazz, methodName, true, true);
            }
            invokeTarget = outerClassExpr;
        }
        if (namedMethods.length <= 0 && (namedMethods = this.getStaticImportedMethods(methodName).toArray(new MethodDescriptor[0])).length > 0) {
            clazzType = Types.getClassType(namedMethods[0].getMethodNode().getClassNode());
        }
        try {
            InvocationExpr.MethodSelection ms = InvocationExpr.applyMethod(clazzType, methodName, args, namedMethods);
            expr = Modifier.isStatic(ms.selectedMethod.getModifier()) ? this.onInvocationExpr(new StaticInvokeExpr(new ClassReference(clazzType.getClassNode()), ms.selectedMethod, ms.appliedArguments)) : this.onInvocationExpr(new ObjectInvokeExpr(invokeTarget, ms.selectedMethod, ms.appliedArguments));
        }
        catch (MethodNotFoundException ex) {
            this.methodNotFound(ctx.getStart(), clazzType, methodName, args);
            expr = new UnknownInvocationExpr(null, methodName, args);
        }
        catch (AmbiguousMethodException ex) {
            this.methodIsAmbiguous(ctx.start, ex);
            return null;
        }
        this.mapAst((AstNode)expr, ctx);
        return expr;
    }

    @Nullable
    private ExprNode getObjectInvokeExpr(ExprNode target, String methodName, List<KalangParser.ExpressionContext> argumentsCtx, ParserRuleContext ctx) {
        List<Object> argsList = this.visitAll(argumentsCtx);
        if (argsList.contains(null)) {
            return null;
        }
        ExprNode[] args = argsList.toArray(new ExprNode[argsList.size()]);
        return this.getObjectInvokeExpr(target, methodName, args, ctx);
    }

    @Nullable
    private ExprNode getObjectInvokeExpr(ExprNode target, String methodName, ExprNode[] args, ParserRuleContext ctx) {
        ExprNode expr;
        if ("<init>".equals(methodName)) {
            throw Exceptions.unexceptedException("Don't get constructor by this method.");
        }
        Type targetType = target.getType();
        if (!(targetType instanceof ObjectType)) {
            this.handleSyntaxError("class type required.", ctx);
            return null;
        }
        ObjectType targetClassType = (ObjectType)targetType;
        if (targetClassType.getNullable() == NullableKind.NULLABLE) {
            this.handleSyntaxError("expression may be null", ctx);
            return null;
        }
        MethodDescriptor[] methods = targetClassType.getMethodDescriptors(this.thisClazz, methodName, true, true);
        try {
            Type invokeType;
            List<MethodDescriptor> pluginMethods;
            if (methods.length <= 0 && !(pluginMethods = this.getImportedPluginMethod(methodName)).isEmpty()) {
                ClassNode pluginClass = pluginMethods.get(0).getMethodNode().getClassNode();
                LinkedList<ExprNode> newArgs = new LinkedList<ExprNode>();
                newArgs.add(target);
                newArgs.addAll(Arrays.asList(args));
                return this.getStaticInvokeExpr(new ClassReference(pluginClass), methodName, newArgs.toArray(new ExprNode[0]), ctx);
            }
            InvocationExpr.MethodSelection ms = ObjectInvokeExpr.applyMethod(targetClassType, methodName, args, methods);
            MethodDescriptor md = ms.selectedMethod;
            if (AstUtil.isStatic(md.getModifier())) {
                throw new MethodNotFoundException(methodName + " is static");
            }
            InvocationExpr invoke = this.onInvocationExpr(new ObjectInvokeExpr(target, md, ms.appliedArguments));
            expr = invoke.getMethod().getMethodNode().getType() instanceof GenericType ? ((invokeType = invoke.getType()) instanceof ObjectType ? new CastExpr(invokeType, invoke) : invoke) : invoke;
        }
        catch (MethodNotFoundException ex) {
            this.methodNotFound(ctx.start, targetType, methodName, args);
            expr = new UnknownInvocationExpr(target, methodName, args);
        }
        catch (AmbiguousMethodException ex) {
            this.methodIsAmbiguous(ctx.start, ex);
            return null;
        }
        this.mapAst((AstNode)expr, ctx);
        return expr;
    }

    private ExprNode getStaticInvokeExpr(ClassReference clazz, String methodName, List<KalangParser.ExpressionContext> argumentsCtx, ParserRuleContext ctx) {
        List<Object> argsList = this.visitAll(argumentsCtx);
        if (argsList.contains(null)) {
            return null;
        }
        ExprNode[] args = argsList.toArray(new ExprNode[argsList.size()]);
        return this.getStaticInvokeExpr(clazz, methodName, args, ctx);
    }

    private ExprNode getStaticInvokeExpr(ClassReference clazz, String methodName, ExprNode[] argumentsCtx, ParserRuleContext ctx) {
        ExprNode expr;
        ExprNode[] args = argumentsCtx;
        try {
            expr = this.onInvocationExpr(StaticInvokeExpr.create(clazz, methodName, args));
        }
        catch (MethodNotFoundException ex) {
            this.methodNotFound(ctx.start, clazz.getReferencedClassNode().name, methodName, args);
            expr = new UnknownInvocationExpr(clazz, methodName, args);
        }
        catch (AmbiguousMethodException ex) {
            this.methodIsAmbiguous(ctx.start, ex);
            return null;
        }
        this.mapAst((AstNode)expr, ctx);
        return expr;
    }

    @Override
    public AstNode visitInvokeExpr(KalangParser.InvokeExprContext ctx) {
        Object target = this.visit((ParseTree)ctx.target);
        if (target == null) {
            return null;
        }
        String mdName = ctx.Identifier().getText();
        String refKey = ctx.refKey.getText();
        if (refKey.equals(".")) {
            if (target instanceof ClassReference) {
                return this.getStaticInvokeExpr((ClassReference)target, mdName, ctx.params, (ParserRuleContext)ctx);
            }
            if (target instanceof ExprNode) {
                return this.getObjectInvokeExpr((ExprNode)target, mdName, ctx.params, (ParserRuleContext)ctx);
            }
            throw Exceptions.unexceptedValue(target);
        }
        if (refKey.equals("->")) {
            ExprNode[] invokeArgs = new ExprNode[3];
            ExprNode[] params = new ExprNode[ctx.params.size()];
            if (target instanceof ClassReference) {
                invokeArgs[0] = new ConstExpr(null);
            } else if (target instanceof ExprNode) {
                invokeArgs[0] = (ExprNode)target;
            }
            invokeArgs[1] = new ConstExpr(mdName);
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.visitExpression(ctx.params.get(i));
            }
            invokeArgs[2] = this.createInitializedArray(Types.getRootType(), params);
            ClassNode dispatcherAst = this.astLoader.getAst(MethodDispatcher.class.getName());
            if (dispatcherAst == null) {
                throw Exceptions.unexceptedException("Runtime library is required!");
            }
            return this.getStaticInvokeExpr(new ClassReference(dispatcherAst), "invokeMethod", invokeArgs, (ParserRuleContext)ctx);
        }
        if (refKey.equals("*.")) {
            if (!(target instanceof ExprNode)) {
                this.handleSyntaxError("expression required", ctx.expression);
                return null;
            }
            ExprNode targetExpr = (ExprNode)target;
            Type targetType = targetExpr.getType();
            if (!(targetType instanceof ArrayType)) {
                this.handleSyntaxError("array required", ctx.expression);
                return null;
            }
            LinkedList<Statement> stats = new LinkedList<Statement>();
            LocalVarNode varArrLen = this.declareTempLocalVar(Types.INT_TYPE);
            LocalVarNode varCounter = this.declareTempLocalVar(Types.INT_TYPE);
            stats.add(new VarDeclStmt(Arrays.asList(varArrLen, varCounter)));
            VarExpr varArrLenExpr = new VarExpr(varArrLen);
            VarExpr varCounterExpr = new VarExpr(varCounter);
            stats.add(new ExprStmt(new AssignExpr(varArrLenExpr, new ArrayLengthExpr(targetExpr))));
            stats.add(new ExprStmt(new AssignExpr(varCounterExpr, new ConstExpr(0))));
            CompareExpr conditionExpr = new CompareExpr(varCounterExpr, varArrLenExpr, "<");
            ElementExpr targetEleExpr = new ElementExpr(targetExpr, varCounterExpr);
            ExprNode invokeExpr = this.getObjectInvokeExpr((ExprNode)targetEleExpr, mdName, ctx.params, (ParserRuleContext)ctx);
            if (invokeExpr == null) {
                return null;
            }
            LocalVarNode varRet = this.declareTempLocalVar(Types.getArrayType(invokeExpr.getType()));
            VarExpr varRetExpr = new VarExpr(varRet);
            stats.add(new VarDeclStmt(varRet));
            stats.add(new ExprStmt(new AssignExpr(varRetExpr, new NewArrayExpr(invokeExpr.getType(), varArrLenExpr))));
            BlockStmt loopBody = this.newBlock();
            loopBody.statements.add(new ExprStmt(new AssignExpr(new ElementExpr(varRetExpr, varCounterExpr), invokeExpr)));
            this.popBlock();
            BlockStmt updateBs = this.newBlock();
            updateBs.statements.add(new ExprStmt(new AssignExpr(varCounterExpr, new MathExpr(varCounterExpr, new ConstExpr(1), "+"))));
            this.popBlock();
            LoopStmt loopStmt = new LoopStmt(conditionExpr, null, loopBody, updateBs);
            stats.add(loopStmt);
            return new MultiStmtExpr(stats, varRetExpr);
        }
        throw Exceptions.unexceptedException(refKey);
    }

    @Override
    public ExprNode visitGetFieldExpr(KalangParser.GetFieldExprContext ctx) {
        return this.createFieldExpr(ctx, null, OffsetRangeHelper.getOffsetRange(ctx));
    }

    @Override
    public UnaryExpr visitUnaryExpr(KalangParser.UnaryExprContext ctx) {
        String op = ctx.getChild(0).getText();
        UnaryExpr ue = new UnaryExpr(this.visitExpression(ctx.expression()), op);
        if (!this.semanticAnalyzer.validateUnaryExpr(ue)) {
            return null;
        }
        this.mapAst((AstNode)ue, ctx);
        return ue;
    }

    @Override
    public ElementExpr visitGetArrayElementExpr(KalangParser.GetArrayElementExprContext ctx) {
        ElementExpr ee = new ElementExpr(this.visitExpression(ctx.expression(0)), this.visitExpression(ctx.expression(1)));
        if (!this.semanticAnalyzer.validateElementExpr(ee)) {
            return null;
        }
        this.mapAst((AstNode)ee, ctx);
        return ee;
    }

    private boolean isDefindedId(String id) {
        return this.methodCtx != null && (this.methodCtx.getNamedLocalVar(id) != null || this.methodCtx.getNamedParameter(id) != null);
    }

    @Nullable
    private AstNode getNodeById(@Nonnull String name, @Nullable Token token) {
        ParameterNode paramNode;
        LocalVarNode var;
        LocalVarNode localVarNode = var = this.methodCtx != null ? this.methodCtx.getNamedLocalVar(name) : null;
        if (var != null) {
            VarExpr ve = new VarExpr(var, this.methodCtx.getVarObjectType(var));
            if (token != null) {
                this.mapAst((AstNode)ve, token);
            }
            return ve;
        }
        ParameterNode parameterNode = paramNode = this.methodCtx == null ? null : this.methodCtx.getNamedParameter(name);
        if (paramNode != null) {
            ParameterExpr ve = new ParameterExpr(paramNode, this.methodCtx.getVarObjectType(paramNode));
            if (token != null) {
                this.mapAst((AstNode)ve, token);
            }
            return ve;
        }
        ExprNode fieldExpr = this.getObjectFieldExpr(new ThisExpr(this.getThisType()), name, ParserRuleContext.EMPTY);
        if (fieldExpr == null) {
            fieldExpr = this.getStaticFieldExpr(new ClassReference(this.thisClazz), name, ParserRuleContext.EMPTY);
        }
        if (fieldExpr != null) {
            return fieldExpr;
        }
        ExprNode outerClassInstanceExpr = this.getOuterClassInstanceExpr(new ThisExpr(this.getThisType()));
        while (outerClassInstanceExpr != null) {
            ExprNode fe = this.getObjectFieldExpr(outerClassInstanceExpr, name, ParserRuleContext.EMPTY);
            if (fe == null) {
                fe = this.getStaticFieldExpr(new ClassReference(this.thisClazz), name, ParserRuleContext.EMPTY);
            }
            if (fe != null) {
                return fe;
            }
            outerClassInstanceExpr = this.getOuterClassInstanceExpr(outerClassInstanceExpr);
        }
        String resolvedTypeName = this.compilationUnit.getTypeNameResolver().resolve(name, this.topClass, this.thisClazz);
        if (resolvedTypeName != null) {
            ClassReference clsRef = new ClassReference(this.requireAst(resolvedTypeName, token));
            if (token != null) {
                this.mapAst((AstNode)clsRef, token);
            }
            return clsRef;
        }
        return null;
    }

    @Override
    public ConstExpr visitLiteral(KalangParser.LiteralContext ctx) {
        return this.parseLiteral(ctx, null);
    }

    @Override
    public AstNode visitImportDecl(KalangParser.ImportDeclContext ctx) {
        boolean isStaticImport;
        String name = ctx.name.getText();
        String delim = ctx.delim.getText();
        String prefix = "";
        boolean bl = isStaticImport = ctx.importMode != null;
        if ("\\".equals(delim)) {
            boolean relative = ctx.root == null || ctx.root.getText().length() == 0;
            String packageName = this.getPackageName();
            if (relative && packageName.length() > 0) {
                prefix = packageName + ".";
            }
        }
        if (ctx.path != null) {
            for (Token p : ctx.path) {
                prefix = prefix + p.getText() + ".";
            }
        }
        TypeNameResolver typeNameResolver = this.compilationUnit.getTypeNameResolver();
        if (name.equals("*")) {
            String location = prefix.substring(0, prefix.length() - 1);
            if (isStaticImport) {
                ClassNode locationCls = this.requireAst(location, ctx.stop);
                if (locationCls == null) {
                    return null;
                }
                this.importStaticMember(locationCls, null);
            } else {
                typeNameResolver.importPackage(location);
            }
        } else {
            String key = name;
            if (ctx.alias != null) {
                key = ctx.alias.getText();
            }
            if (isStaticImport) {
                String location = prefix.substring(0, prefix.length() - 1);
                ClassNode locationCls = this.requireAst(location, ctx.stop);
                if (locationCls == null) {
                    return null;
                }
                this.importStaticMember(locationCls, name);
            } else {
                typeNameResolver.importClass(prefix + name, key);
            }
        }
        return null;
    }

    @Override
    public AstNode visitQualifiedName(KalangParser.QualifiedNameContext ctx) {
        return null;
    }

    @Override
    public AstNode visitNewExpr(KalangParser.NewExprContext ctx) {
        ObjectType clsType = this.parseClassType(ctx.classType());
        if (clsType == null) {
            return null;
        }
        List<Object> paramExprsList = this.visitAll(ctx.params);
        if (paramExprsList.contains(null)) {
            return null;
        }
        ExprNode[] params = paramExprsList.toArray(new ExprNode[paramExprsList.size()]);
        LinkedList<ExprNode> paramList = new LinkedList<ExprNode>(Arrays.asList(params));
        try {
            if (this.isNonStaticInnerClass(clsType.getClassNode())) {
                paramList.add(0, new ThisExpr(this.getThisType()));
            }
            params = paramList.toArray(new ExprNode[paramList.size()]);
            NewObjectExpr newExpr = new NewObjectExpr(clsType, params, this.thisClazz);
            this.mapAst((AstNode)newExpr, ctx);
            return newExpr;
        }
        catch (MethodNotFoundException ex) {
            this.methodNotFound(ctx.classType().rawClass, clsType.getName(), "<init>", params);
            return null;
        }
        catch (AmbiguousMethodException ex) {
            this.methodIsAmbiguous(ctx.classType().rawClass, ex);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public AstNode visitCastExpr(KalangParser.CastExprContext ctx) {
        void var2_7;
        ExprNode expr = this.visitExpression(ctx.expression());
        Type toType = this.parseType(ctx.type());
        Type fromType = expr.getType();
        if (fromType instanceof PrimitiveType) {
            if (!(toType instanceof PrimitiveType)) {
                this.handleSyntaxError("unable to cast primitive type to class type", ctx);
                return null;
            }
            PrimitiveCastExpr primitiveCastExpr = new PrimitiveCastExpr((PrimitiveType)fromType, (PrimitiveType)toType, expr);
        } else {
            if (toType instanceof PrimitiveType) {
                this.handleSyntaxError("unable to cast class type to primitive type", ctx);
                return null;
            }
            CastExpr castExpr = new CastExpr(toType, expr);
        }
        this.mapAst((AstNode)var2_7, ctx);
        return var2_7;
    }

    @Override
    public AstNode visitTryStat(KalangParser.TryStatContext ctx) {
        BlockStmt tryExecStmt = this.requireBlock(ctx.exec);
        boolean tryReturned = this.methodCtx.returned;
        LinkedList<CatchBlock> tryCatchBlocks = new LinkedList<CatchBlock>();
        if (ctx.catchTypes != null) {
            for (int i = 0; i < ctx.catchTypes.size(); ++i) {
                this.methodCtx.newFrame();
                this.methodCtx.returned = false;
                String vName = ctx.catchVarNames.get(i).getText();
                String vType = ctx.catchTypes.get(i).getText();
                LocalVarNode vo = this.declareLocalVar(vName, this.requireClassType(vType, ctx.catchTypes.get((int)i).start), 16, ctx);
                if (vo == null) {
                    return null;
                }
                BlockStmt catchExecStmt = this.requireBlock(ctx.catchExec.get(i));
                CatchBlock catchStmt = new CatchBlock(vo, catchExecStmt);
                tryCatchBlocks.add(catchStmt);
                this.methodCtx.returned = this.methodCtx.returned && tryReturned;
                this.methodCtx.popFrame();
            }
        }
        BlockStmt tryFinallyStmt = null;
        if (ctx.finallyExec != null) {
            tryFinallyStmt = this.requireBlock(ctx.finallyExec);
        }
        TryStmt tryStmt = new TryStmt(tryExecStmt, tryCatchBlocks, tryFinallyStmt);
        this.mapAst((AstNode)tryStmt, ctx);
        return tryStmt;
    }

    @Override
    public Statement visitLocalVarDecl(KalangParser.LocalVarDeclContext ctx) {
        MultiStmt ms = new MultiStmt();
        for (KalangParser.VarDeclContext v : ctx.varDecl()) {
            KalangParser.TypeContext varType = v.varType;
            Type exceptedType = varType == null ? null : this.parseType(varType);
            ExprNode initExpr = null;
            KalangParser.ExpressionContext initExprContext = v.expression();
            if (initExprContext != null) {
                initExpr = initExprContext instanceof KalangParser.LiteralExprContext ? this.parseLiteral(((KalangParser.LiteralExprContext)initExprContext).literal(), exceptedType) : this.visitExpression(initExprContext);
            }
            VarInfo varInfo = this.varDecl(v, initExpr == null ? Types.getRootType() : initExpr.getType());
            LocalVarNode localVar = this.declareLocalVar(varInfo.name, varInfo.type, varInfo.modifier, ctx);
            if (localVar == null) {
                return null;
            }
            VarDeclStmt vds = new VarDeclStmt(localVar);
            ms.statements.add(vds);
            if (initExpr != null) {
                AssignExpr assignExpr = new AssignExpr(new VarExpr(localVar), initExpr);
                this.mapAst((AstNode)assignExpr, v);
                ms.statements.add(new ExprStmt(assignExpr));
            }
            this.mapAst((AstNode)localVar, ctx);
        }
        return ms;
    }

    @Override
    public AstNode visitIdentifierExpr(KalangParser.IdentifierExprContext ctx) {
        String name = ctx.Identifier().getText();
        AstNode expr = this.getNodeById(name, ctx.Identifier().getSymbol());
        if (expr == null) {
            this.handleSyntaxError(name + " is undefined!", ctx);
            return null;
        }
        this.mapAst(expr, ctx);
        return expr;
    }

    @Override
    public AstNode visitLiteralExpr(KalangParser.LiteralExprContext ctx) {
        return this.visitLiteral(ctx.literal());
    }

    @Override
    public AstNode visitParenExpr(KalangParser.ParenExprContext ctx) {
        return this.visitExpression(ctx.expression());
    }

    public void visitBlockStmt(KalangParser.StatContext[] stats, BlockStmt blockStmt) {
        this.methodCtx.newFrame();
        if (stats == null) {
            return;
        }
        for (KalangParser.StatContext s : stats) {
            blockStmt.statements.add(this.visitStat(s));
        }
        this.methodCtx.popFrame();
    }

    @Override
    public AstNode visitBlockStmt(KalangParser.BlockStmtContext ctx) {
        BlockStmt bs = this.newBlock();
        List<KalangParser.StatContext> stats = ctx.stat();
        if (stats != null) {
            this.visitBlockStmt(stats.toArray(new KalangParser.StatContext[stats.size()]), bs);
        }
        this.mapAst((AstNode)bs, ctx);
        this.popBlock();
        return bs;
    }

    @Override
    public AstNode visitVarModifier(KalangParser.VarModifierContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AstNode visitSelfRefExpr(KalangParser.SelfRefExprContext ctx) {
        ExprNode expr;
        String key = ctx.ref.getText();
        if (key.equals("this")) {
            expr = new ThisExpr(this.getThisType());
        } else if (key.equals("super")) {
            expr = new SuperExpr(this.thisClazz);
        } else {
            throw Exceptions.unknownValue(key);
        }
        this.mapAst((AstNode)expr, ctx);
        return expr;
    }

    @Override
    public Object visitPrimitiveType(KalangParser.PrimitiveTypeContext ctx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IncrementExpr visitIncExpr(KalangParser.IncExprContext ctx) {
        return this.getIncrementExpr(ctx.expression(), ctx.op.getText(), false);
    }

    @Override
    public IncrementExpr visitPreIncExpr(KalangParser.PreIncExprContext ctx) {
        return this.getIncrementExpr(ctx.expression(), ctx.op.getText(), true);
    }

    public IncrementExpr getIncrementExpr(KalangParser.ExpressionContext expressionContext, String op, boolean isPrefix) {
        ExprNode expr = this.visitExpression(expressionContext);
        if (!(expr instanceof AssignableExpr)) {
            this.handleSyntaxError("require assignable expression", expressionContext);
            return null;
        }
        boolean isDesc = op.equals("--");
        return new IncrementExpr((AssignableExpr)expr, isDesc, isPrefix);
    }

    private ExprNode requireCastable(ExprNode expr1, Type fromType, Type toType, Token token) {
        ExprNode expr = BoxUtil.assign(expr1, fromType, toType);
        if (expr == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "unable to cast " + fromType + " to " + toType, token);
        }
        return expr;
    }

    protected ExprNode getObjectFieldLikeExpr(ExprNode expr, String fieldName, @Nullable ParserRuleContext rule) {
        ExprNode ret;
        Type type = expr.getType();
        if (!(type instanceof ObjectType)) {
            this.handleSyntaxError("unsupported type", rule == null ? ParserRuleContext.EMPTY : rule);
            return null;
        }
        ObjectType exprType = (ObjectType)type;
        if (exprType instanceof ArrayType && fieldName.equals("length")) {
            ret = new ArrayLengthExpr(expr);
        } else {
            try {
                ret = ObjectFieldExpr.create(expr, fieldName, this.thisClazz);
            }
            catch (FieldNotFoundException ex) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "field not found:" + fieldName, rule);
                ret = new UnknownFieldExpr(expr, exprType.getClassNode(), fieldName);
            }
        }
        if (rule != null) {
            this.mapAst((AstNode)ret, rule);
        }
        return ret;
    }

    protected AssignableExpr getStaticFieldExpr(ClassReference clazz, String fieldName, ParserRuleContext rule) {
        StaticFieldExpr ret;
        try {
            ret = StaticFieldExpr.create(clazz, fieldName, this.thisClazz);
        }
        catch (FieldNotFoundException ex) {
            return null;
        }
        this.mapAst((AstNode)ret, rule);
        return ret;
    }

    @Override
    public Object visitErrorousStat(KalangParser.ErrorousStatContext ctx) {
        this.handleSyntaxError("missing ';'", ctx, ctx.start, ctx.stop);
        return null;
    }

    @Override
    public Object visitErrorousMemberExpr(KalangParser.ErrorousMemberExprContext ctx) {
        this.handleSyntaxError("identifier excepted", ctx, ctx.stop, ctx.stop);
        return null;
    }

    @Override
    public Object visitInstanceofExpr(KalangParser.InstanceofExprContext ctx) {
        ExprNode expr = this.visitExpression(ctx.expression());
        Token ts = ctx.Identifier().getSymbol();
        AstNode tnode = this.getNodeById(ts.getText(), ts);
        if (tnode instanceof ClassReference) {
            InstanceOfExpr ie = new InstanceOfExpr(expr, (ClassReference)tnode);
            this.mapAst((AstNode)ie, ctx);
            return ie;
        }
        this.handleSyntaxError("unsupported type", ts);
        return null;
    }

    @Override
    public Object visitScriptDef(KalangParser.ScriptDefContext ctx) {
        throw Exceptions.unexceptedException("");
    }

    @Override
    public Object visitCompileOption(KalangParser.CompileOptionContext ctx) {
        return null;
    }

    @Override
    public Object visitLambdaExpr(KalangParser.LambdaExprContext ctx) {
        ObjectType lambdaType;
        KalangParser.LambdaTypeContext lambdaTypeCtx = ctx.lambdaType();
        ObjectType functionType = null;
        if (lambdaTypeCtx != null && (lambdaType = this.visitLambdaType(lambdaTypeCtx)) instanceof FunctionType) {
            functionType = (FunctionType)lambdaType;
        }
        ObjectType type = functionType != null ? functionType : Types.requireClassType(Types.FUNCTION_CLASS_NAME);
        LocalVarNode tmpVar = this.declareTempLocalVar(type);
        LambdaExpr ms = new LambdaExpr(tmpVar, (FunctionType)functionType);
        HashMap<String, VarObject> accessibleVars = new HashMap<String, VarObject>();
        for (VarTable<String, LocalVarNode> vtb = this.methodCtx.varTables; vtb != null; vtb = vtb.getParent()) {
            for (Map.Entry<String, LocalVarNode> v : vtb.vars().entrySet()) {
                String string = v.getKey();
                LocalVarNode var = v.getValue();
                if (accessibleVars.containsKey(string)) continue;
                accessibleVars.put(string, var);
            }
        }
        ParameterNode[] paramNodes = this.methodCtx.method.getParameters();
        for (ParameterNode p : paramNodes) {
            String name = p.getName();
            if (accessibleVars.containsKey(name)) continue;
            accessibleVars.put(name, p);
        }
        for (Map.Entry entry : accessibleVars.entrySet()) {
            ms.putAccessibleVarObject((String)entry.getKey(), (VarObject)entry.getValue());
        }
        if (functionType != null) {
            this.createLambdaNode((ClassType)functionType, ms, ctx);
        } else {
            this.lambdaExprCtxMap.put(ms, ctx);
        }
        return ms;
    }

    @Nullable
    private ExprNode getOuterClassInstanceExpr(ExprNode expr) {
        return this.getObjectFieldExpr(expr, "this$0", null);
    }

    @Override
    public Object visitClassDef(KalangParser.ClassDefContext ctx) {
        throw Exceptions.unexceptedException("");
    }

    @Override
    @Nullable
    public AnnotationNode visitAnnotation(KalangParser.AnnotationContext ctx) {
        ClassNode anType = this.requireAst(ctx.annotationType);
        if (anType == null) {
            return null;
        }
        List<Token> vk = ctx.annotationValueKey;
        KalangParser.LiteralContext dv = ctx.annotationDefaultValue;
        AnnotationNode anNode = new AnnotationNode(anType);
        if (vk != null && vk.size() > 0) {
            List<KalangParser.LiteralContext> anValues = ctx.annotationValue;
            int ksize = vk.size();
            for (int i = 0; i < ksize; ++i) {
                String kname = vk.get(i).getText();
                ConstExpr value = this.visitLiteral(anValues.get(i));
                anNode.values.put(kname, value);
            }
        } else if (dv != null) {
            ConstExpr defaultValue = this.visitLiteral(dv);
            anNode.values.put("value", defaultValue);
        }
        if (!this.semanticAnalyzer.validateAnnotation(anNode)) {
            return null;
        }
        return anNode;
    }

    private BlockStmt requireBlock(ParserRuleContext stmt) {
        if (stmt instanceof KalangParser.BlockStmtContext) {
            return (BlockStmt)this.visit((ParseTree)stmt);
        }
        BlockStmt bs = this.newBlock();
        bs.statements.add((Statement)this.visit((ParseTree)stmt));
        this.popBlock();
        return bs;
    }

    @Override
    public Object visitClassType(KalangParser.ClassTypeContext ctx) {
        return null;
    }

    @Override
    public Object visitParameterizedElementType(KalangParser.ParameterizedElementTypeContext ctx) {
        return null;
    }

    @Override
    public Object visitWildcardType(KalangParser.WildcardTypeContext ctx) {
        return null;
    }

    public ObjectType getThisType() {
        return Types.getClassType(this.thisClazz);
    }

    @Nonnull
    private LocalVarNode declareTempLocalVar(Type type) {
        LocalVarNode var = this.declareLocalVar(null, type, 0, ParserRuleContext.EMPTY);
        if (var == null) {
            throw Exceptions.unexceptedValue(var);
        }
        return var;
    }

    @Nullable
    private LocalVarNode declareLocalVar(String name, Type type, int modifier, ParserRuleContext ctx) {
        LocalVarNode localVarNode = new LocalVarNode(type, name, modifier);
        ParameterNode param = this.methodCtx.getNamedParameter(name);
        LocalVarNode var = this.methodCtx.getNamedLocalVar(name);
        if (param != null || var != null) {
            this.handleSyntaxError("variable is defined", ctx);
            return null;
        }
        if (name != null) {
            this.methodCtx.varTables.put(name, localVarNode);
        }
        return localVarNode;
    }

    @Override
    public Object visitForEachStat(KalangParser.ForEachStatContext ctx) {
        LoopStmt loopStmt;
        TerminalNode varId;
        BlockStmt block = this.newBlock();
        ExprNode expr = this.visitExpression(ctx.expression());
        Type exprType = expr.getType();
        List<TerminalNode> idsCtx = ctx.Identifier();
        VarExpr indexVarExpr = null;
        if (idsCtx.size() == 1) {
            varId = idsCtx.get(0);
        } else {
            TerminalNode indexId = idsCtx.get(0);
            LocalVarNode indexVar = this.declareLocalVar(indexId.getText(), Types.INT_TYPE, 16, ctx);
            if (indexVar == null) {
                return null;
            }
            block.statements.add(new VarDeclStmt(indexVar));
            indexVarExpr = new VarExpr(indexVar);
            varId = idsCtx.get(1);
        }
        if (exprType instanceof ArrayType) {
            LocalVarNode localVarNode = this.declareLocalVar(varId.getText(), ((ArrayType)exprType).getComponentType(), 16, ctx);
            if (localVarNode == null) {
                return null;
            }
            VarExpr localVariable = new VarExpr(localVarNode);
            block.statements.add(new VarDeclStmt(localVarNode));
            LocalVarNode lenVar = this.declareTempLocalVar(Types.INT_TYPE);
            LocalVarNode counterVar = this.declareTempLocalVar(Types.INT_TYPE);
            block.statements.add(new VarDeclStmt(lenVar));
            block.statements.add(new VarDeclStmt(counterVar));
            VarExpr counterVarExpr = new VarExpr(counterVar);
            VarExpr lenVarExpr = new VarExpr(lenVar);
            block.statements.add(new ExprStmt(new AssignExpr(lenVarExpr, new ArrayLengthExpr(expr))));
            block.statements.add(new ExprStmt(new AssignExpr(counterVarExpr, new ConstExpr(0))));
            CompareExpr cnd = new CompareExpr(counterVarExpr, lenVarExpr, "<");
            BlockStmt loopBody = this.newBlock();
            loopBody.statements.add(new ExprStmt(new AssignExpr(localVariable, new ElementExpr(expr, counterVarExpr))));
            if (indexVarExpr != null) {
                loopBody.statements.add(new ExprStmt(new AssignExpr(indexVarExpr, counterVarExpr)));
            }
            loopBody.statements.add(this.visitStat(ctx.stat()));
            this.popBlock();
            BlockStmt updateBs = this.newBlock();
            updateBs.statements.add(new ExprStmt(new AssignExpr(counterVarExpr, new MathExpr(counterVarExpr, new ConstExpr(1), "+"))));
            this.popBlock();
            loopStmt = new LoopStmt(cnd, null, loopBody, updateBs);
        } else {
            ObjectType iterType = Types.getIterableClassType();
            if (iterType.isAssignableFrom(exprType)) {
                ObjectInvokeExpr nextInvokeExpr;
                ObjectInvokeExpr cnd;
                ObjectInvokeExpr getIterableExpr;
                try {
                    getIterableExpr = ObjectInvokeExpr.create(expr, "iterator", null);
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex) {
                    throw Exceptions.unexceptedException(ex);
                }
                LocalVarNode iterableVarNode = this.declareTempLocalVar(getIterableExpr.getType());
                block.statements.add(new VarDeclStmt(iterableVarNode));
                VarExpr iterableVarExpr = new VarExpr(iterableVarNode);
                block.statements.add(new ExprStmt(new AssignExpr(iterableVarExpr, getIterableExpr)));
                if (indexVarExpr != null) {
                    block.statements.add(new ExprStmt(new AssignExpr(indexVarExpr, new ConstExpr(0))));
                }
                try {
                    cnd = ObjectInvokeExpr.create(iterableVarExpr, "hasNext", null);
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex) {
                    throw Exceptions.unexceptedException(ex);
                }
                BlockStmt loopBody = this.newBlock();
                try {
                    nextInvokeExpr = ObjectInvokeExpr.create(iterableVarExpr, "next", null);
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex) {
                    throw Exceptions.unexceptedException(ex);
                }
                LocalVarNode localVarNode = this.declareLocalVar(varId.getText(), nextInvokeExpr.getType(), 16, ctx);
                if (localVarNode == null) {
                    return null;
                }
                VarExpr localVariable = new VarExpr(localVarNode);
                loopBody.statements.add(new VarDeclStmt(localVarNode));
                loopBody.statements.add(new ExprStmt(new AssignExpr(localVariable, new CastExpr(localVariable.getType(), nextInvokeExpr))));
                loopBody.statements.add(this.visitStat(ctx.stat()));
                this.popBlock();
                BlockStmt updateBs = this.newBlock();
                if (indexVarExpr != null) {
                    updateBs.statements.add(new ExprStmt(new AssignExpr(indexVarExpr, new MathExpr(indexVarExpr, new ConstExpr(1), "+"))));
                }
                this.popBlock();
                loopStmt = new LoopStmt(cnd, null, loopBody, updateBs);
            } else {
                this.handleSyntaxError("require array type or iterable type", ctx.expression());
                loopStmt = null;
            }
        }
        this.popBlock();
        if (loopStmt != null) {
            block.statements.add(loopStmt);
        }
        return block;
    }

    @Override
    public Object visitArrayExpr(KalangParser.ArrayExprContext ctx) {
        KalangParser.TypeContext typeCtx;
        ExprNode[] initExprs;
        List<KalangParser.ExpressionContext> exprCtx = ctx.expression();
        if (exprCtx != null) {
            initExprs = new ExprNode[exprCtx.size()];
            for (int i = 0; i < initExprs.length; ++i) {
                initExprs[i] = this.visitExpression(exprCtx.get(i));
            }
        } else {
            initExprs = new ExprNode[]{};
        }
        Type type = (typeCtx = ctx.type()) != null ? this.parseType(typeCtx) : TypeUtil.getCommonType(AstUtil.getExprTypes(initExprs));
        for (int i = 0; i < initExprs.length; ++i) {
            if (exprCtx == null) {
                throw Exceptions.unexceptedValue(exprCtx);
            }
            initExprs[i] = this.requireCastable(initExprs[i], initExprs[i].getType(), type, exprCtx.get(i).getStart());
            if (initExprs[i] != null) continue;
            return null;
        }
        ExprNode arrExpr = this.createInitializedArray(type, initExprs);
        this.mapAst((AstNode)arrExpr, ctx);
        return arrExpr;
    }

    @Override
    public Object visitInterpolationExpr(KalangParser.InterpolationExprContext ctx) {
        List children = ctx.children;
        ExprNode[] exprs = new ExprNode[children.size()];
        Token[] exprTokens = new Token[children.size()];
        for (int i = 0; i < exprs.length; ++i) {
            ParseTree c = (ParseTree)children.get(i);
            if (c instanceof TerminalNode) {
                String text;
                Token token = ((TerminalNode)c).getSymbol();
                int t = token.getType();
                String rawText = c.getText();
                switch (t) {
                    case 113: {
                        text = rawText.substring(1, rawText.length() - 2);
                        break;
                    }
                    case 124: {
                        text = rawText;
                        break;
                    }
                    case 71: 
                    case 122: 
                    case 123: {
                        text = "";
                        break;
                    }
                    default: {
                        throw Exceptions.unexceptedValue(t);
                    }
                }
                exprs[i] = new ConstExpr(StringLiteralUtil.parse(text));
                exprTokens[i] = token;
                continue;
            }
            if (c instanceof KalangParser.ExpressionContext) {
                ExprNode expr = this.visitExpression((KalangParser.ExpressionContext)c);
                if (expr == null) {
                    return null;
                }
                exprs[i] = expr;
                exprTokens[i] = ((KalangParser.ExpressionContext)c).getStart();
                continue;
            }
            throw Exceptions.unexceptedValue(c);
        }
        return this.concatExpressionsToStringExpr(exprs, exprTokens);
    }

    @Override
    public Object visitBitShiftExpr(KalangParser.BitShiftExprContext ctx) {
        String op;
        if (ctx.left != null) {
            op = "<<";
            Token opStart = ctx.left;
        } else if (ctx.right != null) {
            op = ">>";
            Token opStart = ctx.right;
        } else if (ctx.uright != null) {
            op = ">>>";
            Token opStart = ctx.uright;
        } else {
            throw Exceptions.unexceptedValue((Object)ctx);
        }
        return this.createBinaryExpr(op, ctx.expression(0), ctx.expression(1), ctx);
    }

    public ExprNode createInitializedArray(Type type, ExprNode[] exprs) {
        NewArrayExpr ae = new NewArrayExpr(type, new ConstExpr(exprs.length));
        if (exprs.length > 0) {
            Statement[] initStmts = new Statement[exprs.length + 2];
            LocalVarNode local = this.declareTempLocalVar(ae.getType());
            initStmts[0] = new VarDeclStmt(local);
            VarExpr arrVar = new VarExpr(local);
            initStmts[1] = new ExprStmt(new AssignExpr(arrVar, ae));
            for (int i = 0; i < exprs.length; ++i) {
                initStmts[i + 2] = new ExprStmt(new AssignExpr(new ElementExpr(arrVar, new ConstExpr(i)), exprs[i]));
            }
            return new MultiStmtExpr(Arrays.asList(initStmts), arrVar);
        }
        return ae;
    }

    public DiagnosisReporter getDiagnosisReporter() {
        return this.diagnosisReporter;
    }

    public void importStaticMember(ClassNode classNode, @Nullable String name) {
        if (name != null && !name.isEmpty()) {
            this.compilationUnit.staticImportMembers.put(name, classNode);
        } else {
            this.compilationUnit.staticImportPaths.add(classNode);
        }
    }

    private boolean isInConstructor() {
        return "<init>".equals(this.methodCtx.method.getName());
    }

    @Nullable
    private ExprNode requireImplicitCast(Type resultType, @Nullable ExprNode expr, OffsetRange offset) {
        if (expr == null) {
            return null;
        }
        Type exprType = expr.getType();
        ExprNode result = BoxUtil.assign(expr, exprType, resultType);
        if (result == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, String.format("%s cannot be converted to %s", exprType, resultType), offset);
            return null;
        }
        return result;
    }

    private ExprNode createBinaryBoolOperateExpr(ExprNode expr1, ExprNode expr2, String op) {
        Type type1 = expr1.getType();
        Type type2 = expr2.getType();
        boolean isPrimitive1 = type1 instanceof PrimitiveType;
        boolean isPrimitive2 = type2 instanceof PrimitiveType;
        PrimitiveType numPriType1 = isPrimitive1 ? (PrimitiveType)type1 : Types.getPrimitiveType((ObjectType)type1);
        PrimitiveType numPriType2 = isPrimitive2 ? (PrimitiveType)type2 : Types.getPrimitiveType((ObjectType)type2);
        expr1 = this.requireImplicitCast(numPriType1, expr1, expr1.offset);
        expr2 = this.requireImplicitCast(numPriType2, expr2, expr2.offset);
        if (expr1 == null || expr2 == null) {
            return null;
        }
        return this.constructBinaryExpr(expr1, expr2, op);
    }

    private ExprNode createBinaryMathExpr(ExprNode expr1, ExprNode expr2, String op) {
        Type type1 = expr1.getType();
        Type type2 = expr2.getType();
        boolean isPrimitive1 = type1 instanceof PrimitiveType;
        boolean isPrimitive2 = type2 instanceof PrimitiveType;
        PrimitiveType numPriType1 = isPrimitive1 ? (PrimitiveType)type1 : Types.getPrimitiveType((ObjectType)type1);
        PrimitiveType numPriType2 = isPrimitive2 ? (PrimitiveType)type2 : Types.getPrimitiveType((ObjectType)type2);
        PrimitiveType resultType = MathType.getType(numPriType1, numPriType2);
        expr1 = this.requireImplicitCast(resultType, this.requireImplicitCast(numPriType1, expr1, expr1.offset), expr1.offset);
        expr2 = this.requireImplicitCast(resultType, this.requireImplicitCast(numPriType2, expr2, expr2.offset), expr2.offset);
        if (expr1 == null || expr2 == null) {
            return null;
        }
        return this.constructBinaryExpr(expr1, expr2, op);
    }

    private void checkAndBuildInterfaceMethods(ClassNode clazz) {
        for (ClassNode c : clazz.classes) {
            this.checkAndBuildInterfaceMethods(c);
        }
        if (Modifier.isAbstract(clazz.modifier)) {
            return;
        }
        Map<MethodDescriptor, MethodNode> implementationMap = InterfaceUtil.getImplementationMap(clazz);
        for (Map.Entry<MethodDescriptor, MethodNode> e : implementationMap.entrySet()) {
            MethodDescriptor interfaceMethod = e.getKey();
            MethodNode implementedMethod = e.getValue();
            if (implementedMethod != null || !Modifier.isAbstract(interfaceMethod.getModifier())) continue;
            String msg = String.format("please override abstract method %s in %s", interfaceMethod.toString(), interfaceMethod.getMethodNode().getClassNode().name);
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, msg, clazz.offset);
        }
    }

    private ClassNode createFunctionClassNode(ClassType type, LambdaExpr lambdaExpr, KalangParser.LambdaExprContext ctx) {
        Type[] typeArguments = type.getTypeArguments();
        Type returnType = typeArguments[0];
        Type[] paramTypes = new Type[typeArguments.length - 1];
        if (paramTypes.length > 0) {
            System.arraycopy(typeArguments, 1, paramTypes, 0, paramTypes.length);
        }
        String lambdaName = this.thisClazz.name + "$" + ++this.anonymousClassCounter;
        ClassNode oldClass = this.thisClazz;
        MethodContext oldMethodCtx = this.methodCtx;
        ClassNode classNode = this.thisClazz = new ClassNode(lambdaName, 1);
        classNode.setSuperType(Types.getRootType());
        if (!Modifier.isStatic(this.methodCtx.method.getModifier())) {
            FieldNode outerClassField = classNode.createField(Types.getClassType(oldClass), "this$0", 1);
            ObjectFieldExpr outerFieldExpr = new ObjectFieldExpr(new VarExpr(lambdaExpr.getReferenceVar()), outerClassField);
            lambdaExpr.addStatement(new ExprStmt(new AssignExpr(outerFieldExpr, new ThisExpr(oldClass))));
        }
        Map<String, VarObject> accessibleVars = lambdaExpr.getAccessibleVarObjects();
        for (Map.Entry<String, VarObject> v : accessibleVars.entrySet()) {
            AssignExpr assignExpr;
            String name = v.getKey();
            VarObject var = v.getValue();
            FieldNode f = classNode.createField(var.getType(), name, 0);
            ObjectFieldExpr fieldExpr = new ObjectFieldExpr(new VarExpr(lambdaExpr.getReferenceVar()), f);
            if (var instanceof LocalVarNode) {
                assignExpr = new AssignExpr(fieldExpr, new VarExpr((LocalVarNode)var));
            } else if (var instanceof ParameterNode) {
                assignExpr = new AssignExpr(fieldExpr, new ParameterExpr((ParameterNode)var));
            } else {
                throw Exceptions.unexceptedValue(var);
            }
            lambdaExpr.addStatement(new ExprStmt(assignExpr));
        }
        MethodNode methodNode = classNode.createMethodNode(returnType, "call", 1);
        this.enterMethod(methodNode);
        List<Token> lambdaParams = ctx.lambdaParams;
        int lambdaParamsCount = ctx.lambdaParams.size();
        if (paramTypes.length < lambdaParams.size()) {
            String msg = String.format("expected %d parameters but got %d", paramTypes.length, lambdaParams.size());
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, msg, ctx);
            return null;
        }
        for (int i = 0; i < lambdaParamsCount; ++i) {
            Type pt = paramTypes[i];
            methodNode.createParameter(pt, ctx.lambdaParams.get(i).getText());
        }
        ClassType interfaceType = Types.getFunctionType(returnType, MethodUtil.getParameterTypes(methodNode), NullableKind.NONNULL);
        classNode.addInterface(interfaceType);
        for (int i = lambdaParamsCount + 1; i <= FunctionClasses.CLASSES.length - 1; ++i) {
            LambdaUtil.createBridgeRunMethod(classNode, methodNode, paramTypes, i);
        }
        AstUtil.createEmptyConstructor(classNode);
        List<KalangParser.StatContext> stats = ctx.stat();
        BlockStmt bs = this.newBlock();
        for (KalangParser.StatContext s : stats) {
            Statement statement = this.visitStat(s);
            if (statement == null) continue;
            bs.statements.add(statement);
        }
        if (returnType.equals(Types.getVoidClassType())) {
            bs.statements.add(new ReturnStmt(new ConstExpr(null)));
            this.methodCtx.returned = true;
        }
        methodNode.getBody().statements.add(bs);
        this.checkMethod();
        this.thisClazz = oldClass;
        this.methodCtx = oldMethodCtx;
        return classNode;
    }

    private void enterMethod(MethodNode method) {
        this.methodCtx = new MethodContext(this.thisClazz, method);
        this.methodCtx.returned = false;
    }

    private void checkMethod() {
        MethodNode m = this.methodCtx.method;
        boolean needReturn = m.getType() != null && !m.getType().equals(Types.VOID_TYPE);
        BlockStmt mbody = m.getBody();
        if (mbody != null && needReturn && !this.methodCtx.returned) {
            ConstExpr defaultVal = m.getDefaultReturnValue();
            if (defaultVal != null) {
                mbody.statements.add(new ReturnStmt(defaultVal));
            } else {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "Missing return statement in method:" + MethodUtil.toString(this.methodCtx.method), m.offset);
            }
        }
        new InitializationAnalyzer(this.compilationUnit, this.astLoader).check(this.thisClazz, m);
    }

    private void processConstructor(ClassNode clazz) {
        this.thisClazz = clazz;
        this.processConstructor();
        for (ClassNode c : this.thisClazz.classes) {
            this.processConstructor(c);
        }
    }

    private void processConstructor() {
        MethodNode[] methods;
        for (MethodNode m : methods = this.thisClazz.getDeclaredMethodNodes()) {
            BlockStmt mbody = m.getBody();
            if (!AstUtil.isConstructor(m)) continue;
            List<Statement> bodyStmts = mbody.statements;
            if (!AstUtil.hasConstructorCallStatement(bodyStmts)) {
                try {
                    bodyStmts.add(0, AstUtil.createDefaultSuperConstructorCall(this.thisClazz));
                }
                catch (AmbiguousMethodException | MethodNotFoundException ex) {
                    this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "default constructor not found", m.offset);
                }
            }
            int stmtsSize = mbody.statements.size();
            assert (stmtsSize > 0);
            Statement firstStmt = mbody.statements.get(0);
            if (!AstUtil.isConstructorCallStatement(firstStmt)) {
                throw new RuntimeException("missing constructor call");
            }
            mbody.statements.addAll(1, this.thisClazz.initStmts);
        }
    }

    @Nonnull
    private ObjectType getTypeForGeneric(Type type) {
        if (Types.NULL_TYPE.equals(type)) {
            return Types.getRootType();
        }
        if (type instanceof PrimitiveType) {
            ObjectType objType = Types.getClassType((PrimitiveType)type);
            Objects.requireNonNull(objType);
            return objType;
        }
        return (ObjectType)type;
    }

    @Nullable
    private ExprNode getLambdaCall(String name, ExprNode namedExpr, ExprNode[] args, ParserRuleContext ctx) {
        Type namedExprType = namedExpr.getType();
        if (!Types.isFunctionType(namedExprType)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, name + " is not callable");
            return null;
        }
        return this.getObjectInvokeExpr(namedExpr, "call", args, ctx);
    }

    private void buildClassNodeMeta(ClassNode cn) {
        ParserRuleContext ctx = this.classNodeInitializer.getClassNodeDefContext(cn);
        if (ctx != null) {
            this.classNodeStructureBuilder.build(this.topClass, cn, ctx);
        }
        for (ClassNode c : cn.classes) {
            this.buildClassNodeMeta(c);
        }
    }

    private List<MethodDescriptor> getImportedPluginMethod(String methodName) {
        LinkedList<MethodDescriptor> results = new LinkedList<MethodDescriptor>();
        List<MethodDescriptor> staticImportedMds = this.getStaticImportedMethods(methodName);
        for (MethodDescriptor m : staticImportedMds) {
            if (!AnnotationUtil.has(m.getMethodNode().getAnnotations(), PluginMethod.class.getName())) continue;
            results.add(m);
        }
        return results;
    }

    private ClassNode createLambdaNode(ClassType inferredLambdaType, LambdaExpr lambdaExpr, KalangParser.LambdaExprContext ctx) {
        NewObjectExpr newExpr;
        ClassType functionType = lambdaExpr.getFunctionType();
        if (functionType == null) {
            functionType = inferredLambdaType;
        }
        if (functionType == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "missing type", lambdaExpr.offset);
            return null;
        }
        ClassNode lambdaClassNode = this.createFunctionClassNode(functionType, lambdaExpr, ctx);
        ClassType lambdaType = Types.getClassType(lambdaClassNode);
        try {
            newExpr = new NewObjectExpr(lambdaType, new ExprNode[0], this.thisClazz);
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
        lambdaExpr.setInitExpr(newExpr);
        this.thisClazz.classes.add(lambdaClassNode);
        return lambdaClassNode;
    }

    private InvocationExpr onInvocationExpr(InvocationExpr invocationExpr) {
        ExprNode[] args = invocationExpr.getArguments();
        Type[] paramTypes = invocationExpr.getMethod().getParameterTypes();
        HashMap<GenericType, Type> inferredTypes = new HashMap<GenericType, Type>();
        for (int i = 0; i < args.length; ++i) {
            boolean isInit;
            ExprNode arg = args[i];
            if (!(arg instanceof LambdaExpr)) continue;
            boolean bl = isInit = ((LambdaExpr)arg).getInitExpr() != null;
            if (isInit) continue;
            ClassType lambdaType = (ClassType)paramTypes[i];
            KalangParser.LambdaExprContext ctx = this.lambdaExprCtxMap.get(arg);
            ClassNode lambaClassNode = this.createLambdaNode(lambdaType, (LambdaExpr)arg, ctx);
            Map<GenericType, Type> iTypes = lambaClassNode.inferredGenericTypes;
            if (iTypes.isEmpty()) continue;
            inferredTypes.putAll(iTypes);
        }
        if (!inferredTypes.isEmpty()) {
            MethodDescriptor md = invocationExpr.getMethod();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!(paramTypes[i] instanceof ClassType)) continue;
                paramTypes[i] = ((ClassType)paramTypes[i]).toParameterized(inferredTypes);
            }
            MethodDescriptor newMd = md.toParameterized(inferredTypes, paramTypes);
            if (invocationExpr instanceof StaticInvokeExpr) {
                invocationExpr = new StaticInvokeExpr(((StaticInvokeExpr)invocationExpr).getInvokeClass(), newMd, args);
            } else if (invocationExpr instanceof ObjectInvokeExpr) {
                invocationExpr = new ObjectInvokeExpr(((ObjectInvokeExpr)invocationExpr).getInvokeTarget(), newMd, args);
            }
        }
        return invocationExpr;
    }

    static class VarInfo {
        public Type type;
        public String name;
        public int modifier;

        VarInfo() {
        }
    }
}

