/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.compiler.FieldNotFoundException;
import kalang.compiler.antlr.KalangParser;
import kalang.compiler.antlr.KalangParserBaseVisitor;
import kalang.compiler.ast.AnnotationNode;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ClassReference;
import kalang.compiler.ast.ConstExpr;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.FieldExpr;
import kalang.compiler.ast.ObjectFieldExpr;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisReporter;
import kalang.compiler.compile.SemanticAnalyzer;
import kalang.compiler.compile.TypeNameResolver;
import kalang.compiler.core.ArrayType;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.GenericType;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.core.WildcardType;
import kalang.compiler.exception.Exceptions;
import kalang.compiler.util.InvalidModifierException;
import kalang.compiler.util.ModifierUtil;
import kalang.compiler.util.OffsetRangeHelper;
import kalang.compiler.util.StringLiteralUtil;
import kalang.type.FunctionClasses;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class AstBuilderBase
extends KalangParserBaseVisitor<Object> {
    protected final DiagnosisReporter diagnosisReporter;
    protected final SemanticAnalyzer semanticAnalyzer;
    private CompilationUnit compilationUnit;

    public AstBuilderBase(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.diagnosisReporter = new DiagnosisReporter(compilationUnit);
        this.semanticAnalyzer = new SemanticAnalyzer(compilationUnit, compilationUnit.getCompileContext().getAstLoader());
    }

    abstract ClassNode getCurrentClass();

    abstract ClassNode getTopClass();

    protected int parseModifier(KalangParser.VarModifierContext modifier) {
        int defaultModifier = 1;
        if (modifier == null) {
            return defaultModifier;
        }
        String modifierText = this.parseTreeToText((ParseTree)modifier);
        if (modifierText.isEmpty()) {
            return defaultModifier;
        }
        try {
            return ModifierUtil.parse(modifierText);
        }
        catch (InvalidModifierException ex) {
            this.handleSyntaxError(ex.getMessage(), modifier);
            return defaultModifier;
        }
    }

    protected void handleSyntaxError(String msg, Token token) {
        this.handleSyntaxError(msg, ParserRuleContext.EMPTY, token, token);
    }

    protected void handleSyntaxError(String msg, ParserRuleContext tree) {
        this.handleSyntaxError(msg, tree, tree.start, tree.stop);
    }

    protected void handleSyntaxError(String desc, ParserRuleContext rule, Token start, Token stop) {
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, desc, start, stop);
    }

    protected void mapAst(@Nonnull AstNode node, @Nonnull ParserRuleContext tree) {
        node.offset = OffsetRangeHelper.getOffsetRange(tree);
    }

    protected void mapAst(@Nonnull AstNode node, @Nonnull Token token) {
        node.offset = OffsetRangeHelper.getOffsetRange(token);
    }

    @Nullable
    protected ClassNode resolveNamedClass(String id, ClassNode topClass, ClassNode currentClass) {
        TypeNameResolver typeNameResolver = this.compilationUnit.getTypeNameResolver();
        AstLoader astLoader = this.compilationUnit.getCompileContext().getAstLoader();
        String resolvedName = typeNameResolver.resolve(id, topClass, currentClass);
        ClassNode ast = resolvedName == null ? null : astLoader.getAst(resolvedName);
        return ast;
    }

    protected ObjectType parseLambdaType(KalangParser.LambdaTypeContext ctx) {
        int maxParamCount;
        NullableKind nullable = ctx.nullable == null ? NullableKind.NONNULL : NullableKind.NULLABLE;
        KalangParser.TypeContext returnTypeCtx = ctx.returnType;
        Type returnType = this.parseType(returnTypeCtx);
        List<KalangParser.TypeContext> paramTypeCtxList = ctx.paramsTypes;
        int paramCount = paramTypeCtxList.size();
        if (paramCount > (maxParamCount = FunctionClasses.CLASSES.length - 1)) {
            String msg = "only support " + maxParamCount + " parameters";
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, msg, ctx);
            return Types.getRootType();
        }
        Type[] paramTypes = new Type[paramCount];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = this.parseType(paramTypeCtxList.get(i));
        }
        return Types.getFunctionType(returnType, paramTypes, nullable);
    }

    @Nullable
    protected Type parseType(KalangParser.TypeContext ctx) {
        KalangParser.ClassTypeContext ct = ctx.classType();
        KalangParser.PrimitiveTypeContext pt = ctx.primitiveType();
        if (ct != null) {
            return this.parseClassType(ct);
        }
        if (pt != null) {
            return Types.getPrimitiveType(pt.getText());
        }
        NullableKind nullable = ctx.nullable != null ? NullableKind.NULLABLE : NullableKind.NONNULL;
        KalangParser.TypeContext t = ctx.type();
        Type cpt = this.parseType(t);
        if (cpt == null) {
            return null;
        }
        return Types.getArrayType(cpt, nullable);
    }

    @Nullable
    protected ObjectType parseClassType(KalangParser.ClassTypeContext ctx) {
        NullableKind nullable = ctx.nullable == null ? NullableKind.NONNULL : NullableKind.NULLABLE;
        KalangParser.LambdaTypeContext lambdaType = ctx.lambdaType();
        if (lambdaType != null) {
            return this.parseLambdaType(lambdaType);
        }
        Token rawTypeToken = ctx.rawClass;
        LinkedList<String> classNameParts = new LinkedList<String>();
        for (Token token : ctx.paths) {
            classNameParts.add(token.getText());
        }
        if (ctx.innerClass != null) {
            classNameParts.add(rawTypeToken.getText() + "$" + ctx.innerClass.getText());
        } else {
            classNameParts.add(rawTypeToken.getText());
        }
        String rawType = String.join((CharSequence)".", classNameParts);
        for (GenericType gt : this.getCurrentClass().getGenericTypes()) {
            if (!rawType.equals(gt.getName())) continue;
            return gt;
        }
        ObjectType objectType = this.requireClassType(rawType, rawTypeToken);
        if (objectType == null) {
            return null;
        }
        ClassNode clazzNode = objectType.getClassNode();
        GenericType[] clzDeclaredGenericTypes = clazzNode.getGenericTypes();
        List<KalangParser.ParameterizedElementTypeContext> parameterTypes = ctx.parameterTypes;
        if (parameterTypes != null && !parameterTypes.isEmpty()) {
            Type[] typeArguments = new Type[parameterTypes.size()];
            if (parameterTypes != null && parameterTypes.size() > 0) {
                if (clzDeclaredGenericTypes.length != parameterTypes.size()) {
                    this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "wrong number of type arguments", ctx);
                    return null;
                }
                for (int i = 0; i < typeArguments.length; ++i) {
                    typeArguments[i] = this.parseParameterizedElementType(parameterTypes.get(i));
                    if (typeArguments[i] != null) continue;
                    return null;
                }
            }
            return Types.getClassType(objectType.getClassNode(), typeArguments, nullable);
        }
        return Types.getClassType(objectType.getClassNode(), nullable);
    }

    @Nullable
    protected ObjectType requireClassType(@Nonnull Token token) {
        return this.requireClassType(token.getText(), token);
    }

    @Nullable
    protected ObjectType requireClassType(@Nonnull String id, @Nonnull Token token) {
        ClassNode ast = this.requireAst(id, token);
        if (ast == null) {
            return null;
        }
        return Types.getClassType(ast, new Type[0]);
    }

    @Nullable
    protected ClassNode requireAst(Token token) {
        return this.requireAst(token.getText(), token);
    }

    @Nullable
    protected ClassNode requireAst(String id, Token token) {
        ClassNode ast = this.resolveNamedClass(id, this.getTopClass(), this.getCurrentClass());
        if (ast == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "class not found:" + id, token);
        }
        return ast;
    }

    protected ConstExpr parseLiteral(KalangParser.LiteralContext ctx, @Nullable Type exceptedType) {
        Object v;
        String t = ctx.getText();
        if (ctx.IntegerLiteral() != null) {
            Number intValue;
            if (t.toUpperCase().endsWith("L")) {
                t = t.substring(0, t.length() - 1);
                exceptedType = Types.LONG_TYPE;
            } else if (t.toLowerCase().endsWith("i")) {
                t = t.substring(0, t.length() - 1);
                exceptedType = Types.INT_TYPE;
            }
            try {
                intValue = StringLiteralUtil.parseInteger(t);
            }
            catch (NumberFormatException ex) {
                this.handleSyntaxError("invalid number", ctx);
                return null;
            }
            v = Types.BYTE_TYPE.equals(exceptedType) ? (Number)intValue.byteValue() : (Number)(Types.LONG_TYPE.equals(exceptedType) ? (Number)intValue.longValue() : (Number)intValue);
        } else if (ctx.FloatingPointLiteral() != null) {
            Number floatPointValue;
            try {
                floatPointValue = StringLiteralUtil.parseFloatPoint(t);
            }
            catch (NumberFormatException ex) {
                this.handleSyntaxError("invalid float value", ctx);
                return null;
            }
            v = Types.FLOAT_TYPE.equals(exceptedType) ? (Number)Float.valueOf(floatPointValue.floatValue()) : (Number)floatPointValue;
        } else if (ctx.BooleanLiteral() != null) {
            v = Boolean.parseBoolean(t);
        } else if (ctx.CharacterLiteral() != null) {
            String strValue = StringLiteralUtil.parse(t);
            char[] chars = strValue.toCharArray();
            v = Character.valueOf(chars[1]);
        } else if (ctx.StringLiteral() != null) {
            v = StringLiteralUtil.parse(t.substring(1, t.length() - 1));
        } else if (ctx.MultiLineStringLiteral() != null) {
            v = StringLiteralUtil.parse(t.substring(3, t.length() - 3));
        } else if (ctx.Identifier() != null) {
            ClassReference cr = this.requireClassReference(ctx.Identifier().getSymbol());
            v = cr;
        } else if (ctx.getText().equals("null")) {
            v = null;
        } else {
            throw Exceptions.unexceptedValue(ctx.getText());
        }
        ConstExpr ce = new ConstExpr(v);
        this.mapAst((AstNode)ce, ctx);
        return ce;
    }

    @Nullable
    protected AnnotationNode parseAnnotation(KalangParser.AnnotationContext ctx) {
        ClassNode anType = this.requireAst(ctx.annotationType);
        if (anType == null) {
            return null;
        }
        List<Token> vk = ctx.annotationValueKey;
        KalangParser.LiteralContext dv = ctx.annotationDefaultValue;
        AnnotationNode anNode = new AnnotationNode(anType);
        if (vk != null && vk.size() > 0) {
            List<KalangParser.LiteralContext> anValues = ctx.annotationValue;
            int ksize = vk.size();
            for (int i = 0; i < ksize; ++i) {
                String kname = vk.get(i).getText();
                ConstExpr value = this.parseLiteral(anValues.get(i), null);
                anNode.values.put(kname, value);
            }
        } else if (dv != null) {
            ConstExpr defaultValue = this.parseLiteral(dv, null);
            anNode.values.put("value", defaultValue);
        }
        if (!this.semanticAnalyzer.validateAnnotation(anNode)) {
            return null;
        }
        return anNode;
    }

    protected List<AnnotationNode> getAnnotations(@Nullable List<KalangParser.AnnotationContext> ctxs) {
        LinkedList<AnnotationNode> list = new LinkedList<AnnotationNode>();
        if (ctxs != null) {
            for (KalangParser.AnnotationContext an : ctxs) {
                AnnotationNode anNode = this.parseAnnotation(an);
                if (anNode == null) continue;
                list.add(anNode);
            }
        }
        return list;
    }

    @Nullable
    protected ExprNode getObjectFieldExpr(ExprNode expr, String fieldName, @Nullable ParserRuleContext rule) {
        FieldExpr ret;
        Type type = expr.getType();
        if (!(type instanceof ObjectType)) {
            return null;
        }
        ObjectType exprType = (ObjectType)type;
        if (exprType instanceof ArrayType) {
            return null;
        }
        try {
            ret = ObjectFieldExpr.create(expr, fieldName, exprType.getClassNode());
        }
        catch (FieldNotFoundException ex) {
            return null;
        }
        if (rule != null) {
            this.mapAst((AstNode)ret, rule);
        }
        return ret;
    }

    protected List<MethodDescriptor> getStaticMethods(ClassNode clazz, String methodName) {
        ClassType scType = Types.getClassType(clazz);
        MethodDescriptor[] scMethods = scType.getMethodDescriptors(this.getCurrentClass(), methodName, true, true);
        LinkedList<MethodDescriptor> scStaticMethods = new LinkedList<MethodDescriptor>();
        for (MethodDescriptor m : scMethods) {
            if (!Modifier.isStatic(m.getModifier())) continue;
            scStaticMethods.add(m);
        }
        return scStaticMethods;
    }

    protected List<MethodDescriptor> getStaticImportedMethods(String methodName) {
        ClassNode classOfStaticImport = this.compilationUnit.staticImportMembers.get(methodName);
        if (classOfStaticImport != null) {
            return this.getStaticMethods(classOfStaticImport, methodName);
        }
        for (int i = this.compilationUnit.staticImportPaths.size() - 1; i >= 0; --i) {
            ClassNode sc = this.compilationUnit.staticImportPaths.get(i);
            List<MethodDescriptor> mds = this.getStaticMethods(sc, methodName);
            if (mds.isEmpty()) continue;
            return mds;
        }
        return Collections.EMPTY_LIST;
    }

    private String parseTreeToText(ParseTree ctx) {
        if (ctx instanceof TerminalNode) {
            return ctx.getText();
        }
        StringBuilder sb = new StringBuilder();
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.parseTreeToText(ctx.getChild(i)));
        }
        return sb.toString();
    }

    private Type parseParameterizedElementType(KalangParser.ParameterizedElementTypeContext ctx) {
        KalangParser.TypeContext type = ctx.type();
        if (type != null) {
            return this.parseType(type);
        }
        return this.parseWildcardType(ctx.wildcardType());
    }

    private Type parseWildcardType(KalangParser.WildcardTypeContext ctx) {
        ObjectType classType = this.parseClassType(ctx.classType());
        if (classType == null) {
            return null;
        }
        Type[] bounds = new Type[]{classType};
        String boundKind = ctx.boundKind.getText();
        if (boundKind.equals("super")) {
            return new WildcardType(new Type[]{Types.getRootType()}, bounds);
        }
        return new WildcardType(bounds, null);
    }

    @Nullable
    private ClassReference requireClassReference(@Nonnull Token token) {
        ClassNode ast = this.requireAst(token);
        if (ast == null) {
            return null;
        }
        return new ClassReference(ast);
    }
}

